/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ApplicationExitInfo;
import android.content.Context;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CrashlyticsLifecycleEvents;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportDataCapture;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator$$ExternalSyntheticLambda1;
import com.google.firebase.crashlytics.internal.metadata.LogFileManager;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Executor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SessionReportingCoordinator
implements CrashlyticsLifecycleEvents {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int EVENT_THREAD_IMPORTANCE = 4;
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    private final CrashlyticsReportDataCapture dataCapture;
    private final LogFileManager logFileManager;
    private final UserMetadata reportMetadata;
    private final CrashlyticsReportPersistence reportPersistence;
    private final DataTransportCrashlyticsReportSender reportsSender;

    public static /* synthetic */ boolean $r8$lambda$E0EcUvGAcoqjPOmC0PORx8-bHg0(SessionReportingCoordinator sessionReportingCoordinator, Task task) {
        return sessionReportingCoordinator.onReportSendComplete(task);
    }

    SessionReportingCoordinator(CrashlyticsReportDataCapture crashlyticsReportDataCapture, CrashlyticsReportPersistence crashlyticsReportPersistence, DataTransportCrashlyticsReportSender dataTransportCrashlyticsReportSender, LogFileManager logFileManager, UserMetadata userMetadata) {
        this.dataCapture = crashlyticsReportDataCapture;
        this.reportPersistence = crashlyticsReportPersistence;
        this.reportsSender = dataTransportCrashlyticsReportSender;
        this.logFileManager = logFileManager;
        this.reportMetadata = userMetadata;
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event event) {
        return this.addLogsAndCustomKeysToEvent(event, this.logFileManager, this.reportMetadata);
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event event, LogFileManager list, UserMetadata object) {
        CrashlyticsReport.Session.Event.Builder builder = event.toBuilder();
        if ((list = ((LogFileManager)((Object)list)).getLogString()) != null) {
            builder.setLog(CrashlyticsReport.Session.Event.Log.builder().setContent((String)((Object)list)).build());
        } else {
            Logger.getLogger().v("No log data to include with this event.");
        }
        list = SessionReportingCoordinator.getSortedCustomAttributes(((UserMetadata)object).getCustomKeys());
        object = SessionReportingCoordinator.getSortedCustomAttributes(((UserMetadata)object).getInternalKeys());
        if (!list.isEmpty() || !object.isEmpty()) {
            builder.setApp(event.getApp().toBuilder().setCustomAttributes(ImmutableList.from(list)).setInternalKeys(ImmutableList.from(object)).build());
        }
        return builder.build();
    }

    private static CrashlyticsReport.ApplicationExitInfo convertApplicationExitInfo(ApplicationExitInfo applicationExitInfo) {
        Object object;
        block3: {
            Object var1_1 = null;
            InputStream inputStream = applicationExitInfo.getTraceInputStream();
            object = var1_1;
            if (inputStream == null) break block3;
            try {
                object = SessionReportingCoordinator.convertInputStreamToString(inputStream);
            }
            catch (IOException iOException) {
                object = Logger.getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not get input trace in application exit info: ");
                stringBuilder.append(applicationExitInfo.toString());
                stringBuilder.append(" Error: ");
                stringBuilder.append(iOException);
                ((Logger)object).w(stringBuilder.toString());
                object = var1_1;
            }
        }
        return CrashlyticsReport.ApplicationExitInfo.builder().setImportance(applicationExitInfo.getImportance()).setProcessName(applicationExitInfo.getProcessName()).setReasonCode(applicationExitInfo.getReason()).setTimestamp(applicationExitInfo.getTimestamp()).setPid(applicationExitInfo.getPid()).setPss(applicationExitInfo.getPss()).setRss(applicationExitInfo.getRss()).setTraceFile((String)object).build();
    }

    public static String convertInputStreamToString(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
    }

    public static SessionReportingCoordinator create(Context context, IdManager idManager, FileStore fileStore, AppData appData, LogFileManager logFileManager, UserMetadata userMetadata, StackTraceTrimmingStrategy stackTraceTrimmingStrategy, SettingsProvider settingsProvider, OnDemandCounter onDemandCounter) {
        return new SessionReportingCoordinator(new CrashlyticsReportDataCapture(context, idManager, appData, stackTraceTrimmingStrategy), new CrashlyticsReportPersistence(fileStore, settingsProvider), DataTransportCrashlyticsReportSender.create(context, settingsProvider, onDemandCounter), logFileManager, userMetadata);
    }

    private ApplicationExitInfo findRelevantApplicationExitInfo(String object, List<ApplicationExitInfo> applicationExitInfo2) {
        long l = this.reportPersistence.getStartTimestampMillis((String)object);
        for (ApplicationExitInfo applicationExitInfo2 : applicationExitInfo2) {
            if (applicationExitInfo2.getTimestamp() < l) {
                return null;
            }
            if (applicationExitInfo2.getReason() != 6) continue;
            return applicationExitInfo2;
        }
        return null;
    }

    private static List<CrashlyticsReport.CustomAttribute> getSortedCustomAttributes(Map<String, String> object2) {
        ArrayList<CrashlyticsReport.CustomAttribute> arrayList = new ArrayList<CrashlyticsReport.CustomAttribute>();
        arrayList.ensureCapacity(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            arrayList.add(CrashlyticsReport.CustomAttribute.builder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        Collections.sort(arrayList, SessionReportingCoordinator$$ExternalSyntheticLambda1.INSTANCE);
        return arrayList;
    }

    static /* synthetic */ int lambda$getSortedCustomAttributes$0(CrashlyticsReport.CustomAttribute customAttribute, CrashlyticsReport.CustomAttribute customAttribute2) {
        return customAttribute.getKey().compareTo(customAttribute2.getKey());
    }

    private boolean onReportSendComplete(Task<CrashlyticsReportWithSessionId> object) {
        if (((Task)object).isSuccessful()) {
            Object object2 = ((Task)object).getResult();
            Logger logger = Logger.getLogger();
            object = new StringBuilder();
            ((StringBuilder)object).append("Crashlytics report successfully enqueued to DataTransport: ");
            ((StringBuilder)object).append(((CrashlyticsReportWithSessionId)object2).getSessionId());
            logger.d(((StringBuilder)object).toString());
            object = ((CrashlyticsReportWithSessionId)object2).getReportFile();
            if (((File)object).delete()) {
                logger = Logger.getLogger();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Deleted report file: ");
                ((StringBuilder)object2).append(((File)object).getPath());
                logger.d(((StringBuilder)object2).toString());
            } else {
                logger = Logger.getLogger();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Crashlytics could not delete report file: ");
                ((StringBuilder)object2).append(((File)object).getPath());
                logger.w(((StringBuilder)object2).toString());
            }
            return true;
        }
        Logger.getLogger().w("Crashlytics report could not be enqueued to DataTransport", ((Task)object).getException());
        return false;
    }

    private void persistEvent(Throwable object, Thread thread2, String string2, String string3, long l, boolean bl) {
        boolean bl2 = string3.equals(EVENT_TYPE_CRASH);
        object = this.dataCapture.captureEventData((Throwable)object, thread2, string3, l, 4, 8, bl);
        this.reportPersistence.persistEvent(this.addLogsAndCustomKeysToEvent((CrashlyticsReport.Session.Event)object), string2, bl2);
    }

    public void finalizeSessionWithNativeEvent(String string2, List<NativeSessionFile> object) {
        Logger.getLogger().d("SessionReportingCoordinator#finalizeSessionWithNativeEvent");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<NativeSessionFile> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next().asFilePayload();
            if (object == null) continue;
            arrayList.add(object);
        }
        this.reportPersistence.finalizeSessionWithNativeEvent(string2, CrashlyticsReport.FilesPayload.builder().setFiles(ImmutableList.from(arrayList)).build());
    }

    public void finalizeSessions(long l, String string2) {
        this.reportPersistence.finalizeReports(string2, l);
    }

    public boolean hasReportsToSend() {
        return this.reportPersistence.hasFinalizedReports();
    }

    public SortedSet<String> listSortedOpenSessionIds() {
        return this.reportPersistence.getOpenSessionIds();
    }

    @Override
    public void onBeginSession(String object, long l) {
        object = this.dataCapture.captureReportData((String)object, l);
        this.reportPersistence.persistReport((CrashlyticsReport)object);
    }

    @Override
    public void onCustomKey(String string2, String string3) {
        this.reportMetadata.setCustomKey(string2, string3);
    }

    @Override
    public void onLog(long l, String string2) {
        this.logFileManager.writeToLog(l, string2);
    }

    @Override
    public void onUserId(String string2) {
        this.reportMetadata.setUserId(string2);
    }

    public void persistFatalEvent(Throwable throwable, Thread thread2, String string2, long l) {
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Persisting fatal event for session ");
        stringBuilder.append(string2);
        logger.v(stringBuilder.toString());
        this.persistEvent(throwable, thread2, string2, EVENT_TYPE_CRASH, l, true);
    }

    public void persistNonFatalEvent(Throwable throwable, Thread thread2, String string2, long l) {
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Persisting non-fatal event for session ");
        stringBuilder.append(string2);
        logger.v(stringBuilder.toString());
        this.persistEvent(throwable, thread2, string2, EVENT_TYPE_LOGGED, l, false);
    }

    public void persistRelevantAppExitInfoEvent(String string2, List<ApplicationExitInfo> object, LogFileManager object2, UserMetadata userMetadata) {
        if ((object = this.findRelevantApplicationExitInfo(string2, (List<ApplicationExitInfo>)object)) == null) {
            object = Logger.getLogger();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("No relevant ApplicationExitInfo occurred during session: ");
            ((StringBuilder)object2).append(string2);
            ((Logger)object).v(((StringBuilder)object2).toString());
            return;
        }
        CrashlyticsReport.Session.Event event = this.dataCapture.captureAnrEventData(SessionReportingCoordinator.convertApplicationExitInfo((ApplicationExitInfo)object));
        Logger logger = Logger.getLogger();
        object = new StringBuilder();
        ((StringBuilder)object).append("Persisting anr for session ");
        ((StringBuilder)object).append(string2);
        logger.d(((StringBuilder)object).toString());
        this.reportPersistence.persistEvent(this.addLogsAndCustomKeysToEvent(event, (LogFileManager)object2, userMetadata), string2, true);
    }

    public void removeAllReports() {
        this.reportPersistence.deleteAllReports();
    }

    public Task<Void> sendReports(Executor executor) {
        return this.sendReports(executor, null);
    }

    public Task<Void> sendReports(Executor executor, String string2) {
        Object object = this.reportPersistence.loadFinalizedReports();
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            CrashlyticsReportWithSessionId crashlyticsReportWithSessionId = (CrashlyticsReportWithSessionId)object.next();
            if (string2 != null && !string2.equals(crashlyticsReportWithSessionId.getSessionId())) continue;
            DataTransportCrashlyticsReportSender dataTransportCrashlyticsReportSender = this.reportsSender;
            boolean bl = string2 != null;
            arrayList.add(dataTransportCrashlyticsReportSender.enqueueReport(crashlyticsReportWithSessionId, bl).continueWith(executor, new SessionReportingCoordinator$$ExternalSyntheticLambda0(this)));
        }
        return Tasks.whenAll(arrayList);
    }
}

