/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.firebase.crashlytics.internal.metadata.FileLogStore;
import com.google.firebase.crashlytics.internal.metadata.QueueFileLogStore;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.File;

public class LogFileManager {
    private static final String LOGFILE_NAME = "userlog";
    static final int MAX_LOG_SIZE = 65536;
    private static final NoopLogStore NOOP_LOG_STORE = new NoopLogStore();
    private FileLogStore currentLog;
    private final FileStore fileStore;

    public LogFileManager(FileStore fileStore) {
        this.fileStore = fileStore;
        this.currentLog = NOOP_LOG_STORE;
    }

    public LogFileManager(FileStore fileStore, String string2) {
        this(fileStore);
        this.setCurrentSession(string2);
    }

    private File getWorkingFileForSession(String string2) {
        return this.fileStore.getSessionFile(string2, LOGFILE_NAME);
    }

    public void clearLog() {
        this.currentLog.deleteLogFile();
    }

    public byte[] getBytesForLog() {
        return this.currentLog.getLogAsBytes();
    }

    public String getLogString() {
        return this.currentLog.getLogAsString();
    }

    public final void setCurrentSession(String string2) {
        this.currentLog.closeLogFile();
        this.currentLog = NOOP_LOG_STORE;
        if (string2 == null) {
            return;
        }
        this.setLogFile(this.getWorkingFileForSession(string2), 65536);
    }

    void setLogFile(File file, int n) {
        this.currentLog = new QueueFileLogStore(file, n);
    }

    public void writeToLog(long l, String string2) {
        this.currentLog.writeToLog(l, string2);
    }

    private static final class NoopLogStore
    implements FileLogStore {
        private NoopLogStore() {
        }

        @Override
        public void closeLogFile() {
        }

        @Override
        public void deleteLogFile() {
        }

        @Override
        public byte[] getLogAsBytes() {
            return null;
        }

        @Override
        public String getLogAsString() {
            return null;
        }

        @Override
        public void writeToLog(long l, String string2) {
        }
    }
}

