/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.metadata.FileLogStore;
import com.google.firebase.crashlytics.internal.metadata.QueueFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;

class QueueFileLogStore
implements FileLogStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private QueueFile logFile;
    private final int maxLogSize;
    private final File workingFile;

    QueueFileLogStore(File file, int n) {
        this.workingFile = file;
        this.maxLogSize = n;
    }

    private void doWriteToLog(long l, String object) {
        if (this.logFile == null) {
            return;
        }
        String string2 = object;
        if (object == null) {
            string2 = "null";
        }
        int n = this.maxLogSize / 4;
        object = string2;
        try {
            if (string2.length() > n) {
                object = new StringBuilder();
                ((StringBuilder)object).append("...");
                ((StringBuilder)object).append(string2.substring(string2.length() - n));
                object = ((StringBuilder)object).toString();
            }
            object = ((String)object).replaceAll("\r", " ").replaceAll("\n", " ");
            object = String.format(Locale.US, "%d %s%n", l, object).getBytes(UTF_8);
            this.logFile.add((byte[])object);
            while (!this.logFile.isEmpty() && this.logFile.usedBytes() > this.maxLogSize) {
                this.logFile.remove();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger().e("There was a problem writing to the Crashlytics log.", iOException);
        }
    }

    private LogBytes getLogBytes() {
        if (!this.workingFile.exists()) {
            return null;
        }
        this.openLogFile();
        Object object = this.logFile;
        if (object == null) {
            return null;
        }
        int[] nArray = new int[]{0};
        object = new byte[((QueueFile)object).usedBytes()];
        try {
            QueueFile queueFile = this.logFile;
            QueueFile.ElementReader elementReader = new QueueFile.ElementReader((byte[])object, nArray){
                final /* synthetic */ byte[] val$logBytes;
                final /* synthetic */ int[] val$offsetHolder;
                {
                    this.val$logBytes = byArray;
                    this.val$offsetHolder = nArray;
                }

                @Override
                public void read(InputStream inputStream, int n) throws IOException {
                    int[] nArray;
                    try {
                        inputStream.read(this.val$logBytes, this.val$offsetHolder[0], n);
                        nArray = this.val$offsetHolder;
                    }
                    catch (Throwable throwable) {
                        inputStream.close();
                        throw throwable;
                    }
                    nArray[0] = nArray[0] + n;
                    inputStream.close();
                }
            };
            queueFile.forEach(elementReader);
        }
        catch (IOException iOException) {
            Logger.getLogger().e("A problem occurred while reading the Crashlytics log file.", iOException);
        }
        return new LogBytes((byte[])object, nArray[0]);
    }

    private void openLogFile() {
        if (this.logFile == null) {
            try {
                QueueFile queueFile;
                this.logFile = queueFile = new QueueFile(this.workingFile);
            }
            catch (IOException iOException) {
                Logger logger = Logger.getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not open log file: ");
                stringBuilder.append(this.workingFile);
                logger.e(stringBuilder.toString(), iOException);
            }
        }
    }

    @Override
    public void closeLogFile() {
        CommonUtils.closeOrLog(this.logFile, "There was a problem closing the Crashlytics log file.");
        this.logFile = null;
    }

    @Override
    public void deleteLogFile() {
        this.closeLogFile();
        this.workingFile.delete();
    }

    @Override
    public byte[] getLogAsBytes() {
        LogBytes logBytes = this.getLogBytes();
        if (logBytes == null) {
            return null;
        }
        byte[] byArray = new byte[logBytes.offset];
        System.arraycopy(logBytes.bytes, 0, byArray, 0, logBytes.offset);
        return byArray;
    }

    @Override
    public String getLogAsString() {
        Object object = this.getLogAsBytes();
        object = object != null ? (Object)new String((byte[])object, UTF_8) : null;
        return object;
    }

    @Override
    public void writeToLog(long l, String string2) {
        this.openLogFile();
        this.doWriteToLog(l, string2);
    }

    private static class LogBytes {
        public final byte[] bytes;
        public final int offset;

        LogBytes(byte[] byArray, int n) {
            this.bytes = byArray;
            this.offset = n;
        }
    }
}

