/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public final class ImmutableList<E>
implements List<E>,
RandomAccess {
    private final List<E> immutableList;

    private ImmutableList(List<E> list) {
        this.immutableList = Collections.unmodifiableList(list);
    }

    public static <E> ImmutableList<E> from(List<E> list) {
        return new ImmutableList<E>(list);
    }

    public static <E> ImmutableList<E> from(E ... EArray) {
        return new ImmutableList<E>(Arrays.asList(EArray));
    }

    @Override
    public void add(int n, E e) {
        this.immutableList.add(n, e);
    }

    @Override
    public boolean add(E e) {
        return this.immutableList.add(e);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.immutableList.addAll(n, collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.immutableList.addAll(collection);
    }

    @Override
    public void clear() {
        this.immutableList.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.immutableList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.immutableList.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.immutableList.equals(object);
    }

    @Override
    public E get(int n) {
        return this.immutableList.get(n);
    }

    @Override
    public int hashCode() {
        return this.immutableList.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.immutableList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.immutableList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.immutableList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.immutableList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.immutableList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.immutableList.listIterator(n);
    }

    @Override
    public E remove(int n) {
        return this.immutableList.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.immutableList.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.immutableList.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.immutableList.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        return this.immutableList.set(n, e);
    }

    @Override
    public int size() {
        return this.immutableList.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.immutableList.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.immutableList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.immutableList.toArray(TArray);
    }
}

