/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model.serialization;

import android.util.Base64;
import android.util.JsonReader;
import com.google.firebase.crashlytics.internal.model.AutoCrashlyticsReportEncoder;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda1;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda2;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda3;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda4;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform$$ExternalSyntheticLambda5;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import java.io.IOException;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrashlyticsReportJsonTransform {
    private static final DataEncoder CRASHLYTICS_REPORT_JSON_ENCODER = new JsonDataEncoderBuilder().configureWith(AutoCrashlyticsReportEncoder.CONFIG).ignoreNullValues(true).build();

    public static /* synthetic */ CrashlyticsReport.Session.Event $r8$lambda$-MbNjt6enh3_27IyELZga1lBRnE(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEvent(jsonReader);
    }

    public static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame $r8$lambda$4s8CoJuYX6GniCnSQ9blv-x0UAE(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventFrame(jsonReader);
    }

    public static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.Thread $r8$lambda$GuwJSqrRyOux7gdIs2hcasuwZyE(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventThread(jsonReader);
    }

    public static /* synthetic */ CrashlyticsReport.FilesPayload.File $r8$lambda$gtp7HVGCmfilv97Jnlfp7uKMByE(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseFile(jsonReader);
    }

    public static /* synthetic */ CrashlyticsReport.Session.Event.Application.Execution.BinaryImage $r8$lambda$hVOu-kNYq4tUb1ixgTLpG9DeCdc(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseEventBinaryImage(jsonReader);
    }

    public static /* synthetic */ CrashlyticsReport.CustomAttribute $r8$lambda$xcqRtqatafHDts0kwSCvKzZoURs(JsonReader jsonReader) {
        return CrashlyticsReportJsonTransform.parseCustomAttribute(jsonReader);
    }

    private static CrashlyticsReport.Session.Application parseApp(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Application.Builder builder = CrashlyticsReport.Session.Application.builder();
        jsonReader.beginObject();
        block16: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1975623094: {
                    if (!string2.equals("displayVersion")) break;
                    n = 5;
                    break;
                }
                case 719853845: {
                    if (!string2.equals("installationUuid")) break;
                    n = 4;
                    break;
                }
                case 351608024: {
                    if (!string2.equals("version")) break;
                    n = 3;
                    break;
                }
                case 213652010: {
                    if (!string2.equals("developmentPlatformVersion")) break;
                    n = 2;
                    break;
                }
                case -519438642: {
                    if (!string2.equals("developmentPlatform")) break;
                    n = 1;
                    break;
                }
                case -1618432855: {
                    if (!string2.equals("identifier")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block16;
                }
                case 5: {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block16;
                }
                case 4: {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block16;
                }
                case 3: {
                    builder.setVersion(jsonReader.nextString());
                    continue block16;
                }
                case 2: {
                    builder.setDevelopmentPlatformVersion(jsonReader.nextString());
                    continue block16;
                }
                case 1: {
                    builder.setDevelopmentPlatform(jsonReader.nextString());
                    continue block16;
                }
                case 0: 
            }
            builder.setIdentifier(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.ApplicationExitInfo parseAppExitInfo(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.ApplicationExitInfo.Builder builder = CrashlyticsReport.ApplicationExitInfo.builder();
        jsonReader.beginObject();
        block20: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2125650548: {
                    if (!string2.equals("importance")) break;
                    n = 7;
                    break;
                }
                case 723857505: {
                    if (!string2.equals("traceFile")) break;
                    n = 6;
                    break;
                }
                case 722137681: {
                    if (!string2.equals("reasonCode")) break;
                    n = 5;
                    break;
                }
                case 202325402: {
                    if (!string2.equals("processName")) break;
                    n = 4;
                    break;
                }
                case 55126294: {
                    if (!string2.equals("timestamp")) break;
                    n = 3;
                    break;
                }
                case 113234: {
                    if (!string2.equals("rss")) break;
                    n = 2;
                    break;
                }
                case 111312: {
                    if (!string2.equals("pss")) break;
                    n = 1;
                    break;
                }
                case 110987: {
                    if (!string2.equals("pid")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block20;
                }
                case 7: {
                    builder.setImportance(jsonReader.nextInt());
                    continue block20;
                }
                case 6: {
                    builder.setTraceFile(jsonReader.nextString());
                    continue block20;
                }
                case 5: {
                    builder.setReasonCode(jsonReader.nextInt());
                    continue block20;
                }
                case 4: {
                    builder.setProcessName(jsonReader.nextString());
                    continue block20;
                }
                case 3: {
                    builder.setTimestamp(jsonReader.nextLong());
                    continue block20;
                }
                case 2: {
                    builder.setRss(jsonReader.nextLong());
                    continue block20;
                }
                case 1: {
                    builder.setPss(jsonReader.nextLong());
                    continue block20;
                }
                case 0: 
            }
            builder.setPid(jsonReader.nextInt());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static <T> ImmutableList<T> parseArray(JsonReader jsonReader, ObjectParser<T> objectParser) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList.add(objectParser.parse(jsonReader));
        }
        jsonReader.endArray();
        return ImmutableList.from(arrayList);
    }

    private static CrashlyticsReport.CustomAttribute parseCustomAttribute(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.CustomAttribute.Builder builder = CrashlyticsReport.CustomAttribute.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            if (!string2.equals("key")) {
                if (!string2.equals("value")) {
                    jsonReader.skipValue();
                    continue;
                }
                builder.setValue(jsonReader.nextString());
                continue;
            }
            builder.setKey(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Device parseDevice(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Device.Builder builder = CrashlyticsReport.Session.Device.builder();
        jsonReader.beginObject();
        block22: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2078953423: {
                    if (!string2.equals("modelClass")) break;
                    n = 8;
                    break;
                }
                case 109757585: {
                    if (!string2.equals("state")) break;
                    n = 7;
                    break;
                }
                case 104069929: {
                    if (!string2.equals("model")) break;
                    n = 6;
                    break;
                }
                case 94848180: {
                    if (!string2.equals("cores")) break;
                    n = 5;
                    break;
                }
                case 81784169: {
                    if (!string2.equals("diskSpace")) break;
                    n = 4;
                    break;
                }
                case 3002454: {
                    if (!string2.equals("arch")) break;
                    n = 3;
                    break;
                }
                case 112670: {
                    if (!string2.equals("ram")) break;
                    n = 2;
                    break;
                }
                case -1969347631: {
                    if (!string2.equals("manufacturer")) break;
                    n = 1;
                    break;
                }
                case -1981332476: {
                    if (!string2.equals("simulator")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block22;
                }
                case 8: {
                    builder.setModelClass(jsonReader.nextString());
                    continue block22;
                }
                case 7: {
                    builder.setState(jsonReader.nextInt());
                    continue block22;
                }
                case 6: {
                    builder.setModel(jsonReader.nextString());
                    continue block22;
                }
                case 5: {
                    builder.setCores(jsonReader.nextInt());
                    continue block22;
                }
                case 4: {
                    builder.setDiskSpace(jsonReader.nextLong());
                    continue block22;
                }
                case 3: {
                    builder.setArch(jsonReader.nextInt());
                    continue block22;
                }
                case 2: {
                    builder.setRam(jsonReader.nextLong());
                    continue block22;
                }
                case 1: {
                    builder.setManufacturer(jsonReader.nextString());
                    continue block22;
                }
                case 0: 
            }
            builder.setSimulator(jsonReader.nextBoolean());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event parseEvent(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Builder builder = CrashlyticsReport.Session.Event.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 55126294: {
                    if (!string2.equals("timestamp")) break;
                    n = 4;
                    break;
                }
                case 3575610: {
                    if (!string2.equals("type")) break;
                    n = 3;
                    break;
                }
                case 107332: {
                    if (!string2.equals("log")) break;
                    n = 2;
                    break;
                }
                case 96801: {
                    if (!string2.equals("app")) break;
                    n = 1;
                    break;
                }
                case -1335157162: {
                    if (!string2.equals("device")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block14;
                }
                case 4: {
                    builder.setTimestamp(jsonReader.nextLong());
                    continue block14;
                }
                case 3: {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case 2: {
                    builder.setLog(CrashlyticsReportJsonTransform.parseEventLog(jsonReader));
                    continue block14;
                }
                case 1: {
                    builder.setApp(CrashlyticsReportJsonTransform.parseEventApp(jsonReader));
                    continue block14;
                }
                case 0: 
            }
            builder.setDevice(CrashlyticsReportJsonTransform.parseEventDevice(jsonReader));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application parseEventApp(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Builder builder = CrashlyticsReport.Session.Event.Application.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 928737948: {
                    if (!string2.equals("uiOrientation")) break;
                    n = 4;
                    break;
                }
                case 555169704: {
                    if (!string2.equals("customAttributes")) break;
                    n = 3;
                    break;
                }
                case -80231855: {
                    if (!string2.equals("internalKeys")) break;
                    n = 2;
                    break;
                }
                case -1090974952: {
                    if (!string2.equals("execution")) break;
                    n = 1;
                    break;
                }
                case -1332194002: {
                    if (!string2.equals("background")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block14;
                }
                case 4: {
                    builder.setUiOrientation(jsonReader.nextInt());
                    continue block14;
                }
                case 3: {
                    builder.setCustomAttributes(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda5.INSTANCE));
                    continue block14;
                }
                case 2: {
                    builder.setInternalKeys(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda5.INSTANCE));
                    continue block14;
                }
                case 1: {
                    builder.setExecution(CrashlyticsReportJsonTransform.parseEventExecution(jsonReader));
                    continue block14;
                }
                case 0: 
            }
            builder.setBackground(jsonReader.nextBoolean());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.BinaryImage parseEventBinaryImage(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1153765347: {
                    if (!string2.equals("baseAddress")) break;
                    n = 3;
                    break;
                }
                case 3601339: {
                    if (!string2.equals("uuid")) break;
                    n = 2;
                    break;
                }
                case 3530753: {
                    if (!string2.equals("size")) break;
                    n = 1;
                    break;
                }
                case 3373707: {
                    if (!string2.equals("name")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block12;
                }
                case 3: {
                    builder.setBaseAddress(jsonReader.nextLong());
                    continue block12;
                }
                case 2: {
                    builder.setUuidFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block12;
                }
                case 1: {
                    builder.setSize(jsonReader.nextLong());
                    continue block12;
                }
                case 0: 
            }
            builder.setName(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Device parseEventDevice(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Device.Builder builder = CrashlyticsReport.Session.Event.Device.builder();
        jsonReader.beginObject();
        block16: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1516795582: {
                    if (!string2.equals("proximityOn")) break;
                    n = 5;
                    break;
                }
                case 976541947: {
                    if (!string2.equals("ramUsed")) break;
                    n = 4;
                    break;
                }
                case 279795450: {
                    if (!string2.equals("diskUsed")) break;
                    n = 3;
                    break;
                }
                case -1439500848: {
                    if (!string2.equals("orientation")) break;
                    n = 2;
                    break;
                }
                case -1455558134: {
                    if (!string2.equals("batteryVelocity")) break;
                    n = 1;
                    break;
                }
                case -1708606089: {
                    if (!string2.equals("batteryLevel")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block16;
                }
                case 5: {
                    builder.setProximityOn(jsonReader.nextBoolean());
                    continue block16;
                }
                case 4: {
                    builder.setRamUsed(jsonReader.nextLong());
                    continue block16;
                }
                case 3: {
                    builder.setDiskUsed(jsonReader.nextLong());
                    continue block16;
                }
                case 2: {
                    builder.setOrientation(jsonReader.nextInt());
                    continue block16;
                }
                case 1: {
                    builder.setBatteryVelocity(jsonReader.nextInt());
                    continue block16;
                }
                case 0: 
            }
            builder.setBatteryLevel(jsonReader.nextDouble());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution parseEventExecution(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1481625679: {
                    if (!string2.equals("exception")) break;
                    n = 4;
                    break;
                }
                case 937615455: {
                    if (!string2.equals("binaries")) break;
                    n = 3;
                    break;
                }
                case -902467928: {
                    if (!string2.equals("signal")) break;
                    n = 2;
                    break;
                }
                case -1337936983: {
                    if (!string2.equals("threads")) break;
                    n = 1;
                    break;
                }
                case -1375141843: {
                    if (!string2.equals("appExitInfo")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block14;
                }
                case 4: {
                    builder.setException(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block14;
                }
                case 3: {
                    builder.setBinaries(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda4.INSTANCE));
                    continue block14;
                }
                case 2: {
                    builder.setSignal(CrashlyticsReportJsonTransform.parseEventSignal(jsonReader));
                    continue block14;
                }
                case 1: {
                    builder.setThreads(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda2.INSTANCE));
                    continue block14;
                }
                case 0: 
            }
            builder.setAppExitInfo(CrashlyticsReportJsonTransform.parseAppExitInfo(jsonReader));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Exception parseEventExecutionException(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Exception.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 581754413: {
                    if (!string2.equals("overflowCount")) break;
                    n = 4;
                    break;
                }
                case 91997906: {
                    if (!string2.equals("causedBy")) break;
                    n = 3;
                    break;
                }
                case 3575610: {
                    if (!string2.equals("type")) break;
                    n = 2;
                    break;
                }
                case -934964668: {
                    if (!string2.equals("reason")) break;
                    n = 1;
                    break;
                }
                case -1266514778: {
                    if (!string2.equals("frames")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block14;
                }
                case 4: {
                    builder.setOverflowCount(jsonReader.nextInt());
                    continue block14;
                }
                case 3: {
                    builder.setCausedBy(CrashlyticsReportJsonTransform.parseEventExecutionException(jsonReader));
                    continue block14;
                }
                case 2: {
                    builder.setType(jsonReader.nextString());
                    continue block14;
                }
                case 1: {
                    builder.setReason(jsonReader.nextString());
                    continue block14;
                }
                case 0: 
            }
            builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda1.INSTANCE));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame parseEventFrame(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.builder();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2125650548: {
                    if (!string2.equals("importance")) break;
                    n = 4;
                    break;
                }
                case 3143036: {
                    if (!string2.equals("file")) break;
                    n = 3;
                    break;
                }
                case 3571: {
                    if (!string2.equals("pc")) break;
                    n = 2;
                    break;
                }
                case -887523944: {
                    if (!string2.equals("symbol")) break;
                    n = 1;
                    break;
                }
                case -1019779949: {
                    if (!string2.equals("offset")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block14;
                }
                case 4: {
                    builder.setImportance(jsonReader.nextInt());
                    continue block14;
                }
                case 3: {
                    builder.setFile(jsonReader.nextString());
                    continue block14;
                }
                case 2: {
                    builder.setPc(jsonReader.nextLong());
                    continue block14;
                }
                case 1: {
                    builder.setSymbol(jsonReader.nextString());
                    continue block14;
                }
                case 0: 
            }
            builder.setOffset(jsonReader.nextLong());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Log parseEventLog(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Log.Builder builder = CrashlyticsReport.Session.Event.Log.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            if (!string2.equals("content")) {
                jsonReader.skipValue();
                continue;
            }
            builder.setContent(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Signal parseEventSignal(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Signal.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Signal.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 3373707: {
                    if (!string2.equals("name")) break;
                    n = 2;
                    break;
                }
                case 3059181: {
                    if (!string2.equals("code")) break;
                    n = 1;
                    break;
                }
                case -1147692044: {
                    if (!string2.equals("address")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block10;
                }
                case 2: {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case 1: {
                    builder.setCode(jsonReader.nextString());
                    continue block10;
                }
                case 0: 
            }
            builder.setAddress(jsonReader.nextLong());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.Event.Application.Execution.Thread parseEventThread(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Event.Application.Execution.Thread.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Thread.builder();
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2125650548: {
                    if (!string2.equals("importance")) break;
                    n = 2;
                    break;
                }
                case 3373707: {
                    if (!string2.equals("name")) break;
                    n = 1;
                    break;
                }
                case -1266514778: {
                    if (!string2.equals("frames")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block10;
                }
                case 2: {
                    builder.setImportance(jsonReader.nextInt());
                    continue block10;
                }
                case 1: {
                    builder.setName(jsonReader.nextString());
                    continue block10;
                }
                case 0: 
            }
            builder.setFrames(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda1.INSTANCE));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.FilesPayload.File parseFile(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.FilesPayload.File.Builder builder = CrashlyticsReport.FilesPayload.File.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            if (!string2.equals("filename")) {
                if (!string2.equals("contents")) {
                    jsonReader.skipValue();
                    continue;
                }
                builder.setContents(Base64.decode((String)jsonReader.nextString(), (int)2));
                continue;
            }
            builder.setFilename(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.FilesPayload parseNdkPayload(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.FilesPayload.Builder builder = CrashlyticsReport.FilesPayload.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            if (!string2.equals("files")) {
                if (!string2.equals("orgId")) {
                    jsonReader.skipValue();
                    continue;
                }
                builder.setOrgId(jsonReader.nextString());
                continue;
            }
            builder.setFiles(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda3.INSTANCE));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.OperatingSystem parseOs(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.OperatingSystem.Builder builder = CrashlyticsReport.Session.OperatingSystem.builder();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1874684019: {
                    if (!string2.equals("platform")) break;
                    n = 3;
                    break;
                }
                case 351608024: {
                    if (!string2.equals("version")) break;
                    n = 2;
                    break;
                }
                case -293026577: {
                    if (!string2.equals("jailbroken")) break;
                    n = 1;
                    break;
                }
                case -911706486: {
                    if (!string2.equals("buildVersion")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block12;
                }
                case 3: {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block12;
                }
                case 2: {
                    builder.setVersion(jsonReader.nextString());
                    continue block12;
                }
                case 1: {
                    builder.setJailbroken(jsonReader.nextBoolean());
                    continue block12;
                }
                case 0: 
            }
            builder.setBuildVersion(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport parseReport(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Builder builder = CrashlyticsReport.builder();
        jsonReader.beginObject();
        block20: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1984987798: {
                    if (!string2.equals("session")) break;
                    n = 7;
                    break;
                }
                case 1975623094: {
                    if (!string2.equals("displayVersion")) break;
                    n = 6;
                    break;
                }
                case 1874684019: {
                    if (!string2.equals("platform")) break;
                    n = 5;
                    break;
                }
                case 719853845: {
                    if (!string2.equals("installationUuid")) break;
                    n = 4;
                    break;
                }
                case 344431858: {
                    if (!string2.equals("gmpAppId")) break;
                    n = 3;
                    break;
                }
                case -911706486: {
                    if (!string2.equals("buildVersion")) break;
                    n = 2;
                    break;
                }
                case -1962630338: {
                    if (!string2.equals("sdkVersion")) break;
                    n = 1;
                    break;
                }
                case -2118372775: {
                    if (!string2.equals("ndkPayload")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block20;
                }
                case 7: {
                    builder.setSession(CrashlyticsReportJsonTransform.parseSession(jsonReader));
                    continue block20;
                }
                case 6: {
                    builder.setDisplayVersion(jsonReader.nextString());
                    continue block20;
                }
                case 5: {
                    builder.setPlatform(jsonReader.nextInt());
                    continue block20;
                }
                case 4: {
                    builder.setInstallationUuid(jsonReader.nextString());
                    continue block20;
                }
                case 3: {
                    builder.setGmpAppId(jsonReader.nextString());
                    continue block20;
                }
                case 2: {
                    builder.setBuildVersion(jsonReader.nextString());
                    continue block20;
                }
                case 1: {
                    builder.setSdkVersion(jsonReader.nextString());
                    continue block20;
                }
                case 0: 
            }
            builder.setNdkPayload(CrashlyticsReportJsonTransform.parseNdkPayload(jsonReader));
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session parseSession(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.Builder builder = CrashlyticsReport.Session.builder();
        jsonReader.beginObject();
        block26: while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2047016109: {
                    if (!string2.equals("generatorType")) break;
                    n = 10;
                    break;
                }
                case 1025385094: {
                    if (!string2.equals("crashed")) break;
                    n = 9;
                    break;
                }
                case 286956243: {
                    if (!string2.equals("generator")) break;
                    n = 8;
                    break;
                }
                case 3599307: {
                    if (!string2.equals("user")) break;
                    n = 7;
                    break;
                }
                case 96801: {
                    if (!string2.equals("app")) break;
                    n = 6;
                    break;
                }
                case 3556: {
                    if (!string2.equals("os")) break;
                    n = 5;
                    break;
                }
                case -1291329255: {
                    if (!string2.equals("events")) break;
                    n = 4;
                    break;
                }
                case -1335157162: {
                    if (!string2.equals("device")) break;
                    n = 3;
                    break;
                }
                case -1606742899: {
                    if (!string2.equals("endedAt")) break;
                    n = 2;
                    break;
                }
                case -1618432855: {
                    if (!string2.equals("identifier")) break;
                    n = 1;
                    break;
                }
                case -2128794476: {
                    if (!string2.equals("startedAt")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    jsonReader.skipValue();
                    continue block26;
                }
                case 10: {
                    builder.setGeneratorType(jsonReader.nextInt());
                    continue block26;
                }
                case 9: {
                    builder.setCrashed(jsonReader.nextBoolean());
                    continue block26;
                }
                case 8: {
                    builder.setGenerator(jsonReader.nextString());
                    continue block26;
                }
                case 7: {
                    builder.setUser(CrashlyticsReportJsonTransform.parseUser(jsonReader));
                    continue block26;
                }
                case 6: {
                    builder.setApp(CrashlyticsReportJsonTransform.parseApp(jsonReader));
                    continue block26;
                }
                case 5: {
                    builder.setOs(CrashlyticsReportJsonTransform.parseOs(jsonReader));
                    continue block26;
                }
                case 4: {
                    builder.setEvents(CrashlyticsReportJsonTransform.parseArray(jsonReader, CrashlyticsReportJsonTransform$$ExternalSyntheticLambda0.INSTANCE));
                    continue block26;
                }
                case 3: {
                    builder.setDevice(CrashlyticsReportJsonTransform.parseDevice(jsonReader));
                    continue block26;
                }
                case 2: {
                    builder.setEndedAt(jsonReader.nextLong());
                    continue block26;
                }
                case 1: {
                    builder.setIdentifierFromUtf8Bytes(Base64.decode((String)jsonReader.nextString(), (int)2));
                    continue block26;
                }
                case 0: 
            }
            builder.setStartedAt(jsonReader.nextLong());
        }
        jsonReader.endObject();
        return builder.build();
    }

    private static CrashlyticsReport.Session.User parseUser(JsonReader jsonReader) throws IOException {
        CrashlyticsReport.Session.User.Builder builder = CrashlyticsReport.Session.User.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            string2.hashCode();
            if (!string2.equals("identifier")) {
                jsonReader.skipValue();
                continue;
            }
            builder.setIdentifier(jsonReader.nextString());
        }
        jsonReader.endObject();
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    public CrashlyticsReport.ApplicationExitInfo applicationExitInfoFromJson(String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String applicationExitInfoToJson(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode(applicationExitInfo);
    }

    /*
     * Exception decompiling
     */
    public CrashlyticsReport.Session.Event eventFromJson(String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String eventToJson(CrashlyticsReport.Session.Event event) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode(event);
    }

    /*
     * Exception decompiling
     */
    public CrashlyticsReport reportFromJson(String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String reportToJson(CrashlyticsReport crashlyticsReport) {
        return CRASHLYTICS_REPORT_JSON_ENCODER.encode(crashlyticsReport);
    }

    private static interface ObjectParser<T> {
        public T parse(JsonReader var1) throws IOException;
    }
}

