/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.network.HttpGetRequest;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import com.google.firebase.crashlytics.internal.settings.SettingsRequest;
import com.google.firebase.crashlytics.internal.settings.SettingsSpiCall;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class DefaultSettingsSpiCall
implements SettingsSpiCall {
    static final String ACCEPT_JSON_VALUE = "application/json";
    static final String ANDROID_CLIENT_TYPE = "android";
    static final String BUILD_VERSION_PARAM = "build_version";
    static final String CRASHLYTICS_USER_AGENT = "Crashlytics Android SDK/";
    static final String DISPLAY_VERSION_PARAM = "display_version";
    static final String HEADER_ACCEPT = "Accept";
    static final String HEADER_CLIENT_TYPE = "X-CRASHLYTICS-API-CLIENT-TYPE";
    static final String HEADER_CLIENT_VERSION = "X-CRASHLYTICS-API-CLIENT-VERSION";
    static final String HEADER_DEVICE_MODEL = "X-CRASHLYTICS-DEVICE-MODEL";
    static final String HEADER_GOOGLE_APP_ID = "X-CRASHLYTICS-GOOGLE-APP-ID";
    static final String HEADER_INSTALLATION_ID = "X-CRASHLYTICS-INSTALLATION-ID";
    static final String HEADER_OS_BUILD_VERSION = "X-CRASHLYTICS-OS-BUILD-VERSION";
    static final String HEADER_OS_DISPLAY_VERSION = "X-CRASHLYTICS-OS-DISPLAY-VERSION";
    static final String HEADER_USER_AGENT = "User-Agent";
    static final String INSTANCE_PARAM = "instance";
    static final String SOURCE_PARAM = "source";
    private final Logger logger;
    private final HttpRequestFactory requestFactory;
    private final String url;

    public DefaultSettingsSpiCall(String string2, HttpRequestFactory httpRequestFactory) {
        this(string2, httpRequestFactory, Logger.getLogger());
    }

    DefaultSettingsSpiCall(String string2, HttpRequestFactory httpRequestFactory, Logger logger) {
        if (string2 != null) {
            this.logger = logger;
            this.requestFactory = httpRequestFactory;
            this.url = string2;
            return;
        }
        throw new IllegalArgumentException("url must not be null.");
    }

    private HttpGetRequest applyHeadersTo(HttpGetRequest httpGetRequest, SettingsRequest settingsRequest) {
        this.applyNonNullHeader(httpGetRequest, HEADER_GOOGLE_APP_ID, settingsRequest.googleAppId);
        this.applyNonNullHeader(httpGetRequest, HEADER_CLIENT_TYPE, ANDROID_CLIENT_TYPE);
        this.applyNonNullHeader(httpGetRequest, HEADER_CLIENT_VERSION, CrashlyticsCore.getVersion());
        this.applyNonNullHeader(httpGetRequest, HEADER_ACCEPT, ACCEPT_JSON_VALUE);
        this.applyNonNullHeader(httpGetRequest, HEADER_DEVICE_MODEL, settingsRequest.deviceModel);
        this.applyNonNullHeader(httpGetRequest, HEADER_OS_BUILD_VERSION, settingsRequest.osBuildVersion);
        this.applyNonNullHeader(httpGetRequest, HEADER_OS_DISPLAY_VERSION, settingsRequest.osDisplayVersion);
        this.applyNonNullHeader(httpGetRequest, HEADER_INSTALLATION_ID, settingsRequest.installIdProvider.getCrashlyticsInstallId());
        return httpGetRequest;
    }

    private void applyNonNullHeader(HttpGetRequest httpGetRequest, String string2, String string3) {
        if (string3 != null) {
            httpGetRequest.header(string2, string3);
        }
    }

    private JSONObject getJsonObjectFrom(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject;
        }
        catch (Exception exception) {
            Logger logger = this.logger;
            Object object = new StringBuilder();
            ((StringBuilder)object).append("Failed to parse settings JSON from ");
            ((StringBuilder)object).append(this.url);
            logger.w(((StringBuilder)object).toString(), exception);
            object = this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Settings response ");
            stringBuilder.append(string2);
            ((Logger)object).w(stringBuilder.toString());
            return null;
        }
    }

    private Map<String, String> getQueryParamsFor(SettingsRequest object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(BUILD_VERSION_PARAM, ((SettingsRequest)object).buildVersion);
        hashMap.put(DISPLAY_VERSION_PARAM, ((SettingsRequest)object).displayVersion);
        hashMap.put(SOURCE_PARAM, Integer.toString(((SettingsRequest)object).source));
        object = ((SettingsRequest)object).instanceId;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            hashMap.put(INSTANCE_PARAM, (String)object);
        }
        return hashMap;
    }

    protected HttpGetRequest createHttpGetRequest(Map<String, String> object) {
        HttpGetRequest httpGetRequest = this.requestFactory.buildHttpGetRequest(this.url, (Map<String, String>)object);
        object = new StringBuilder();
        ((StringBuilder)object).append(CRASHLYTICS_USER_AGENT);
        ((StringBuilder)object).append(CrashlyticsCore.getVersion());
        return httpGetRequest.header(HEADER_USER_AGENT, ((StringBuilder)object).toString()).header("X-CRASHLYTICS-DEVELOPER-TOKEN", "470fa2b4ae81cd56ecbcda9735803434cec591fa");
    }

    JSONObject handleResponse(HttpResponse object) {
        int n = ((HttpResponse)object).code();
        Logger logger = this.logger;
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("Settings response code was: ");
        ((StringBuilder)object2).append(n);
        logger.v(((StringBuilder)object2).toString());
        if (this.requestWasSuccessful(n)) {
            object = this.getJsonObjectFrom(((HttpResponse)object).body());
        } else {
            object2 = this.logger;
            object = new StringBuilder();
            ((StringBuilder)object).append("Settings request failed; (status: ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(") from ");
            ((StringBuilder)object).append(this.url);
            ((Logger)object2).e(((StringBuilder)object).toString());
            object = null;
        }
        return object;
    }

    @Override
    public JSONObject invoke(SettingsRequest object, boolean bl) {
        if (bl) {
            try {
                Map<String, String> map = this.getQueryParamsFor((SettingsRequest)object);
                object = this.applyHeadersTo(this.createHttpGetRequest(map), (SettingsRequest)object);
                Logger logger = this.logger;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Requesting settings from ");
                stringBuilder.append(this.url);
                logger.d(stringBuilder.toString());
                logger = this.logger;
                stringBuilder = new StringBuilder();
                stringBuilder.append("Settings query params were: ");
                stringBuilder.append(map);
                logger.v(stringBuilder.toString());
                object = this.handleResponse(((HttpGetRequest)object).execute());
            }
            catch (IOException iOException) {
                this.logger.e("Settings request failed.", iOException);
                object = null;
            }
            return object;
        }
        throw new RuntimeException("An invalid data collection token was used.");
    }

    boolean requestWasSuccessful(int n) {
        boolean bl = n == 200 || n == 201 || n == 202 || n == 203;
        return bl;
    }
}

