/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.DeliveryMechanism;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.SystemCurrentTimeProvider;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.CachedSettingsIo;
import com.google.firebase.crashlytics.internal.settings.DefaultSettingsJsonTransform;
import com.google.firebase.crashlytics.internal.settings.DefaultSettingsSpiCall;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsCacheBehavior;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonParser;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.settings.SettingsRequest;
import com.google.firebase.crashlytics.internal.settings.SettingsSpiCall;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingsController
implements SettingsProvider {
    private static final String PREFS_BUILD_INSTANCE_IDENTIFIER = "existing_instance_identifier";
    private static final String SETTINGS_URL_FORMAT = "https://firebase-settings.crashlytics.com/spi/v2/platforms/android/gmp/%s/settings";
    private final CachedSettingsIo cachedSettingsIo;
    private final Context context;
    private final CurrentTimeProvider currentTimeProvider;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final AtomicReference<Settings> settings;
    private final SettingsJsonParser settingsJsonParser;
    private final SettingsRequest settingsRequest;
    private final SettingsSpiCall settingsSpiCall;
    private final AtomicReference<TaskCompletionSource<Settings>> settingsTask;

    SettingsController(Context context, SettingsRequest settingsRequest, CurrentTimeProvider currentTimeProvider, SettingsJsonParser settingsJsonParser, CachedSettingsIo cachedSettingsIo, SettingsSpiCall settingsSpiCall, DataCollectionArbiter dataCollectionArbiter) {
        AtomicReference<Settings> atomicReference = new AtomicReference<Settings>();
        this.settings = atomicReference;
        this.settingsTask = new AtomicReference(new TaskCompletionSource());
        this.context = context;
        this.settingsRequest = settingsRequest;
        this.currentTimeProvider = currentTimeProvider;
        this.settingsJsonParser = settingsJsonParser;
        this.cachedSettingsIo = cachedSettingsIo;
        this.settingsSpiCall = settingsSpiCall;
        this.dataCollectionArbiter = dataCollectionArbiter;
        atomicReference.set(DefaultSettingsJsonTransform.defaultSettings(currentTimeProvider));
    }

    public static SettingsController create(Context context, String string2, IdManager idManager, HttpRequestFactory object, String string3, String string4, FileStore object2, DataCollectionArbiter dataCollectionArbiter) {
        String string5 = idManager.getInstallerPackageName();
        SystemCurrentTimeProvider systemCurrentTimeProvider = new SystemCurrentTimeProvider();
        SettingsJsonParser settingsJsonParser = new SettingsJsonParser(systemCurrentTimeProvider);
        object2 = new CachedSettingsIo((FileStore)object2);
        object = new DefaultSettingsSpiCall(String.format(Locale.US, SETTINGS_URL_FORMAT, string2), (HttpRequestFactory)object);
        return new SettingsController(context, new SettingsRequest(string2, idManager.getModelName(), idManager.getOsBuildVersionString(), idManager.getOsDisplayVersionString(), idManager, CommonUtils.createInstanceIdFrom(CommonUtils.getMappingFileId(context), string2, string4, string3), string4, string3, DeliveryMechanism.determineFrom(string5).getId()), systemCurrentTimeProvider, settingsJsonParser, (CachedSettingsIo)object2, (SettingsSpiCall)object, dataCollectionArbiter);
    }

    /*
     * WARNING - void declaration
     */
    private Settings getCachedSettingsData(SettingsCacheBehavior settingsCacheBehavior) {
        Settings settings;
        block8: {
            void var1_4;
            block12: {
                Settings settings2;
                Settings settings3;
                block9: {
                    block10: {
                        block11: {
                            settings3 = null;
                            settings2 = null;
                            settings = settings3;
                            if (SettingsCacheBehavior.SKIP_CACHE_LOOKUP.equals((Object)settingsCacheBehavior)) break block8;
                            JSONObject jSONObject = this.cachedSettingsIo.readCachedSettings();
                            if (jSONObject == null) break block9;
                            settings = this.settingsJsonParser.parseSettingsJson(jSONObject);
                            if (settings == null) break block10;
                            this.logSettings(jSONObject, "Loaded cached settings: ");
                            long l = this.currentTimeProvider.getCurrentTimeMillis();
                            if (SettingsCacheBehavior.IGNORE_CACHE_EXPIRATION.equals((Object)settingsCacheBehavior) || !settings.isExpired(l)) break block11;
                            Logger.getLogger().v("Cached settings have expired.");
                            settings = settings3;
                            break block8;
                        }
                        try {
                            Logger.getLogger().v("Returning cached settings.");
                        }
                        catch (Exception exception) {
                            break block12;
                        }
                    }
                    Logger.getLogger().e("Failed to parse cached settings data.", null);
                    settings = settings3;
                    break block8;
                }
                try {
                    Logger.getLogger().d("No cached settings data found.");
                    settings = settings3;
                    break block8;
                }
                catch (Exception exception) {
                    settings = settings2;
                }
            }
            Logger.getLogger().e("Failed to get cached settings", (Throwable)var1_4);
        }
        return settings;
    }

    private String getStoredBuildInstanceIdentifier() {
        return CommonUtils.getSharedPrefs(this.context).getString(PREFS_BUILD_INSTANCE_IDENTIFIER, "");
    }

    private void logSettings(JSONObject jSONObject, String string2) throws JSONException {
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(jSONObject.toString());
        logger.d(stringBuilder.toString());
    }

    private boolean setStoredBuildInstanceIdentifier(String string2) {
        SharedPreferences.Editor editor = CommonUtils.getSharedPrefs(this.context).edit();
        editor.putString(PREFS_BUILD_INSTANCE_IDENTIFIER, string2);
        editor.apply();
        return true;
    }

    boolean buildInstanceIdentifierChanged() {
        return this.getStoredBuildInstanceIdentifier().equals(this.settingsRequest.instanceId) ^ true;
    }

    @Override
    public Task<Settings> getSettingsAsync() {
        return this.settingsTask.get().getTask();
    }

    @Override
    public Settings getSettingsSync() {
        return this.settings.get();
    }

    public Task<Void> loadSettingsData(SettingsCacheBehavior object, Executor executor) {
        if (!this.buildInstanceIdentifierChanged() && (object = this.getCachedSettingsData((SettingsCacheBehavior)((Object)object))) != null) {
            this.settings.set((Settings)object);
            this.settingsTask.get().trySetResult((Settings)object);
            return Tasks.forResult(null);
        }
        object = this.getCachedSettingsData(SettingsCacheBehavior.IGNORE_CACHE_EXPIRATION);
        if (object != null) {
            this.settings.set((Settings)object);
            this.settingsTask.get().trySetResult((Settings)object);
        }
        return this.dataCollectionArbiter.waitForDataCollectionPermission(executor).onSuccessTask(executor, new SuccessContinuation<Void, Void>(){

            @Override
            public Task<Void> then(Void object) throws Exception {
                Object object2 = SettingsController.this.settingsSpiCall.invoke(SettingsController.this.settingsRequest, true);
                if (object2 != null) {
                    object = SettingsController.this.settingsJsonParser.parseSettingsJson((JSONObject)object2);
                    SettingsController.this.cachedSettingsIo.writeCachedSettings(((Settings)object).expiresAtMillis, (JSONObject)object2);
                    SettingsController.this.logSettings(object2, "Loaded settings: ");
                    object2 = SettingsController.this;
                    ((SettingsController)object2).setStoredBuildInstanceIdentifier(((SettingsController)object2).settingsRequest.instanceId);
                    SettingsController.this.settings.set(object);
                    ((TaskCompletionSource)SettingsController.this.settingsTask.get()).trySetResult(object);
                }
                return Tasks.forResult(null);
            }
        });
    }

    public Task<Void> loadSettingsData(Executor executor) {
        return this.loadSettingsData(SettingsCacheBehavior.USE_CACHE, executor);
    }
}

