/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.stacktrace;

import com.google.firebase.crashlytics.internal.stacktrace.MiddleOutStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;

public class MiddleOutFallbackStrategy
implements StackTraceTrimmingStrategy {
    private final int maximumStackSize;
    private final MiddleOutStrategy middleOutStrategy;
    private final StackTraceTrimmingStrategy[] trimmingStrategies;

    public MiddleOutFallbackStrategy(int n, StackTraceTrimmingStrategy ... stackTraceTrimmingStrategyArray) {
        this.maximumStackSize = n;
        this.trimmingStrategies = stackTraceTrimmingStrategyArray;
        this.middleOutStrategy = new MiddleOutStrategy(n);
    }

    @Override
    public StackTraceElement[] getTrimmedStackTrace(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray.length <= this.maximumStackSize) {
            return stackTraceElementArray;
        }
        StackTraceTrimmingStrategy[] stackTraceTrimmingStrategyArray = this.trimmingStrategies;
        int n = stackTraceTrimmingStrategyArray.length;
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        for (int i = 0; i < n; ++i) {
            StackTraceTrimmingStrategy stackTraceTrimmingStrategy = stackTraceTrimmingStrategyArray[i];
            if (stackTraceElementArray2.length <= this.maximumStackSize) break;
            stackTraceElementArray2 = stackTraceTrimmingStrategy.getTrimmedStackTrace(stackTraceElementArray);
        }
        stackTraceElementArray = stackTraceElementArray2;
        if (stackTraceElementArray2.length > this.maximumStackSize) {
            stackTraceElementArray = this.middleOutStrategy.getTrimmedStackTrace(stackTraceElementArray2);
        }
        return stackTraceElementArray;
    }
}

