/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.stacktrace;

import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.util.HashMap;

public class RemoveRepeatsStrategy
implements StackTraceTrimmingStrategy {
    private final int maxRepetitions;

    public RemoveRepeatsStrategy() {
        this(1);
    }

    public RemoveRepeatsStrategy(int n) {
        this.maxRepetitions = n;
    }

    private static boolean isRepeatingSequence(StackTraceElement[] stackTraceElementArray, int n, int n2) {
        int n3 = n2 - n;
        if (n2 + n3 > stackTraceElementArray.length) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (stackTraceElementArray[n + i].equals(stackTraceElementArray[n2 + i])) continue;
            return false;
        }
        return true;
    }

    private static StackTraceElement[] trimRepeats(StackTraceElement[] stackTraceElementArray, int n) {
        HashMap<StackTraceElement, Integer> hashMap = new HashMap<StackTraceElement, Integer>();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n2 < stackTraceElementArray.length) {
            int n5;
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            Integer n6 = (Integer)hashMap.get(stackTraceElement);
            if (n6 != null && RemoveRepeatsStrategy.isRepeatingSequence(stackTraceElementArray, n6, n2)) {
                int n7 = n2 - n6;
                int n8 = n3;
                n5 = n4;
                if (n4 < n) {
                    System.arraycopy(stackTraceElementArray, n2, stackTraceElementArray2, n3, n7);
                    n8 = n3 + n7;
                    n5 = n4 + 1;
                }
                n4 = n7 - 1 + n2;
                n3 = n8;
            } else {
                stackTraceElementArray2[n3] = stackTraceElementArray[n2];
                ++n3;
                n4 = n2;
                n5 = 1;
            }
            hashMap.put(stackTraceElement, n2);
            n2 = n4 + 1;
            n4 = n5;
        }
        stackTraceElementArray = new StackTraceElement[n3];
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray, 0, n3);
        return stackTraceElementArray;
    }

    @Override
    public StackTraceElement[] getTrimmedStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = RemoveRepeatsStrategy.trimRepeats(stackTraceElementArray, this.maxRepetitions);
        if (stackTraceElementArray2.length < stackTraceElementArray.length) {
            return stackTraceElementArray2;
        }
        return stackTraceElementArray;
    }
}

