/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class FieldDescriptor {
    private final String name;
    private final Map<Class<?>, Object> properties;

    private FieldDescriptor(String string2, Map<Class<?>, Object> map) {
        this.name = string2;
        this.properties = map;
    }

    public static Builder builder(String string2) {
        return new Builder(string2);
    }

    public static FieldDescriptor of(String string2) {
        return new FieldDescriptor(string2, Collections.<Class<?>, Object>emptyMap());
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldDescriptor)) {
            return false;
        }
        object = (FieldDescriptor)object;
        if (!this.name.equals(((FieldDescriptor)object).name) || !this.properties.equals(((FieldDescriptor)object).properties)) {
            bl = false;
        }
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public <T extends Annotation> T getProperty(Class<T> clazz) {
        return (T)((Annotation)this.properties.get(clazz));
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.properties.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FieldDescriptor{name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", properties=");
        stringBuilder.append(this.properties.values());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final String name;
        private Map<Class<?>, Object> properties = null;

        Builder(String string2) {
            this.name = string2;
        }

        public FieldDescriptor build() {
            String string2 = this.name;
            Map<Object, Object> map = this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(this.properties));
            return new FieldDescriptor(string2, map);
        }

        public <T extends Annotation> Builder withProperty(T t) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(t.annotationType(), t);
            return this;
        }
    }
}

