/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder$$ExternalSyntheticLambda0;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder$$ExternalSyntheticLambda1;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder$$ExternalSyntheticLambda2;
import com.google.firebase.encoders.json.JsonValueObjectEncoderContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class JsonDataEncoderBuilder
implements EncoderConfig<JsonDataEncoderBuilder> {
    private static final ValueEncoder<Boolean> BOOLEAN_ENCODER;
    private static final ObjectEncoder<Object> DEFAULT_FALLBACK_ENCODER;
    private static final ValueEncoder<String> STRING_ENCODER;
    private static final TimestampEncoder TIMESTAMP_ENCODER;
    private ObjectEncoder<Object> fallbackEncoder;
    private boolean ignoreNullValues = false;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders = new HashMap();
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders = new HashMap();

    static {
        DEFAULT_FALLBACK_ENCODER = JsonDataEncoderBuilder$$ExternalSyntheticLambda0.INSTANCE;
        STRING_ENCODER = JsonDataEncoderBuilder$$ExternalSyntheticLambda2.INSTANCE;
        BOOLEAN_ENCODER = JsonDataEncoderBuilder$$ExternalSyntheticLambda1.INSTANCE;
        TIMESTAMP_ENCODER = new TimestampEncoder();
    }

    public JsonDataEncoderBuilder() {
        this.fallbackEncoder = DEFAULT_FALLBACK_ENCODER;
        this.registerEncoder((Class)String.class, STRING_ENCODER);
        this.registerEncoder((Class)Boolean.class, BOOLEAN_ENCODER);
        this.registerEncoder((Class)Date.class, (ValueEncoder)TIMESTAMP_ENCODER);
    }

    static /* synthetic */ void lambda$static$0(Object object, ObjectEncoderContext object2) throws IOException {
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Couldn't find encoder for type ");
        ((StringBuilder)object2).append(object.getClass().getCanonicalName());
        throw new EncodingException(((StringBuilder)object2).toString());
    }

    static /* synthetic */ void lambda$static$1(String string2, ValueEncoderContext valueEncoderContext) throws IOException {
        valueEncoderContext.add(string2);
    }

    static /* synthetic */ void lambda$static$2(Boolean bl, ValueEncoderContext valueEncoderContext) throws IOException {
        valueEncoderContext.add(bl);
    }

    public DataEncoder build() {
        return new DataEncoder(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public String encode(Object object) {
                StringWriter stringWriter = new StringWriter();
                try {
                    this.encode(object, stringWriter);
                    return stringWriter.toString();
                }
                catch (IOException iOException) {
                    return stringWriter.toString();
                }
            }

            @Override
            public void encode(Object object, Writer object2) throws IOException {
                object2 = new JsonValueObjectEncoderContext((Writer)object2, JsonDataEncoderBuilder.this.objectEncoders, JsonDataEncoderBuilder.this.valueEncoders, JsonDataEncoderBuilder.this.fallbackEncoder, JsonDataEncoderBuilder.this.ignoreNullValues);
                ((JsonValueObjectEncoderContext)object2).add(object, false);
                ((JsonValueObjectEncoderContext)object2).close();
            }
        };
    }

    public JsonDataEncoderBuilder configureWith(Configurator configurator) {
        configurator.configure(this);
        return this;
    }

    public JsonDataEncoderBuilder ignoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
        return this;
    }

    @Override
    public <T> JsonDataEncoderBuilder registerEncoder(Class<T> clazz, ObjectEncoder<? super T> objectEncoder) {
        this.objectEncoders.put(clazz, objectEncoder);
        this.valueEncoders.remove(clazz);
        return this;
    }

    @Override
    public <T> JsonDataEncoderBuilder registerEncoder(Class<T> clazz, ValueEncoder<? super T> valueEncoder) {
        this.valueEncoders.put(clazz, valueEncoder);
        this.objectEncoders.remove(clazz);
        return this;
    }

    public JsonDataEncoderBuilder registerFallbackEncoder(ObjectEncoder<Object> objectEncoder) {
        this.fallbackEncoder = objectEncoder;
        return this;
    }

    private static final class TimestampEncoder
    implements ValueEncoder<Date> {
        private static final DateFormat rfc339;

        static {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            rfc339 = simpleDateFormat;
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        private TimestampEncoder() {
        }

        @Override
        public void encode(Date date, ValueEncoderContext valueEncoderContext) throws IOException {
            valueEncoderContext.add(rfc339.format(date));
        }
    }
}

