/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.proto.ProtobufDataEncoderContext;
import com.google.firebase.encoders.proto.ProtobufEncoder$Builder$$ExternalSyntheticLambda0;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ProtobufEncoder {
    private final ObjectEncoder<Object> fallbackEncoder;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;

    ProtobufEncoder(Map<Class<?>, ObjectEncoder<?>> map, Map<Class<?>, ValueEncoder<?>> map2, ObjectEncoder<Object> objectEncoder) {
        this.objectEncoders = map;
        this.valueEncoders = map2;
        this.fallbackEncoder = objectEncoder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void encode(Object object, OutputStream outputStream) throws IOException {
        new ProtobufDataEncoderContext(outputStream, this.objectEncoders, this.valueEncoders, this.fallbackEncoder).encode(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] encode(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.encode(object, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static final class Builder
    implements EncoderConfig<Builder> {
        private static final ObjectEncoder<Object> DEFAULT_FALLBACK_ENCODER = ProtobufEncoder$Builder$$ExternalSyntheticLambda0.INSTANCE;
        private ObjectEncoder<Object> fallbackEncoder;
        private final Map<Class<?>, ObjectEncoder<?>> objectEncoders = new HashMap();
        private final Map<Class<?>, ValueEncoder<?>> valueEncoders = new HashMap();

        public Builder() {
            this.fallbackEncoder = DEFAULT_FALLBACK_ENCODER;
        }

        static /* synthetic */ void lambda$static$0(Object object, ObjectEncoderContext object2) throws IOException {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Couldn't find encoder for type ");
            ((StringBuilder)object2).append(object.getClass().getCanonicalName());
            throw new EncodingException(((StringBuilder)object2).toString());
        }

        public ProtobufEncoder build() {
            return new ProtobufEncoder(new HashMap(this.objectEncoders), new HashMap(this.valueEncoders), this.fallbackEncoder);
        }

        public Builder configureWith(Configurator configurator) {
            configurator.configure(this);
            return this;
        }

        @Override
        public <U> Builder registerEncoder(Class<U> clazz, ObjectEncoder<? super U> objectEncoder) {
            this.objectEncoders.put(clazz, objectEncoder);
            this.valueEncoders.remove(clazz);
            return this;
        }

        @Override
        public <U> Builder registerEncoder(Class<U> clazz, ValueEncoder<? super U> valueEncoder) {
            this.valueEncoders.put(clazz, valueEncoder);
            this.objectEncoders.remove(clazz);
            return this;
        }

        public Builder registerFallbackEncoder(ObjectEncoder<Object> objectEncoder) {
            this.fallbackEncoder = objectEncoder;
            return this;
        }
    }
}

