/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.CrossProcessLock;
import com.google.firebase.installations.FirebaseInstallations$$ExternalSyntheticLambda0;
import com.google.firebase.installations.FirebaseInstallations$$ExternalSyntheticLambda1;
import com.google.firebase.installations.FirebaseInstallations$$ExternalSyntheticLambda2;
import com.google.firebase.installations.FirebaseInstallations$$ExternalSyntheticLambda3;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.GetAuthTokenListener;
import com.google.firebase.installations.GetIdListener;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.installations.RandomFidGenerator;
import com.google.firebase.installations.StateListener;
import com.google.firebase.installations.Utils;
import com.google.firebase.installations.internal.FidListener;
import com.google.firebase.installations.internal.FidListenerHandle;
import com.google.firebase.installations.local.IidStore;
import com.google.firebase.installations.local.PersistedInstallation;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import com.google.firebase.installations.remote.FirebaseInstallationServiceClient;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.TokenResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FirebaseInstallations
implements FirebaseInstallationsApi {
    private static final String API_KEY_VALIDATION_MSG = "Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final String APP_ID_VALIDATION_MSG = "Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final String AUTH_ERROR_MSG = "Installation ID could not be validated with the Firebase servers (maybe it was deleted). Firebase Installations will need to create a new Installation ID and auth token. Please retry your last request.";
    private static final String CHIME_FIREBASE_APP_NAME = "CHIME_ANDROID_SDK";
    private static final int CORE_POOL_SIZE = 0;
    private static final long KEEP_ALIVE_TIME_IN_SECONDS = 30L;
    private static final String LOCKFILE_NAME_GENERATE_FID = "generatefid.lock";
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final String PROJECT_ID_VALIDATION_MSG = "Please set your Project ID. A valid Firebase Project ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final ThreadFactory THREAD_FACTORY;
    private static final Object lockGenerateFid;
    private final ExecutorService backgroundExecutor;
    private String cachedFid;
    private final RandomFidGenerator fidGenerator;
    private Set<FidListener> fidListeners;
    private final FirebaseApp firebaseApp;
    private final IidStore iidStore;
    private final List<StateListener> listeners;
    private final Object lock = new Object();
    private final ExecutorService networkExecutor;
    private final PersistedInstallation persistedInstallation;
    private final FirebaseInstallationServiceClient serviceClient;
    private final Utils utils;

    public static /* synthetic */ Void $r8$lambda$ukIZcZ_XlkiT9OCDxQIhblgD6_Y(FirebaseInstallations firebaseInstallations) {
        return firebaseInstallations.deleteFirebaseInstallationId();
    }

    static {
        lockGenerateFid = new Object();
        THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, String.format("firebase-installations-executor-%d", this.mCount.getAndIncrement()));
            }
        };
    }

    FirebaseInstallations(FirebaseApp firebaseApp, Provider<HeartBeatController> provider) {
        this(new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY), firebaseApp, new FirebaseInstallationServiceClient(firebaseApp.getApplicationContext(), provider), new PersistedInstallation(firebaseApp), Utils.getInstance(), new IidStore(firebaseApp), new RandomFidGenerator());
    }

    FirebaseInstallations(ExecutorService executorService, FirebaseApp firebaseApp, FirebaseInstallationServiceClient firebaseInstallationServiceClient, PersistedInstallation persistedInstallation, Utils utils, IidStore iidStore, RandomFidGenerator randomFidGenerator) {
        this.fidListeners = new HashSet<FidListener>();
        this.listeners = new ArrayList<StateListener>();
        this.firebaseApp = firebaseApp;
        this.serviceClient = firebaseInstallationServiceClient;
        this.persistedInstallation = persistedInstallation;
        this.utils = utils;
        this.iidStore = iidStore;
        this.fidGenerator = randomFidGenerator;
        this.backgroundExecutor = executorService;
        this.networkExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }

    private Task<InstallationTokenResult> addGetAuthTokenListener() {
        TaskCompletionSource<InstallationTokenResult> taskCompletionSource = new TaskCompletionSource<InstallationTokenResult>();
        this.addStateListeners(new GetAuthTokenListener(this.utils, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    private Task<String> addGetIdListener() {
        TaskCompletionSource<String> taskCompletionSource = new TaskCompletionSource<String>();
        this.addStateListeners(new GetIdListener(taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addStateListeners(StateListener stateListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(stateListener);
            return;
        }
    }

    private Void deleteFirebaseInstallationId() throws FirebaseInstallationsException {
        this.updateCacheFid(null);
        PersistedInstallationEntry persistedInstallationEntry = this.getMultiProcessSafePrefs();
        if (persistedInstallationEntry.isRegistered()) {
            this.serviceClient.deleteFirebaseInstallation(this.getApiKey(), persistedInstallationEntry.getFirebaseInstallationId(), this.getProjectIdentifier(), persistedInstallationEntry.getRefreshToken());
        }
        this.insertOrUpdatePrefs(persistedInstallationEntry.withNoGeneratedFid());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doNetworkCallIfNecessary(boolean bl) {
        PersistedInstallationEntry persistedInstallationEntry = this.getMultiProcessSafePrefs();
        try {
            PersistedInstallationEntry persistedInstallationEntry2;
            if (!persistedInstallationEntry.isErrored() && !persistedInstallationEntry.isUnregistered()) {
                if (!bl) {
                    if (!this.utils.isAuthTokenExpired(persistedInstallationEntry)) return;
                }
                persistedInstallationEntry2 = this.fetchAuthTokenFromServer(persistedInstallationEntry);
            } else {
                persistedInstallationEntry2 = this.registerFidWithServer(persistedInstallationEntry);
            }
            this.insertOrUpdatePrefs(persistedInstallationEntry2);
            this.updateFidListener(persistedInstallationEntry, persistedInstallationEntry2);
            if (persistedInstallationEntry2.isRegistered()) {
                this.updateCacheFid(persistedInstallationEntry2.getFirebaseInstallationId());
            }
            if (persistedInstallationEntry2.isErrored()) {
                this.triggerOnException(new FirebaseInstallationsException(FirebaseInstallationsException.Status.BAD_CONFIG));
                return;
            }
            if (persistedInstallationEntry2.isNotGenerated()) {
                this.triggerOnException(new IOException(AUTH_ERROR_MSG));
                return;
            }
            this.triggerOnStateReached(persistedInstallationEntry2);
            return;
        }
        catch (FirebaseInstallationsException firebaseInstallationsException) {
            this.triggerOnException(firebaseInstallationsException);
            return;
        }
    }

    private final void doRegistrationOrRefresh(boolean bl) {
        PersistedInstallationEntry persistedInstallationEntry;
        PersistedInstallationEntry persistedInstallationEntry2 = persistedInstallationEntry = this.getPrefsWithGeneratedIdMultiProcessSafe();
        if (bl) {
            persistedInstallationEntry2 = persistedInstallationEntry.withClearedAuthToken();
        }
        this.triggerOnStateReached(persistedInstallationEntry2);
        this.networkExecutor.execute(new FirebaseInstallations$$ExternalSyntheticLambda1(this, bl));
    }

    private PersistedInstallationEntry fetchAuthTokenFromServer(PersistedInstallationEntry persistedInstallationEntry) throws FirebaseInstallationsException {
        TokenResult tokenResult = this.serviceClient.generateAuthToken(this.getApiKey(), persistedInstallationEntry.getFirebaseInstallationId(), this.getProjectIdentifier(), persistedInstallationEntry.getRefreshToken());
        int n = 3.$SwitchMap$com$google$firebase$installations$remote$TokenResult$ResponseCode[tokenResult.getResponseCode().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.updateCacheFid(null);
                    return persistedInstallationEntry.withNoGeneratedFid();
                }
                throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
            }
            return persistedInstallationEntry.withFisError("BAD CONFIG");
        }
        return persistedInstallationEntry.withAuthToken(tokenResult.getToken(), tokenResult.getTokenExpirationTimestamp(), this.utils.currentTimeInSecs());
    }

    private String getCacheFid() {
        synchronized (this) {
            String string2 = this.cachedFid;
            return string2;
        }
    }

    public static FirebaseInstallations getInstance() {
        return FirebaseInstallations.getInstance(FirebaseApp.getInstance());
    }

    public static FirebaseInstallations getInstance(FirebaseApp firebaseApp) {
        boolean bl = firebaseApp != null;
        Preconditions.checkArgument(bl, "Null is not a valid value of FirebaseApp.");
        return (FirebaseInstallations)firebaseApp.get(FirebaseInstallationsApi.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PersistedInstallationEntry getMultiProcessSafePrefs() {
        Object object = lockGenerateFid;
        synchronized (object) {
            CrossProcessLock crossProcessLock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
            try {
                PersistedInstallationEntry persistedInstallationEntry = this.persistedInstallation.readPersistedInstallationEntryValue();
                return persistedInstallationEntry;
            }
            finally {
                if (crossProcessLock != null) {
                    crossProcessLock.releaseAndClose();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PersistedInstallationEntry getPrefsWithGeneratedIdMultiProcessSafe() {
        Object object = lockGenerateFid;
        synchronized (object) {
            CrossProcessLock crossProcessLock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
            try {
                PersistedInstallationEntry persistedInstallationEntry = this.persistedInstallation.readPersistedInstallationEntryValue();
                Object object2 = persistedInstallationEntry;
                if (persistedInstallationEntry.isNotGenerated()) {
                    object2 = this.readExistingIidOrCreateFid(persistedInstallationEntry);
                    object2 = this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(persistedInstallationEntry.withUnregisteredFid((String)object2));
                }
                return object2;
            }
            finally {
                if (crossProcessLock != null) {
                    crossProcessLock.releaseAndClose();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertOrUpdatePrefs(PersistedInstallationEntry persistedInstallationEntry) {
        Object object = lockGenerateFid;
        synchronized (object) {
            CrossProcessLock crossProcessLock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
            try {
                this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(persistedInstallationEntry);
                return;
            }
            finally {
                if (crossProcessLock != null) {
                    crossProcessLock.releaseAndClose();
                }
            }
        }
    }

    private void preConditionChecks() {
        Preconditions.checkNotEmpty(this.getApplicationId(), APP_ID_VALIDATION_MSG);
        Preconditions.checkNotEmpty(this.getProjectIdentifier(), PROJECT_ID_VALIDATION_MSG);
        Preconditions.checkNotEmpty(this.getApiKey(), API_KEY_VALIDATION_MSG);
        Preconditions.checkArgument(Utils.isValidAppIdFormat(this.getApplicationId()), APP_ID_VALIDATION_MSG);
        Preconditions.checkArgument(Utils.isValidApiKeyFormat(this.getApiKey()), API_KEY_VALIDATION_MSG);
    }

    private String readExistingIidOrCreateFid(PersistedInstallationEntry object) {
        if (!this.firebaseApp.getName().equals(CHIME_FIREBASE_APP_NAME) && !this.firebaseApp.isDefaultApp() || !((PersistedInstallationEntry)object).shouldAttemptMigration()) {
            return this.fidGenerator.createRandomFid();
        }
        String string2 = this.iidStore.readIid();
        object = string2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            object = this.fidGenerator.createRandomFid();
        }
        return object;
    }

    private PersistedInstallationEntry registerFidWithServer(PersistedInstallationEntry persistedInstallationEntry) throws FirebaseInstallationsException {
        Object object = persistedInstallationEntry.getFirebaseInstallationId() != null && persistedInstallationEntry.getFirebaseInstallationId().length() == 11 ? this.iidStore.readToken() : null;
        object = this.serviceClient.createFirebaseInstallation(this.getApiKey(), persistedInstallationEntry.getFirebaseInstallationId(), this.getProjectIdentifier(), this.getApplicationId(), (String)object);
        int n = 3.$SwitchMap$com$google$firebase$installations$remote$InstallationResponse$ResponseCode[((InstallationResponse)object).getResponseCode().ordinal()];
        if (n != 1) {
            if (n == 2) {
                return persistedInstallationEntry.withFisError("BAD CONFIG");
            }
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        return persistedInstallationEntry.withRegisteredFid(((InstallationResponse)object).getFid(), ((InstallationResponse)object).getRefreshToken(), this.utils.currentTimeInSecs(), ((InstallationResponse)object).getAuthToken().getToken(), ((InstallationResponse)object).getAuthToken().getTokenExpirationTimestamp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void triggerOnException(Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> iterator2 = this.listeners.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().onException(exception)) continue;
                iterator2.remove();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void triggerOnStateReached(PersistedInstallationEntry persistedInstallationEntry) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> iterator2 = this.listeners.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().onStateReached(persistedInstallationEntry)) continue;
                iterator2.remove();
            }
            return;
        }
    }

    private void updateCacheFid(String string2) {
        synchronized (this) {
            this.cachedFid = string2;
            return;
        }
    }

    private void updateFidListener(PersistedInstallationEntry object, PersistedInstallationEntry persistedInstallationEntry) {
        synchronized (this) {
            if (this.fidListeners.size() != 0 && !((PersistedInstallationEntry)object).getFirebaseInstallationId().equals(persistedInstallationEntry.getFirebaseInstallationId())) {
                object = this.fidListeners.iterator();
                while (object.hasNext()) {
                    ((FidListener)object.next()).onFidChanged(persistedInstallationEntry.getFirebaseInstallationId());
                }
            }
            return;
        }
    }

    @Override
    public Task<Void> delete() {
        return Tasks.call(this.backgroundExecutor, new FirebaseInstallations$$ExternalSyntheticLambda3(this));
    }

    String getApiKey() {
        return this.firebaseApp.getOptions().getApiKey();
    }

    String getApplicationId() {
        return this.firebaseApp.getOptions().getApplicationId();
    }

    @Override
    public Task<String> getId() {
        this.preConditionChecks();
        Object object = this.getCacheFid();
        if (object != null) {
            return Tasks.forResult(object);
        }
        object = this.addGetIdListener();
        this.backgroundExecutor.execute(new FirebaseInstallations$$ExternalSyntheticLambda0(this));
        return object;
    }

    String getName() {
        return this.firebaseApp.getName();
    }

    String getProjectIdentifier() {
        return this.firebaseApp.getOptions().getProjectId();
    }

    @Override
    public Task<InstallationTokenResult> getToken(boolean bl) {
        this.preConditionChecks();
        Task<InstallationTokenResult> task = this.addGetAuthTokenListener();
        this.backgroundExecutor.execute(new FirebaseInstallations$$ExternalSyntheticLambda2(this, bl));
        return task;
    }

    public /* synthetic */ void lambda$doRegistrationOrRefresh$2$com-google-firebase-installations-FirebaseInstallations(boolean bl) {
        this.doNetworkCallIfNecessary(bl);
    }

    public /* synthetic */ void lambda$getId$0$com-google-firebase-installations-FirebaseInstallations() {
        this.doRegistrationOrRefresh(false);
    }

    public /* synthetic */ void lambda$getToken$1$com-google-firebase-installations-FirebaseInstallations(boolean bl) {
        this.doRegistrationOrRefresh(bl);
    }

    @Override
    public FidListenerHandle registerFidListener(FidListener object) {
        synchronized (this) {
            this.fidListeners.add((FidListener)object);
            object = new FidListenerHandle((FidListener)object){
                final /* synthetic */ FidListener val$listener;
                {
                    this.val$listener = fidListener;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void unregister() {
                    FirebaseInstallations firebaseInstallations = FirebaseInstallations.this;
                    synchronized (firebaseInstallations) {
                        FirebaseInstallations.this.fidListeners.remove(this.val$listener);
                        return;
                    }
                }
            };
            return object;
        }
    }
}

