/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.util.Base64;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;

public class RandomFidGenerator {
    private static final byte FID_4BIT_PREFIX = Byte.parseByte("01110000", 2);
    private static final int FID_LENGTH = 22;
    private static final byte REMOVE_PREFIX_MASK = Byte.parseByte("00001111", 2);

    private static String encodeFidBase64UrlSafe(byte[] byArray) {
        return new String(Base64.encode((byte[])byArray, (int)11), Charset.defaultCharset()).substring(0, 22);
    }

    private static byte[] getBytesFromUUID(UUID uUID, byte[] object) {
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).putLong(uUID.getMostSignificantBits());
        ((ByteBuffer)object).putLong(uUID.getLeastSignificantBits());
        return ((ByteBuffer)object).array();
    }

    public String createRandomFid() {
        byte[] byArray = RandomFidGenerator.getBytesFromUUID(UUID.randomUUID(), new byte[17]);
        byArray[16] = byArray[0];
        byArray[0] = (byte)(REMOVE_PREFIX_MASK & byArray[0] | FID_4BIT_PREFIX);
        return RandomFidGenerator.encodeFidBase64UrlSafe(byArray);
    }
}

