/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import com.google.firebase.installations.time.Clock;
import com.google.firebase.installations.time.SystemClock;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class Utils {
    private static final Pattern API_KEY_FORMAT;
    private static final String APP_ID_IDENTIFICATION_SUBSTRING = ":";
    public static final long AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS;
    private static Utils singleton;
    private final Clock clock;

    static {
        AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS = TimeUnit.HOURS.toSeconds(1L);
        API_KEY_FORMAT = Pattern.compile("\\AA[\\w-]{38}\\z");
    }

    private Utils(Clock clock) {
        this.clock = clock;
    }

    public static Utils getInstance() {
        return Utils.getInstance(SystemClock.getInstance());
    }

    public static Utils getInstance(Clock clock) {
        if (singleton == null) {
            singleton = new Utils(clock);
        }
        return singleton;
    }

    static boolean isValidApiKeyFormat(String string2) {
        return API_KEY_FORMAT.matcher(string2).matches();
    }

    static boolean isValidAppIdFormat(String string2) {
        return string2.contains(APP_ID_IDENTIFICATION_SUBSTRING);
    }

    public long currentTimeInMillis() {
        return this.clock.currentTimeMillis();
    }

    public long currentTimeInSecs() {
        return TimeUnit.MILLISECONDS.toSeconds(this.currentTimeInMillis());
    }

    public long getRandomDelayForSyncPrevention() {
        return (long)(Math.random() * 1000.0);
    }

    public boolean isAuthTokenExpired(PersistedInstallationEntry persistedInstallationEntry) {
        if (TextUtils.isEmpty((CharSequence)persistedInstallationEntry.getAuthToken())) {
            return true;
        }
        return persistedInstallationEntry.getTokenCreationEpochInSecs() + persistedInstallationEntry.getExpiresInSecs() < this.currentTimeInSecs() + AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS;
    }
}

