/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class IidStore {
    private static final String[] ALLOWABLE_SCOPES = new String[]{"*", "FCM", "GCM", ""};
    private static final String IID_SHARED_PREFS_NAME = "com.google.android.gms.appid";
    private static final String JSON_ENCODED_PREFIX = "{";
    private static final String JSON_TOKEN_KEY = "token";
    private static final String STORE_KEY_ID = "|S|id";
    private static final String STORE_KEY_PUB = "|S||P|";
    private static final String STORE_KEY_SEPARATOR = "|";
    private static final String STORE_KEY_TOKEN = "|T|";
    private final String defaultSenderId;
    private final SharedPreferences iidPrefs;

    public IidStore(SharedPreferences sharedPreferences, String string2) {
        this.iidPrefs = sharedPreferences;
        this.defaultSenderId = string2;
    }

    public IidStore(FirebaseApp firebaseApp) {
        this.iidPrefs = firebaseApp.getApplicationContext().getSharedPreferences(IID_SHARED_PREFS_NAME, 0);
        this.defaultSenderId = IidStore.getDefaultSenderId(firebaseApp);
    }

    private String createTokenKey(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STORE_KEY_TOKEN);
        stringBuilder.append(string2);
        stringBuilder.append(STORE_KEY_SEPARATOR);
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    private static String getDefaultSenderId(FirebaseApp object) {
        String string2 = ((FirebaseApp)object).getOptions().getGcmSenderId();
        if (string2 != null) {
            return string2;
        }
        if (!((String)(object = ((FirebaseApp)object).getOptions().getApplicationId())).startsWith("1:") && !((String)object).startsWith("2:")) {
            return object;
        }
        if (((String[])(object = ((String)object).split(":"))).length != 4) {
            return null;
        }
        if (((String)(object = object[1])).isEmpty()) {
            return null;
        }
        return object;
    }

    private static String getIdFromPublicKey(PublicKey object) {
        object = object.getEncoded();
        try {
            object = MessageDigest.getInstance("SHA1").digest((byte[])object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"ContentValues", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
        object[0] = (byte)((object[0] & 0xF) + 112 & 0xFF);
        object = Base64.encodeToString((byte[])object, (int)0, (int)8, (int)11);
        return object;
    }

    private String parseIidTokenFromJson(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            string2 = jSONObject.getString(JSON_TOKEN_KEY);
            return string2;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private PublicKey parseKey(String object) {
        void var1_5;
        try {
            object = Base64.decode((String)object, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
            object = keyFactory.generatePublic(x509EncodedKeySpec);
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid key stored ");
        stringBuilder.append(var1_5);
        Log.w((String)"ContentValues", (String)stringBuilder.toString());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readInstanceIdFromLocalStorage() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            return this.iidPrefs.getString(STORE_KEY_ID, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPublicKeyFromLocalStorageAndCalculateInstanceId() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            Object object = this.iidPrefs.getString(STORE_KEY_PUB, null);
            if (object == null) {
                return null;
            }
            if ((object = this.parseKey((String)object)) != null) return IidStore.getIdFromPublicKey((PublicKey)object);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readIid() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            String string2 = this.readInstanceIdFromLocalStorage();
            if (string2 == null) return this.readPublicKeyFromLocalStorageAndCalculateInstanceId();
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readToken() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            Object object = ALLOWABLE_SCOPES;
            int n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = object[n2];
                string2 = this.createTokenKey(this.defaultSenderId, string2);
                if ((string2 = this.iidPrefs.getString(string2, null)) != null && !string2.isEmpty()) {
                    object = string2;
                    if (!string2.startsWith(JSON_ENCODED_PREFIX)) return object;
                    return this.parseIidTokenFromJson(string2);
                }
                ++n2;
            }
            return null;
        }
    }
}

