/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class PersistedInstallation {
    private static final String AUTH_TOKEN_KEY = "AuthToken";
    private static final String EXPIRES_IN_SECONDS_KEY = "ExpiresInSecs";
    private static final String FIREBASE_INSTALLATION_ID_KEY = "Fid";
    private static final String FIS_ERROR_KEY = "FisError";
    private static final String PERSISTED_STATUS_KEY = "Status";
    private static final String REFRESH_TOKEN_KEY = "RefreshToken";
    private static final String SETTINGS_FILE_NAME_PREFIX = "PersistedInstallation";
    private static final String TOKEN_CREATION_TIME_IN_SECONDS_KEY = "TokenCreationEpochInSecs";
    private File dataFile;
    private final FirebaseApp firebaseApp;

    public PersistedInstallation(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getDataFile() {
        if (this.dataFile != null) return this.dataFile;
        synchronized (this) {
            File file;
            if (this.dataFile != null) return this.dataFile;
            File file2 = this.firebaseApp.getApplicationContext().getFilesDir();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PersistedInstallation.");
            stringBuilder.append(this.firebaseApp.getPersistenceKey());
            stringBuilder.append(".json");
            this.dataFile = file = new File(file2, stringBuilder.toString());
            return this.dataFile;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject readJSONFromFile() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        FileInputStream fileInputStream = new FileInputStream(this.getDataFile());
        while (true) {
            n = fileInputStream.read(byArray, 0, 16384);
            if (n >= 0) break block11;
            break;
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException | JSONException throwable3) {
                    return new JSONObject();
                }
            }
        }
        {
            block11: {
                JSONObject jSONObject = new JSONObject(byteArrayOutputStream.toString());
                fileInputStream.close();
                return jSONObject;
            }
            byteArrayOutputStream.write(byArray, 0, n);
            continue;
        }
    }

    public void clearForTesting() {
        this.getDataFile().delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PersistedInstallationEntry insertOrUpdatePersistedInstallationEntry(PersistedInstallationEntry persistedInstallationEntry) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(FIREBASE_INSTALLATION_ID_KEY, (Object)persistedInstallationEntry.getFirebaseInstallationId());
            jSONObject.put(PERSISTED_STATUS_KEY, persistedInstallationEntry.getRegistrationStatus().ordinal());
            jSONObject.put(AUTH_TOKEN_KEY, (Object)persistedInstallationEntry.getAuthToken());
            jSONObject.put(REFRESH_TOKEN_KEY, (Object)persistedInstallationEntry.getRefreshToken());
            jSONObject.put(TOKEN_CREATION_TIME_IN_SECONDS_KEY, persistedInstallationEntry.getTokenCreationEpochInSecs());
            jSONObject.put(EXPIRES_IN_SECONDS_KEY, persistedInstallationEntry.getExpiresInSecs());
            jSONObject.put(FIS_ERROR_KEY, (Object)persistedInstallationEntry.getFisError());
            File file = File.createTempFile(SETTINGS_FILE_NAME_PREFIX, "tmp", this.firebaseApp.getApplicationContext().getFilesDir());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(jSONObject.toString().getBytes("UTF-8"));
            fileOutputStream.close();
            if (!file.renameTo(this.getDataFile())) {
                IOException iOException = new IOException("unable to rename the tmpfile to PersistedInstallation");
                throw iOException;
            }
            return persistedInstallationEntry;
        }
        catch (IOException | JSONException throwable) {
            return persistedInstallationEntry;
        }
    }

    public PersistedInstallationEntry readPersistedInstallationEntryValue() {
        Object object = this.readJSONFromFile();
        String string2 = object.optString(FIREBASE_INSTALLATION_ID_KEY, null);
        int n = object.optInt(PERSISTED_STATUS_KEY, RegistrationStatus.ATTEMPT_MIGRATION.ordinal());
        String string3 = object.optString(AUTH_TOKEN_KEY, null);
        String string4 = object.optString(REFRESH_TOKEN_KEY, null);
        long l = object.optLong(TOKEN_CREATION_TIME_IN_SECONDS_KEY, 0L);
        long l2 = object.optLong(EXPIRES_IN_SECONDS_KEY, 0L);
        object = object.optString(FIS_ERROR_KEY, null);
        return PersistedInstallationEntry.builder().setFirebaseInstallationId(string2).setRegistrationStatus(RegistrationStatus.values()[n]).setAuthToken(string3).setRefreshToken(string4).setTokenCreationEpochInSecs(l).setExpiresInSecs(l2).setFisError((String)object).build();
    }

    public static final class RegistrationStatus
    extends Enum<RegistrationStatus> {
        private static final /* synthetic */ RegistrationStatus[] $VALUES;
        public static final /* enum */ RegistrationStatus ATTEMPT_MIGRATION;
        public static final /* enum */ RegistrationStatus NOT_GENERATED;
        public static final /* enum */ RegistrationStatus REGISTERED;
        public static final /* enum */ RegistrationStatus REGISTER_ERROR;
        public static final /* enum */ RegistrationStatus UNREGISTERED;

        static {
            RegistrationStatus registrationStatus;
            RegistrationStatus registrationStatus2;
            RegistrationStatus registrationStatus3;
            RegistrationStatus registrationStatus4;
            RegistrationStatus registrationStatus5;
            ATTEMPT_MIGRATION = registrationStatus5 = new RegistrationStatus();
            NOT_GENERATED = registrationStatus4 = new RegistrationStatus();
            UNREGISTERED = registrationStatus3 = new RegistrationStatus();
            REGISTERED = registrationStatus2 = new RegistrationStatus();
            REGISTER_ERROR = registrationStatus = new RegistrationStatus();
            $VALUES = new RegistrationStatus[]{registrationStatus5, registrationStatus4, registrationStatus3, registrationStatus2, registrationStatus};
        }

        public static RegistrationStatus valueOf(String string2) {
            return Enum.valueOf(RegistrationStatus.class, string2);
        }

        public static RegistrationStatus[] values() {
            return (RegistrationStatus[])$VALUES.clone();
        }
    }
}

