/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import com.google.firebase.installations.local.AutoValue_PersistedInstallationEntry;
import com.google.firebase.installations.local.PersistedInstallation;

public abstract class PersistedInstallationEntry {
    public static PersistedInstallationEntry INSTANCE = PersistedInstallationEntry.builder().build();

    public static Builder builder() {
        return new AutoValue_PersistedInstallationEntry.Builder().setTokenCreationEpochInSecs(0L).setRegistrationStatus(PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION).setExpiresInSecs(0L);
    }

    public abstract String getAuthToken();

    public abstract long getExpiresInSecs();

    public abstract String getFirebaseInstallationId();

    public abstract String getFisError();

    public abstract String getRefreshToken();

    public abstract PersistedInstallation.RegistrationStatus getRegistrationStatus();

    public abstract long getTokenCreationEpochInSecs();

    public boolean isErrored() {
        boolean bl = this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.REGISTER_ERROR;
        return bl;
    }

    public boolean isNotGenerated() {
        boolean bl = this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.NOT_GENERATED || this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION;
        return bl;
    }

    public boolean isRegistered() {
        boolean bl = this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.REGISTERED;
        return bl;
    }

    public boolean isUnregistered() {
        boolean bl = this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.UNREGISTERED;
        return bl;
    }

    public boolean shouldAttemptMigration() {
        boolean bl = this.getRegistrationStatus() == PersistedInstallation.RegistrationStatus.ATTEMPT_MIGRATION;
        return bl;
    }

    public abstract Builder toBuilder();

    public PersistedInstallationEntry withAuthToken(String string2, long l, long l2) {
        return this.toBuilder().setAuthToken(string2).setExpiresInSecs(l).setTokenCreationEpochInSecs(l2).build();
    }

    public PersistedInstallationEntry withClearedAuthToken() {
        return this.toBuilder().setAuthToken(null).build();
    }

    public PersistedInstallationEntry withFisError(String string2) {
        return this.toBuilder().setFisError(string2).setRegistrationStatus(PersistedInstallation.RegistrationStatus.REGISTER_ERROR).build();
    }

    public PersistedInstallationEntry withNoGeneratedFid() {
        return this.toBuilder().setRegistrationStatus(PersistedInstallation.RegistrationStatus.NOT_GENERATED).build();
    }

    public PersistedInstallationEntry withRegisteredFid(String string2, String string3, long l, String string4, long l2) {
        return this.toBuilder().setFirebaseInstallationId(string2).setRegistrationStatus(PersistedInstallation.RegistrationStatus.REGISTERED).setAuthToken(string4).setRefreshToken(string3).setExpiresInSecs(l2).setTokenCreationEpochInSecs(l).build();
    }

    public PersistedInstallationEntry withUnregisteredFid(String string2) {
        return this.toBuilder().setFirebaseInstallationId(string2).setRegistrationStatus(PersistedInstallation.RegistrationStatus.UNREGISTERED).build();
    }

    public static abstract class Builder {
        public abstract PersistedInstallationEntry build();

        public abstract Builder setAuthToken(String var1);

        public abstract Builder setExpiresInSecs(long var1);

        public abstract Builder setFirebaseInstallationId(String var1);

        public abstract Builder setFisError(String var1);

        public abstract Builder setRefreshToken(String var1);

        public abstract Builder setRegistrationStatus(PersistedInstallation.RegistrationStatus var1);

        public abstract Builder setTokenCreationEpochInSecs(long var1);
    }
}

