/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public abstract class FieldNamingPolicy
extends Enum<FieldNamingPolicy>
implements FieldNamingStrategy {
    private static final /* synthetic */ FieldNamingPolicy[] $VALUES;
    public static final /* enum */ FieldNamingPolicy IDENTITY;
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_DASHES;
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_DOTS;
    public static final /* enum */ FieldNamingPolicy LOWER_CASE_WITH_UNDERSCORES;
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE;
    public static final /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE_WITH_SPACES;
    public static final /* enum */ FieldNamingPolicy UPPER_CASE_WITH_UNDERSCORES;

    static {
        FieldNamingPolicy fieldNamingPolicy;
        FieldNamingPolicy fieldNamingPolicy2;
        FieldNamingPolicy fieldNamingPolicy3;
        FieldNamingPolicy fieldNamingPolicy4;
        FieldNamingPolicy fieldNamingPolicy5;
        FieldNamingPolicy fieldNamingPolicy6;
        FieldNamingPolicy fieldNamingPolicy7;
        IDENTITY = fieldNamingPolicy7 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return field.getName();
            }
        };
        UPPER_CAMEL_CASE = fieldNamingPolicy6 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 2.upperCaseFirstLetter(field.getName());
            }
        };
        UPPER_CAMEL_CASE_WITH_SPACES = fieldNamingPolicy5 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 3.upperCaseFirstLetter(3.separateCamelCase(field.getName(), ' '));
            }
        };
        UPPER_CASE_WITH_UNDERSCORES = fieldNamingPolicy4 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 4.separateCamelCase(field.getName(), '_').toUpperCase(Locale.ENGLISH);
            }
        };
        LOWER_CASE_WITH_UNDERSCORES = fieldNamingPolicy3 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 5.separateCamelCase(field.getName(), '_').toLowerCase(Locale.ENGLISH);
            }
        };
        LOWER_CASE_WITH_DASHES = fieldNamingPolicy2 = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 6.separateCamelCase(field.getName(), '-').toLowerCase(Locale.ENGLISH);
            }
        };
        LOWER_CASE_WITH_DOTS = fieldNamingPolicy = new FieldNamingPolicy(){

            @Override
            public String translateName(Field field) {
                return 7.separateCamelCase(field.getName(), '.').toLowerCase(Locale.ENGLISH);
            }
        };
        $VALUES = new FieldNamingPolicy[]{fieldNamingPolicy7, fieldNamingPolicy6, fieldNamingPolicy5, fieldNamingPolicy4, fieldNamingPolicy3, fieldNamingPolicy2, fieldNamingPolicy};
    }

    static String separateCamelCase(String string2, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string2.charAt(i);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (!Character.isLetter(c)) continue;
            if (Character.isUpperCase(c)) {
                return string2;
            }
            c = Character.toUpperCase(c);
            if (i == 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(c);
                stringBuilder.append(string2.substring(1));
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2.substring(0, i));
            stringBuilder.append(c);
            stringBuilder.append(string2.substring(i + 1));
            return stringBuilder.toString();
        }
        return string2;
    }

    public static FieldNamingPolicy valueOf(String string2) {
        return Enum.valueOf(FieldNamingPolicy.class, string2);
    }

    public static FieldNamingPolicy[] values() {
        return (FieldNamingPolicy[])$VALUES.clone();
    }
}

