/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Preconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private $Gson$Types() {
        throw new UnsupportedOperationException();
    }

    public static GenericArrayType arrayOf(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            type = clazz;
            if (clazz.isArray()) {
                type = new GenericArrayTypeImpl($Gson$Types.canonicalize(clazz.getComponentType()));
            }
            return type;
        }
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return new ParameterizedTypeImpl(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return new WildcardTypeImpl(type.getUpperBounds(), type.getLowerBounds());
        }
        return type;
    }

    static void checkNotPrimitive(Type type) {
        boolean bl = !(type instanceof Class) || !((Class)type).isPrimitive();
        $Gson$Preconditions.checkArgument(bl);
    }

    private static Class<?> declaringClassOf(TypeVariable<?> type) {
        type = (type = type.getGenericDeclaration()) instanceof Class ? (Class)type : null;
        return type;
    }

    static boolean equal(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    public static boolean equals(Type type, Type type2) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            type = (ParameterizedType)type;
            type2 = (ParameterizedType)type2;
            if (!($Gson$Types.equal(type.getOwnerType(), type2.getOwnerType()) && type.getRawType().equals(type2.getRawType()) && Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments()))) {
                bl3 = false;
            }
            return bl3;
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            return $Gson$Types.equals(type.getGenericComponentType(), type2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            bl3 = Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds()) ? bl : false;
            return bl3;
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            bl3 = type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName()) ? bl2 : false;
            return bl3;
        }
        return false;
    }

    public static Type getArrayComponentType(Type type) {
        type = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
        return type;
    }

    public static Type getCollectionElementType(Type type, Class<?> type2) {
        type = type2 = $Gson$Types.getSupertype(type, type2, Collection.class);
        if (type2 instanceof WildcardType) {
            type = ((WildcardType)type2).getUpperBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        if (clazz == object2) {
            return object;
        }
        if (clazz.isInterface()) {
            object = ((Class)object2).getInterfaces();
            int n = ((Class<?>[])object).length;
            for (int i = 0; i < n; ++i) {
                if (object[i] == clazz) {
                    return ((Class)object2).getGenericInterfaces()[i];
                }
                if (!clazz.isAssignableFrom(object[i])) continue;
                return $Gson$Types.getGenericSupertype(((Class)object2).getGenericInterfaces()[i], object[i], clazz);
            }
        }
        if (!((Class)object2).isInterface()) {
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    return $Gson$Types.getGenericSupertype(((Class)object2).getGenericSuperclass(), object, clazz);
                }
                object2 = object;
            }
        }
        return clazz;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        if ((type = $Gson$Types.getSupertype(type, clazz, Map.class)) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
            $Gson$Preconditions.checkArgument(type instanceof Class);
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance($Gson$Types.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return $Gson$Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String string2 = type == null ? "null" : type.getClass().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a Class, ParameterizedType, or GenericArrayType, but <");
        stringBuilder.append(type);
        stringBuilder.append("> is of type ");
        stringBuilder.append(string2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        Type type2 = type;
        if (type instanceof WildcardType) {
            type2 = ((WildcardType)type).getUpperBounds()[0];
        }
        $Gson$Preconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type2, clazz, $Gson$Types.getGenericSupertype(type2, clazz, clazz2));
    }

    static int hashCodeOrZero(Object object) {
        int n = object != null ? object.hashCode() : 0;
        return n;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Type type2, Type ... typeArray) {
        return new ParameterizedTypeImpl(type, type2, typeArray);
    }

    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        return $Gson$Types.resolve(type, clazz, type2, new HashMap());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Type resolve(Type type, Class<?> clazz, Type object, Map<TypeVariable<?>, Type> map) {
        void var2_30;
        void var6_51;
        void var3_31;
        block16: {
            Type[] typeArray;
            void var4_33;
            Object object2;
            block22: {
                block19: {
                    block20: {
                        block21: {
                            block17: {
                                block18: {
                                    Class clazz2;
                                    Object var4_32 = null;
                                    object2 = object;
                                    while (object2 instanceof TypeVariable) {
                                        void var2_8;
                                        TypeVariable typeVariable = (TypeVariable)object2;
                                        Type type2 = (Type)var3_31.get(typeVariable);
                                        if (type2 != null) {
                                            if (type2 != Void.TYPE) return type2;
                                            return object2;
                                        }
                                        var3_31.put(typeVariable, Void.TYPE);
                                        void var2_6 = var4_33;
                                        if (var4_33 == null) {
                                            TypeVariable typeVariable2 = typeVariable;
                                        }
                                        typeArray = $Gson$Types.resolveTypeVariable(type, clazz, typeVariable);
                                        void var4_34 = var2_8;
                                        object2 = typeArray;
                                        if (typeArray != typeVariable) continue;
                                        void var6_37 = var2_8;
                                        Type[] typeArray2 = typeArray;
                                        break block16;
                                    }
                                    if (!(object2 instanceof Class) || !(clazz2 = (Class)object2).isArray()) break block17;
                                    object2 = clazz2.getComponentType();
                                    if (!$Gson$Types.equal(object2, type = $Gson$Types.resolve(type, clazz, (Type)object2, var3_31))) break block18;
                                    void var6_38 = var4_33;
                                    break block16;
                                }
                                type = $Gson$Types.arrayOf(type);
                                break block19;
                            }
                            if (!(object2 instanceof GenericArrayType)) break block20;
                            GenericArrayType genericArrayType = (GenericArrayType)object2;
                            if (!$Gson$Types.equal(object2 = genericArrayType.getGenericComponentType(), type = $Gson$Types.resolve(type, clazz, (Type)object2, var3_31))) break block21;
                            void var6_41 = var4_33;
                            break block16;
                        }
                        type = $Gson$Types.arrayOf(type);
                        break block19;
                    }
                    boolean bl = object2 instanceof ParameterizedType;
                    if (!bl) break block22;
                    typeArray = (ParameterizedType)object2;
                    Type type3 = typeArray.getOwnerType();
                    Type type4 = $Gson$Types.resolve(type, clazz, type3, var3_31);
                    boolean bl2 = $Gson$Types.equal(type4, type3) ^ true;
                    object2 = typeArray.getActualTypeArguments();
                    int n = ((Object)object2).length;
                    for (int i = 0; i < n; ++i) {
                        void var2_21;
                        Type type5 = $Gson$Types.resolve(type, clazz, (Type)object2[i], var3_31);
                        boolean bl3 = bl2;
                        Object object3 = object2;
                        if (!$Gson$Types.equal(type5, object2[i])) {
                            bl3 = bl2;
                            Object object4 = object2;
                            if (!bl2) {
                                Type[] typeArray3 = (Type[])object2.clone();
                                bl3 = true;
                            }
                            var2_20[i] = type5;
                        }
                        bl2 = bl3;
                        object2 = var2_21;
                    }
                    void var6_44 = var4_33;
                    Type[] typeArray4 = typeArray;
                    if (!bl2) break block16;
                    type = $Gson$Types.newParameterizedTypeWithOwner(type4, typeArray.getRawType(), (Type[])object2);
                }
                void var6_40 = var4_33;
                Type type6 = type;
                break block16;
            }
            void var6_45 = var4_33;
            Object object5 = object2;
            if (object2 instanceof WildcardType) {
                object2 = (WildcardType)object2;
                Type[] typeArray5 = object2.getLowerBounds();
                typeArray = object2.getUpperBounds();
                if (typeArray5.length == 1) {
                    type = $Gson$Types.resolve(type, clazz, typeArray5[0], var3_31);
                    void var6_46 = var4_33;
                    Object object6 = object2;
                    if (type != typeArray5[0]) {
                        WildcardType wildcardType = $Gson$Types.supertypeOf(type);
                        void var6_47 = var4_33;
                    }
                } else {
                    void var6_48 = var4_33;
                    Object object7 = object2;
                    if (typeArray.length == 1) {
                        Type type7 = typeArray[0];
                        type = $Gson$Types.resolve(type, clazz, type7, var3_31);
                        void var6_49 = var4_33;
                        Object object8 = object2;
                        if (type != typeArray[0]) {
                            WildcardType wildcardType = $Gson$Types.subtypeOf(type);
                            void var6_50 = var4_33;
                        }
                    }
                }
            }
        }
        if (var6_51 == null) return var2_30;
        var3_31.put(var6_51, var2_30);
        return var2_30;
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = $Gson$Types.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        if ((type = $Gson$Types.getGenericSupertype(type, clazz, clazz2)) instanceof ParameterizedType) {
            int n = $Gson$Types.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type).getActualTypeArguments()[n];
        }
        return typeVariable;
    }

    public static WildcardType subtypeOf(Type typeArray) {
        typeArray = typeArray instanceof WildcardType ? ((WildcardType)typeArray).getUpperBounds() : new Type[]{typeArray};
        return new WildcardTypeImpl(typeArray, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type typeArray) {
        typeArray = typeArray instanceof WildcardType ? ((WildcardType)typeArray).getLowerBounds() : new Type[]{typeArray};
        return new WildcardTypeImpl(new Type[]{Object.class}, typeArray);
    }

    public static String typeToString(Type object) {
        object = object instanceof Class ? ((Class)object).getName() : object.toString();
        return object;
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type componentType;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)object);
            return bl;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append($Gson$Types.typeToString(this.componentType));
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        public ParameterizedTypeImpl(Type object, Type type, Type ... typeArray) {
            int n;
            boolean bl = type instanceof Class;
            int n2 = 0;
            if (bl) {
                Class clazz = (Class)type;
                bl = Modifier.isStatic(clazz.getModifiers());
                boolean bl2 = true;
                n = !bl && clazz.getEnclosingClass() != null ? 0 : 1;
                bl = bl2;
                if (object == null) {
                    bl = n != 0 ? bl2 : false;
                }
                $Gson$Preconditions.checkArgument(bl);
            }
            object = object == null ? null : $Gson$Types.canonicalize((Type)object);
            this.ownerType = object;
            this.rawType = $Gson$Types.canonicalize(type);
            object = (Type[])typeArray.clone();
            this.typeArguments = object;
            int n3 = ((Type[])object).length;
            for (n = n2; n < n3; ++n) {
                $Gson$Preconditions.checkNotNull(this.typeArguments[n]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[n]);
                object = this.typeArguments;
                object[n] = $Gson$Types.canonicalize(object[n]);
            }
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
            return bl;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            int n = this.typeArguments.length;
            if (n == 0) {
                return $Gson$Types.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder((n + 1) * 30);
            stringBuilder.append($Gson$Types.typeToString(this.rawType));
            stringBuilder.append("<");
            stringBuilder.append($Gson$Types.typeToString(this.typeArguments[0]));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append($Gson$Types.typeToString(this.typeArguments[i]));
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Type lowerBound;
        private final Type upperBound;

        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            int n = typeArray2.length;
            boolean bl = true;
            boolean bl2 = n <= 1;
            $Gson$Preconditions.checkArgument(bl2);
            bl2 = typeArray.length == 1;
            $Gson$Preconditions.checkArgument(bl2);
            if (typeArray2.length == 1) {
                $Gson$Preconditions.checkNotNull(typeArray2[0]);
                $Gson$Types.checkNotPrimitive(typeArray2[0]);
                bl2 = typeArray[0] == Object.class ? bl : false;
                $Gson$Preconditions.checkArgument(bl2);
                this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
                this.upperBound = Object.class;
            } else {
                $Gson$Preconditions.checkNotNull(typeArray[0]);
                $Gson$Types.checkNotPrimitive(typeArray[0]);
                this.lowerBound = null;
                this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
            }
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)object);
            return bl;
        }

        @Override
        public Type[] getLowerBounds() {
            Type type = this.lowerBound;
            Type[] typeArray = type != null ? new Type[]{type} : EMPTY_TYPE_ARRAY;
            return typeArray;
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        public int hashCode() {
            Type type = this.lowerBound;
            int n = type != null ? type.hashCode() + 31 : 1;
            return n ^ this.upperBound.hashCode() + 31;
        }

        public String toString() {
            if (this.lowerBound != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("? super ");
                stringBuilder.append($Gson$Types.typeToString(this.lowerBound));
                return stringBuilder.toString();
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("? extends ");
            stringBuilder.append($Gson$Types.typeToString(this.upperBound));
            return stringBuilder.toString();
        }
    }
}

