/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonIOException;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;
    private final boolean useJdkUnsafe;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map, boolean bl) {
        this.instanceCreators = map;
        this.useJdkUnsafe = bl;
    }

    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> object) {
        Constructor<? super T> constructor;
        if (Modifier.isAbstract(((Class)object).getModifiers())) {
            return null;
        }
        try {
            constructor = ((Class)object).getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        object = ReflectionHelper.tryMakeAccessible(constructor);
        if (object != null) {
            return new ObjectConstructor<T>((String)object){
                final /* synthetic */ String val$exceptionMessage;
                {
                    this.val$exceptionMessage = string2;
                }

                @Override
                public T construct() {
                    throw new JsonIOException(this.val$exceptionMessage);
                }
            };
        }
        return new ObjectConstructor<T>(){

            @Override
            public T construct() {
                Object t;
                try {
                    t = constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to invoke ");
                    stringBuilder.append(constructor);
                    stringBuilder.append(" with no args");
                    throw new RuntimeException(stringBuilder.toString(), invocationTargetException.getTargetException());
                }
                catch (InstantiationException instantiationException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to invoke ");
                    stringBuilder.append(constructor);
                    stringBuilder.append(" with no args");
                    throw new RuntimeException(stringBuilder.toString(), instantiationException);
                }
                return t;
            }
        };
    }

    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        Object object = type;
                        if (object instanceof ParameterizedType) {
                            if ((object = ((ParameterizedType)object).getActualTypeArguments()[0]) instanceof Class) {
                                return EnumSet.noneOf((Class)object);
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Invalid EnumSet type: ");
                            ((StringBuilder)object).append(type.toString());
                            throw new JsonIOException(((StringBuilder)object).toString());
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Invalid EnumSet type: ");
                        ((StringBuilder)object).append(type.toString());
                        throw new JsonIOException(((StringBuilder)object).toString());
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ArrayDeque();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (clazz == EnumMap.class) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        Object object = type;
                        if (object instanceof ParameterizedType) {
                            if ((object = ((ParameterizedType)object).getActualTypeArguments()[0]) instanceof Class) {
                                return new EnumMap((Class)object);
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Invalid EnumMap type: ");
                            ((StringBuilder)object).append(type.toString());
                            throw new JsonIOException(((StringBuilder)object).toString());
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Invalid EnumMap type: ");
                        ((StringBuilder)object).append(type.toString());
                        throw new JsonIOException(((StringBuilder)object).toString());
                    }
                };
            }
            if (ConcurrentNavigableMap.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentSkipListMap();
                    }
                };
            }
            if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new ConcurrentHashMap();
                    }
                };
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(final Class<? super T> clazz) {
        if (this.useJdkUnsafe) {
            return new ObjectConstructor<T>(){
                private final UnsafeAllocator unsafeAllocator = UnsafeAllocator.create();

                @Override
                public T construct() {
                    Object t;
                    try {
                        t = this.unsafeAllocator.newInstance(clazz);
                    }
                    catch (Exception exception) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unable to create instance of ");
                        stringBuilder.append(clazz);
                        stringBuilder.append(". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.");
                        throw new RuntimeException(stringBuilder.toString(), exception);
                    }
                    return t;
                }
            };
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to create instance of ");
        stringBuilder.append(clazz);
        stringBuilder.append("; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.");
        return new ObjectConstructor<T>(stringBuilder.toString()){
            final /* synthetic */ String val$exceptionMessage;
            {
                this.val$exceptionMessage = string2;
            }

            @Override
            public T construct() {
                throw new JsonIOException(this.val$exceptionMessage);
            }
        };
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> object) {
        Object object2 = ((TypeToken)object).getType();
        object = ((TypeToken)object).getRawType();
        Object object3 = this.instanceCreators.get(object2);
        if (object3 != null) {
            return new ObjectConstructor<T>((InstanceCreator)object3, (Type)object2){
                final /* synthetic */ Type val$type;
                final /* synthetic */ InstanceCreator val$typeCreator;
                {
                    this.val$typeCreator = instanceCreator;
                    this.val$type = type;
                }

                @Override
                public T construct() {
                    return this.val$typeCreator.createInstance(this.val$type);
                }
            };
        }
        object3 = this.instanceCreators.get(object);
        if (object3 != null) {
            return new ObjectConstructor<T>((InstanceCreator)object3, (Type)object2){
                final /* synthetic */ InstanceCreator val$rawTypeCreator;
                final /* synthetic */ Type val$type;
                {
                    this.val$rawTypeCreator = instanceCreator;
                    this.val$type = type;
                }

                @Override
                public T construct() {
                    return this.val$rawTypeCreator.createInstance(this.val$type);
                }
            };
        }
        object3 = this.newDefaultConstructor((Class<? super T>)object);
        if (object3 != null) {
            return object3;
        }
        if ((object2 = this.newDefaultImplementationConstructor((Type)object2, (Class<? super T>)object)) != null) {
            return object2;
        }
        return this.newUnsafeAllocator((Class<? super T>)object);
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

