/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

public final class JavaVersion {
    private static final int majorJavaVersion = JavaVersion.determineMajorJavaVersion();

    private JavaVersion() {
    }

    private static int determineMajorJavaVersion() {
        return JavaVersion.getMajorJavaVersion(System.getProperty("java.version"));
    }

    private static int extractBeginningInt(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            char c;
            if (n >= string2.length() || !Character.isDigit(c = string2.charAt(n))) break;
            stringBuilder.append(c);
            ++n;
            continue;
            break;
        }
        try {
            n = Integer.parseInt(stringBuilder.toString());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int getMajorJavaVersion() {
        return majorJavaVersion;
    }

    static int getMajorJavaVersion(String string2) {
        int n;
        int n2 = n = JavaVersion.parseDotted(string2);
        if (n == -1) {
            n2 = JavaVersion.extractBeginningInt(string2);
        }
        if (n2 == -1) {
            return 6;
        }
        return n2;
    }

    public static boolean isJava9OrLater() {
        boolean bl = majorJavaVersion >= 9;
        return bl;
    }

    private static int parseDotted(String stringArray) {
        int n;
        block3: {
            try {
                stringArray = stringArray.split("[._]");
                n = Integer.parseInt(stringArray[0]);
                if (n != 1) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (stringArray.length <= 1) break block3;
            n = Integer.parseInt(stringArray[1]);
            return n;
        }
        return n;
    }
}

