/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    private static String constructorToString(Constructor<?> classArray) {
        StringBuilder stringBuilder = new StringBuilder(classArray.getDeclaringClass().getName());
        stringBuilder.append('#');
        stringBuilder.append(classArray.getDeclaringClass().getSimpleName());
        stringBuilder.append('(');
        classArray = classArray.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(classArray[i].getSimpleName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static void makeAccessible(Field field) throws JsonIOException {
        try {
            field.setAccessible(true);
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed making field '");
            stringBuilder.append(field.getDeclaringClass().getName());
            stringBuilder.append("#");
            stringBuilder.append(field.getName());
            stringBuilder.append("' accessible; either change its visibility or write a custom TypeAdapter for its declaring type");
            throw new JsonIOException(stringBuilder.toString(), exception);
        }
    }

    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed making constructor '");
            stringBuilder.append(ReflectionHelper.constructorToString(constructor));
            stringBuilder.append("' accessible; either change its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: ");
            stringBuilder.append(exception.getMessage());
            return stringBuilder.toString();
        }
    }
}

