/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.sql;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson object, TypeToken<T> object2) {
            object2 = ((TypeToken)object2).getRawType();
            object = null;
            if (object2 == java.sql.Date.class) {
                object = new SqlDateTypeAdapter();
            }
            return object;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.sql.Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string2 = jsonReader.nextString();
        try {
            synchronized (this) {
            }
        }
        catch (ParseException parseException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed parsing '");
            stringBuilder.append(string2);
            stringBuilder.append("' as SQL Date; at path ");
            stringBuilder.append(jsonReader.getPreviousPath());
            throw new JsonSyntaxException(stringBuilder.toString(), parseException);
        }
        {
            Date date = this.format.parse(string2);
            return new java.sql.Date(date.getTime());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(JsonWriter jsonWriter, java.sql.Date object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        synchronized (this) {
            object = this.format.format((Date)object);
        }
        jsonWriter.value((String)object);
    }
}

