/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private static final String[] REPLACEMENT_CHARS;
    private static final Pattern VALID_JSON_NUMBER_PATTERN;
    private String deferredName;
    private boolean htmlSafe;
    private String indent;
    private boolean lenient;
    private final Writer out;
    private String separator;
    private boolean serializeNulls;
    private int[] stack = new int[32];
    private int stackSize = 0;

    static {
        VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
        REPLACEMENT_CHARS = new String[128];
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        String[] stringArray = REPLACEMENT_CHARS;
        stringArray[34] = "\\\"";
        stringArray[92] = "\\\\";
        stringArray[9] = "\\t";
        stringArray[8] = "\\b";
        stringArray[10] = "\\n";
        stringArray[13] = "\\r";
        stringArray[12] = "\\f";
        stringArray = (String[])stringArray.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        stringArray[62] = "\\u003e";
        stringArray[38] = "\\u0026";
        stringArray[61] = "\\u003d";
        stringArray[39] = "\\u0027";
    }

    public JsonWriter(Writer writer) {
        this.push(6);
        this.separator = ":";
        this.serializeNulls = true;
        Objects.requireNonNull(writer, "out == null");
        this.out = writer;
    }

    private void beforeName() throws IOException {
        block4: {
            block3: {
                int n;
                block2: {
                    n = this.peek();
                    if (n != 5) break block2;
                    this.out.write(44);
                    break block3;
                }
                if (n != 3) break block4;
            }
            this.newline();
            this.replaceTop(4);
            return;
        }
        throw new IllegalStateException("Nesting problem.");
    }

    private void beforeValue() throws IOException {
        int n = this.peek();
        if (n != 1) {
            if (n != 2) {
                if (n != 4) {
                    if (n != 6) {
                        if (n == 7) {
                            if (!this.lenient) {
                                throw new IllegalStateException("JSON must have only one top-level value.");
                            }
                        } else {
                            throw new IllegalStateException("Nesting problem.");
                        }
                    }
                    this.replaceTop(7);
                } else {
                    this.out.append(this.separator);
                    this.replaceTop(5);
                }
            } else {
                this.out.append(',');
                this.newline();
            }
        } else {
            this.replaceTop(2);
            this.newline();
        }
    }

    private JsonWriter close(int n, int n2, char c) throws IOException {
        int n3 = this.peek();
        if (n3 != n2 && n3 != n) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName == null) {
            --this.stackSize;
            if (n3 == n2) {
                this.newline();
            }
            this.out.write(c);
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dangling name: ");
        stringBuilder.append(this.deferredName);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private static boolean isTrustedNumberType(Class<? extends Number> clazz) {
        boolean bl = clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Byte.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
        return bl;
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        int n = this.stackSize;
        for (int i = 1; i < n; ++i) {
            this.out.write(this.indent);
        }
    }

    private JsonWriter open(int n, char c) throws IOException {
        this.beforeValue();
        this.push(n);
        this.out.write(c);
        return this;
    }

    private int peek() {
        int n = this.stackSize;
        if (n != 0) {
            return this.stack[n - 1];
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    private void push(int n) {
        int n2 = this.stackSize;
        int[] nArray = this.stack;
        if (n2 == nArray.length) {
            this.stack = Arrays.copyOf(nArray, n2 * 2);
        }
        nArray = this.stack;
        n2 = this.stackSize;
        this.stackSize = n2 + 1;
        nArray[n2] = n;
    }

    private void replaceTop(int n) {
        this.stack[this.stackSize - 1] = n;
    }

    private void string(String string2) throws IOException {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write(34);
        int n = string2.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            block8: {
                String string3;
                block7: {
                    char c;
                    block9: {
                        block6: {
                            String string4;
                            c = string2.charAt(i);
                            if (c >= '\u0080') break block6;
                            string3 = string4 = stringArray[c];
                            if (string4 != null) break block7;
                            n3 = n2;
                            break block8;
                        }
                        if (c != '\u2028') break block9;
                        string3 = "\\u2028";
                        break block7;
                    }
                    n3 = n2;
                    if (c != '\u2029') break block8;
                    string3 = "\\u2029";
                }
                if (n2 < i) {
                    this.out.write(string2, n2, i - n2);
                }
                this.out.write(string3);
                n3 = i + 1;
            }
            n2 = n3;
        }
        if (n2 < n) {
            this.out.write(string2, n2, n - n2);
        }
        this.out.write(34);
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int n = this.stackSize;
        if (n <= 1 && (n != 1 || this.stack[n - 1] == 7)) {
            this.stackSize = 0;
            return;
        }
        throw new IOException("Incomplete document");
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize != 0) {
            this.out.flush();
            return;
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public JsonWriter jsonValue(String string2) throws IOException {
        if (string2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(string2);
        return this;
    }

    public JsonWriter name(String string2) throws IOException {
        Objects.requireNonNull(string2, "name == null");
        if (this.deferredName == null) {
            if (this.stackSize != 0) {
                this.deferredName = string2;
                return this;
            }
            throw new IllegalStateException("JsonWriter is closed.");
        }
        throw new IllegalStateException();
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public final void setHtmlSafe(boolean bl) {
        this.htmlSafe = bl;
    }

    public final void setIndent(String string2) {
        if (string2.length() == 0) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = string2;
            this.separator = ": ";
        }
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final void setSerializeNulls(boolean bl) {
        this.serializeNulls = bl;
    }

    public JsonWriter value(double d) throws IOException {
        this.writeDeferredName();
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Numeric values must be finite, but was ");
            stringBuilder.append(d);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.beforeValue();
        this.out.append(Double.toString(d));
        return this;
    }

    public JsonWriter value(long l) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(l));
        return this;
    }

    public JsonWriter value(Boolean object) throws IOException {
        if (object == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        Writer writer = this.out;
        object = ((Boolean)object).booleanValue() ? "true" : "false";
        writer.write((String)object);
        return this;
    }

    public JsonWriter value(Number serializable) throws IOException {
        String string2;
        block8: {
            block7: {
                block6: {
                    if (serializable == null) {
                        return this.nullValue();
                    }
                    this.writeDeferredName();
                    string2 = serializable.toString();
                    if (string2.equals("-Infinity") || string2.equals("Infinity") || string2.equals("NaN")) break block6;
                    if (!JsonWriter.isTrustedNumberType((Class<? extends Number>)(serializable = serializable.getClass())) && !VALID_JSON_NUMBER_PATTERN.matcher(string2).matches()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("String created by ");
                        stringBuilder.append(serializable);
                        stringBuilder.append(" is not a valid JSON number: ");
                        stringBuilder.append(string2);
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    break block7;
                }
                if (!this.lenient) break block8;
            }
            this.beforeValue();
            this.out.append(string2);
            return this;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Numeric values must be finite, but was ");
        ((StringBuilder)serializable).append(string2);
        throw new IllegalArgumentException(((StringBuilder)serializable).toString());
    }

    public JsonWriter value(String string2) throws IOException {
        if (string2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(string2);
        return this;
    }

    public JsonWriter value(boolean bl) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        Writer writer = this.out;
        String string2 = bl ? "true" : "false";
        writer.write(string2);
        return this;
    }
}

