/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class GHRequest {
    private String algo = "";
    private final List<Double> favoredHeadings;
    private final HintsMap hints = new HintsMap();
    private Locale locale;
    private List<String> pathDetails;
    private List<String> pointHints = new ArrayList<String>();
    private final List<GHPoint> points;
    private boolean possibleToAdd = false;

    public GHRequest() {
        this(5);
    }

    public GHRequest(double d, double d2, double d3, double d4) {
        this(new GHPoint(d, d2), new GHPoint(d3, d4));
    }

    public GHRequest(double d, double d2, double d3, double d4, double d5, double d6) {
        this(new GHPoint(d, d2), new GHPoint(d3, d4), d5, d6);
    }

    public GHRequest(int n) {
        this.pathDetails = new ArrayList<String>();
        this.locale = Locale.US;
        this.points = new ArrayList<GHPoint>(n);
        this.favoredHeadings = new ArrayList<Double>(n);
        this.possibleToAdd = true;
    }

    public GHRequest(GHPoint gHPoint, GHPoint gHPoint2) {
        this(gHPoint, gHPoint2, Double.NaN, Double.NaN);
    }

    public GHRequest(GHPoint object, GHPoint gHPoint, double d, double d2) {
        this.pathDetails = new ArrayList<String>();
        this.locale = Locale.US;
        if (object != null) {
            if (gHPoint != null) {
                ArrayList<GHPoint> arrayList = new ArrayList<GHPoint>(2);
                this.points = arrayList;
                arrayList.add((GHPoint)object);
                arrayList.add(gHPoint);
                this.favoredHeadings = object = new ArrayList(2);
                this.validateAzimuthValue(d);
                object.add(d);
                this.validateAzimuthValue(d2);
                object.add(d2);
                return;
            }
            throw new IllegalStateException("'to' cannot be null");
        }
        throw new IllegalStateException("'from' cannot be null");
    }

    public GHRequest(List<GHPoint> list) {
        this(list, Collections.nCopies(list.size(), Double.NaN));
    }

    public GHRequest(List<GHPoint> list, List<Double> list2) {
        this.pathDetails = new ArrayList<String>();
        this.locale = Locale.US;
        if (list.size() == list2.size()) {
            Iterator<Double> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                this.validateAzimuthValue(iterator2.next());
            }
            this.points = list;
            this.favoredHeadings = list2;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Size of headings (");
        stringBuilder.append(list2.size());
        stringBuilder.append(") must match size of points (");
        stringBuilder.append(list.size());
        stringBuilder.append(")");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private void validateAzimuthValue(double d) {
        if (!(Double.isNaN(d) || Double.compare(d, 360.0) <= 0 && Double.compare(d, 0.0) >= 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Heading ");
            stringBuilder.append(d);
            stringBuilder.append(" must be in range (0,360) or NaN");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public GHRequest addPoint(GHPoint gHPoint) {
        this.addPoint(gHPoint, Double.NaN);
        return this;
    }

    public GHRequest addPoint(GHPoint gHPoint, double d) {
        if (gHPoint != null) {
            if (this.possibleToAdd) {
                this.points.add(gHPoint);
                this.validateAzimuthValue(d);
                this.favoredHeadings.add(d);
                return this;
            }
            throw new IllegalStateException("Please call empty constructor if you intent to use more than two places via addPoint method.");
        }
        throw new IllegalArgumentException("point cannot be null");
    }

    public String getAlgorithm() {
        return this.algo;
    }

    public double getFavoredHeading(int n) {
        return this.favoredHeadings.get(n);
    }

    public HintsMap getHints() {
        return this.hints;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<String> getPathDetails() {
        return this.pathDetails;
    }

    public List<String> getPointHints() {
        return this.pointHints;
    }

    public List<GHPoint> getPoints() {
        return this.points;
    }

    public String getVehicle() {
        return this.hints.getVehicle();
    }

    public String getWeighting() {
        return this.hints.getWeighting();
    }

    public boolean hasFavoredHeading(int n) {
        if (n >= this.favoredHeadings.size()) {
            return false;
        }
        return Double.isNaN(this.favoredHeadings.get(n)) ^ true;
    }

    public boolean hasPointHints() {
        boolean bl = this.pointHints.size() == this.points.size() && !this.points.isEmpty();
        return bl;
    }

    public GHRequest setAlgorithm(String string2) {
        if (string2 != null) {
            this.algo = Helper.camelCaseToUnderScore(string2);
        }
        return this;
    }

    public GHRequest setLocale(String string2) {
        return this.setLocale(Helper.getLocale(string2));
    }

    public GHRequest setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
        return this;
    }

    public GHRequest setPathDetails(List<String> list) {
        this.pathDetails = list;
        return this;
    }

    public GHRequest setPointHints(List<String> list) {
        this.pointHints = list;
        return this;
    }

    public GHRequest setVehicle(String string2) {
        this.hints.setVehicle(string2);
        return this;
    }

    public GHRequest setWeighting(String string2) {
        this.hints.setWeighting(string2);
        return this;
    }

    public String toString() {
        Object object = this.points.iterator();
        Object object2 = "";
        while (object.hasNext()) {
            GHPoint gHPoint = object.next();
            if (((String)object2).isEmpty()) {
                object2 = gHPoint.toString();
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object2);
            stringBuilder.append("; ");
            stringBuilder.append(gHPoint.toString());
            object2 = stringBuilder.toString();
        }
        object = object2;
        if (!this.algo.isEmpty()) {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(" (");
            ((StringBuilder)object).append(this.algo);
            ((StringBuilder)object).append(")");
            object = ((StringBuilder)object).toString();
        }
        object2 = object;
        if (!this.pathDetails.isEmpty()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" (PathDetails: ");
            ((StringBuilder)object2).append(this.pathDetails);
            ((StringBuilder)object2).append(")");
            object2 = ((StringBuilder)object2).toString();
        }
        object = object2;
        if (!this.hints.isEmpty()) {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(" (Hints:");
            ((StringBuilder)object).append(this.hints);
            ((StringBuilder)object).append(")");
            object = ((StringBuilder)object).toString();
        }
        return object;
    }
}

