/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.PathWrapper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GHResponse {
    private String debugInfo = "";
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private final PMap hintsMap = new PMap();
    private final List<PathWrapper> pathWrappers = new ArrayList<PathWrapper>(5);

    public void add(PathWrapper pathWrapper) {
        this.pathWrappers.add(pathWrapper);
    }

    public void addDebugInfo(String string2) {
        if (string2 != null) {
            StringBuilder stringBuilder;
            if (!this.debugInfo.isEmpty()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(this.debugInfo);
                stringBuilder.append("; ");
                this.debugInfo = stringBuilder.toString();
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(this.debugInfo);
            stringBuilder.append(string2);
            this.debugInfo = stringBuilder.toString();
            return;
        }
        throw new IllegalStateException("Debug information has to be none null");
    }

    public GHResponse addError(Throwable throwable) {
        this.errors.add(throwable);
        return this;
    }

    public GHResponse addErrors(List<Throwable> list) {
        this.errors.addAll(list);
        return this;
    }

    public List<PathWrapper> getAll() {
        return this.pathWrappers;
    }

    public PathWrapper getBest() {
        if (!this.pathWrappers.isEmpty()) {
            return this.pathWrappers.get(0);
        }
        throw new RuntimeException("Cannot fetch best response if list is empty");
    }

    public String getDebugInfo() {
        CharSequence charSequence = this.debugInfo;
        for (PathWrapper pathWrapper : this.pathWrappers) {
            CharSequence charSequence2 = charSequence;
            if (!((String)charSequence).isEmpty()) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append("; ");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append(pathWrapper.getDebugInfo());
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        arrayList.addAll(this.errors);
        Iterator<PathWrapper> iterator2 = this.pathWrappers.iterator();
        while (iterator2.hasNext()) {
            arrayList.addAll(iterator2.next().getErrors());
        }
        return arrayList;
    }

    public PMap getHints() {
        return this.hintsMap;
    }

    public boolean hasAlternatives() {
        int n = this.pathWrappers.size();
        boolean bl = true;
        if (n <= 1) {
            bl = false;
        }
        return bl;
    }

    public boolean hasErrors() {
        if (!this.errors.isEmpty()) {
            return true;
        }
        Iterator<PathWrapper> iterator2 = this.pathWrappers.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Object object = this.pathWrappers.iterator();
        String string2 = "";
        while (object.hasNext()) {
            PathWrapper pathWrapper = object.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("; ");
            stringBuilder.append(pathWrapper.toString());
            string2 = stringBuilder.toString();
        }
        if (this.pathWrappers.isEmpty()) {
            string2 = "no paths";
        }
        object = string2;
        if (!this.errors.isEmpty()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", main errors: ");
            ((StringBuilder)object).append(this.errors.toString());
            object = ((StringBuilder)object).toString();
        }
        return object;
    }
}

