/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.dem.BridgeElevationInterpolator;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.TunnelElevationInterpolator;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.CHAlgoFactoryDecorator;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.lm.LMAlgoFactoryDecorator;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.template.AlternativeRoutingTemplate;
import com.graphhopper.routing.template.RoundTripRoutingTemplate;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.GenericWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.Storable;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.storage.change.ChangeGraphHelper;
import com.graphhopper.storage.change.ChangeGraphResponse;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper
implements GraphHopperAPI {
    private final Set<RoutingAlgorithmFactoryDecorator> algoDecorators;
    private boolean allowWrites;
    private boolean calcPoints;
    private final CHAlgoFactoryDecorator chFactoryDecorator;
    private DAType dataAccessType;
    private String dataReaderFile;
    private double dataReaderWayPointMaxDistance;
    private int dataReaderWorkerThreads;
    private int defaultSegmentSize;
    private ElevationProvider eleProvider;
    private boolean elevation;
    boolean enableInstructions;
    private EncodingManager encodingManager;
    private final String fileLockName;
    private FlagEncoderFactory flagEncoderFactory;
    private boolean fullyLoaded;
    private String ghLocation;
    private GraphHopperStorage ghStorage;
    private final LMAlgoFactoryDecorator lmFactoryDecorator;
    private LocationIndex locationIndex;
    private LockFactory lockFactory;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxRegionSearch;
    private int maxRoundTripRetries;
    private int maxVisitedNodes;
    private int minNetworkSize;
    private int minOneWayNetworkSize;
    private int nonChMaxWaypointDistance;
    private PathDetailsBuilderFactory pathBuilderFactory;
    private int preciseIndexResolution;
    private String preferredLanguage;
    private final ReadWriteLock readWriteLock;
    boolean removeZipped;
    private boolean simplifyResponse;
    private boolean smoothElevation;
    private boolean sortGraph;
    private final TranslationMap trMap;
    private TraversalMode traversalMode;

    public GraphHopper() {
        CHAlgoFactoryDecorator cHAlgoFactoryDecorator;
        LMAlgoFactoryDecorator lMAlgoFactoryDecorator;
        this.fileLockName = "gh.lock";
        LinkedHashSet<RoutingAlgorithmFactoryDecorator> linkedHashSet = new LinkedHashSet<RoutingAlgorithmFactoryDecorator>();
        this.algoDecorators = linkedHashSet;
        this.trMap = new TranslationMap().doImport();
        this.removeZipped = true;
        this.enableInstructions = true;
        this.defaultSegmentSize = -1;
        this.ghLocation = "";
        this.dataAccessType = DAType.RAM_STORE;
        this.sortGraph = false;
        this.elevation = false;
        this.lockFactory = new NativeFSLockFactory();
        this.allowWrites = true;
        this.preferredLanguage = "";
        this.fullyLoaded = false;
        this.smoothElevation = false;
        this.maxRoundTripRetries = 3;
        this.simplifyResponse = true;
        this.traversalMode = TraversalMode.NODE_BASED;
        this.maxVisitedNodes = Integer.MAX_VALUE;
        this.nonChMaxWaypointDistance = Integer.MAX_VALUE;
        this.preciseIndexResolution = 300;
        this.maxRegionSearch = 4;
        this.minNetworkSize = 200;
        this.minOneWayNetworkSize = 0;
        this.lmFactoryDecorator = lMAlgoFactoryDecorator = new LMAlgoFactoryDecorator();
        this.chFactoryDecorator = cHAlgoFactoryDecorator = new CHAlgoFactoryDecorator();
        this.dataReaderWayPointMaxDistance = 1.0;
        this.dataReaderWorkerThreads = 2;
        this.calcPoints = true;
        this.eleProvider = ElevationProvider.NOOP;
        this.flagEncoderFactory = FlagEncoderFactory.DEFAULT;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.pathBuilderFactory = new PathDetailsBuilderFactory();
        cHAlgoFactoryDecorator.setEnabled(true);
        lMAlgoFactoryDecorator.setEnabled(false);
        linkedHashSet.add(cHAlgoFactoryDecorator);
        linkedHashSet.add(lMAlgoFactoryDecorator);
    }

    private void checkIfPointsAreInBounds(List<GHPoint> object) {
        BBox bBox = this.getGraphHopperStorage().getBounds();
        for (int i = 0; i < object.size(); ++i) {
            GHPoint gHPoint = object.get(i);
            if (bBox.contains(gHPoint.getLat(), gHPoint.getLon())) {
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Point ");
            ((StringBuilder)object).append(i);
            ((StringBuilder)object).append(" is out of bounds: ");
            ((StringBuilder)object).append(gHPoint);
            throw new PointOutOfBoundsException(((StringBuilder)object).toString(), i);
        }
    }

    private void checkNonChMaxWaypointDistance(List<GHPoint> object) {
        if (this.nonChMaxWaypointDistance == Integer.MAX_VALUE) {
            return;
        }
        Object object2 = object.get(0);
        DistanceCalc3D distanceCalc3D = Helper.DIST_3D;
        for (int i = 1; i < object.size(); ++i) {
            GHPoint gHPoint = object.get(i);
            if (!(distanceCalc3D.calcDist(((GHPoint)object2).getLat(), ((GHPoint)object2).getLon(), gHPoint.getLat(), gHPoint.getLon()) > (double)this.nonChMaxWaypointDistance)) {
                object2 = gHPoint;
                continue;
            }
            object2 = new HashMap(2);
            int n = i - 1;
            object2.put("from", n);
            object2.put("to", i);
            object = new StringBuilder();
            ((StringBuilder)object).append("Point ");
            ((StringBuilder)object).append(i);
            ((StringBuilder)object).append(" is too far from Point ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(": ");
            ((StringBuilder)object).append(gHPoint);
            throw new PointDistanceExceededException(((StringBuilder)object).toString(), (Map<String, Object>)object2);
        }
    }

    private void initCHAlgoFactoryDecorator() {
        if (!this.chFactoryDecorator.hasWeightings()) {
            for (FlagEncoder flagEncoder : this.encodingManager.fetchEdgeEncoders()) {
                Iterator<String> iterator2 = this.chFactoryDecorator.getWeightingsAsStrings().iterator();
                while (iterator2.hasNext()) {
                    Weighting weighting = this.createWeighting(new HintsMap(iterator2.next()), flagEncoder, null);
                    this.chFactoryDecorator.addWeighting(weighting);
                }
            }
        }
    }

    private void initLMAlgoFactoryDecorator() {
        if (this.lmFactoryDecorator.hasWeightings()) {
            return;
        }
        for (FlagEncoder flagEncoder : this.encodingManager.fetchEdgeEncoders()) {
            Iterator<String> iterator2 = this.lmFactoryDecorator.getWeightingsAsStrings().iterator();
            while (iterator2.hasNext()) {
                Weighting weighting = this.createWeighting(new HintsMap(iterator2.next()), flagEncoder, null);
                this.lmFactoryDecorator.addWeighting(weighting);
            }
        }
    }

    private void interpolateBridgesAndOrTunnels() {
        if (this.ghStorage.getEncodingManager().supports("generic")) {
            Object object = this.ghStorage.getEncodingManager().getEncoder("generic");
            if (object instanceof DataFlagEncoder) {
                Object object2 = (DataFlagEncoder)object;
                object = new StopWatch().start();
                new TunnelElevationInterpolator(this.ghStorage, (DataFlagEncoder)object2).execute();
                float f = ((StopWatch)object).stop().getSeconds();
                object = new StopWatch().start();
                new BridgeElevationInterpolator(this.ghStorage, (DataFlagEncoder)object2).execute();
                Logger logger = this.logger;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Bridge interpolation ");
                ((StringBuilder)object2).append((int)((StopWatch)object).stop().getSeconds());
                ((StringBuilder)object2).append("s, tunnel interpolation ");
                ((StringBuilder)object2).append((int)f);
                ((StringBuilder)object2).append("s");
                logger.info(((StringBuilder)object2).toString());
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("'generic' flag encoder for elevation interpolation of bridges and tunnels is enabled but does not have the expected type ");
                ((StringBuilder)object).append(DataFlagEncoder.class.getName());
                ((StringBuilder)object).append(".");
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
        }
    }

    private boolean isCHPrepared() {
        boolean bl = "true".equals(this.ghStorage.getProperties().get("prepare.ch.done")) || "true".equals(this.ghStorage.getProperties().get("prepare.done"));
        return bl;
    }

    private boolean isLMPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.lm.done"));
    }

    private void printInfo() {
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("version ");
        stringBuilder.append(Constants.VERSION);
        stringBuilder.append("|");
        stringBuilder.append(Constants.BUILD_DATE);
        stringBuilder.append(" (");
        stringBuilder.append(Constants.getVersions());
        stringBuilder.append(")");
        logger.info(stringBuilder.toString());
        if (this.ghStorage != null) {
            logger = this.logger;
            stringBuilder = new StringBuilder();
            stringBuilder.append("graph ");
            stringBuilder.append(this.ghStorage.toString());
            stringBuilder.append(", details:");
            stringBuilder.append(this.ghStorage.toDetailsString());
            logger.info(stringBuilder.toString());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private GraphHopper process(String object) {
        Object object2;
        this.setGraphHopperLocation((String)object);
        Object object5 = null;
        Object object4 = null;
        Object object3 = object5;
        if (this.ghStorage.getDirectory().getDefaultType().isStoring()) {
            object3 = object5;
            object2 = this.lockFactory;
            object3 = object5;
            object3 = object5;
            object4 = new File((String)object);
            object3 = object5;
            object2.setLockDir((File)object4);
            object3 = object5;
            object3 = object4 = this.lockFactory.create("gh.lock", true);
            if (!object4.tryLock()) {
                object3 = object4;
                object3 = object4;
                object3 = object4;
                object5 = new StringBuilder();
                object3 = object4;
                ((StringBuilder)object5).append("To avoid multiple writers we need to obtain a write lock but it failed. In ");
                object3 = object4;
                ((StringBuilder)object5).append((String)object);
                object3 = object4;
                object2 = new RuntimeException(((StringBuilder)object5).toString(), object4.getObtainFailedReason());
                object3 = object4;
                throw object2;
            }
        }
        object3 = object4;
        try {
            DataReader dataReader = this.importData();
            object3 = object4;
            object2 = Helper.createFormatter();
            object3 = object4;
            object5 = this.ghStorage.getProperties();
            object3 = object4;
            object3 = object4;
            object = new Date();
            object3 = object4;
            ((StorableProperties)object5).put("datareader.import.date", ((DateFormat)object2).format((Date)object));
            object3 = object4;
            if (dataReader.getDataDate() != null) {
                object3 = object4;
                this.ghStorage.getProperties().put("datareader.data.date", ((DateFormat)object2).format(dataReader.getDataDate()));
            }
            object3 = object4;
            this.cleanUp();
            object3 = object4;
            this.postProcessing();
            object3 = object4;
            this.flush();
            if (object4 != null) {
                object4.release();
            }
            return this;
        }
        catch (IOException iOException) {
            object3 = object4;
            try {
                object3 = object4;
                object3 = object4;
                object = new StringBuilder();
                object3 = object4;
                ((StringBuilder)object).append("Cannot read file ");
                object3 = object4;
                ((StringBuilder)object).append(this.getDataReaderFile());
                object3 = object4;
                object2 = new RuntimeException(((StringBuilder)object).toString(), iOException);
                object3 = object4;
                throw object2;
            }
            catch (Throwable throwable) {
                if (object3 != null) {
                    object3.release();
                }
                throw throwable;
            }
        }
    }

    private GraphHopper setSimplifyResponse(boolean bl) {
        this.simplifyResponse = bl;
        return this;
    }

    private GraphHopper setUnsafeMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.UNSAFE_STORE;
        return this;
    }

    public GraphHopper addAlgorithmFactoryDecorator(RoutingAlgorithmFactoryDecorator routingAlgorithmFactoryDecorator) {
        if (this.algoDecorators.add(routingAlgorithmFactoryDecorator)) {
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Decorator was already added ");
        stringBuilder.append(routingAlgorithmFactoryDecorator.getClass());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> calcPaths(GHRequest var1_1, GHResponse var2_5) {
        block22: {
            block21: {
                var3_6 /* !! */  = this.ghStorage;
                if (var3_6 /* !! */  == null || !this.fullyLoaded) break block22;
                if (var3_6 /* !! */ .isClosed()) {
                    throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
                }
                var4_7 = var3_6 /* !! */  = var1_1.getVehicle();
                if (var3_6 /* !! */ .isEmpty()) {
                    var4_7 = this.getDefaultVehicle().toString();
                    var1_1.setVehicle((String)var4_7);
                }
                var5_8 = this.readWriteLock.readLock();
                var5_8.lock();
                try {
                    if (this.encodingManager.supports((String)var4_7)) {
                        var6_9 = var1_1.getHints();
                        var7_10 = TraversalMode.fromString(var6_9.get("traversal_mode", this.traversalMode.toString()));
                        if (var6_9.has("edge_based")) {
                            var3_6 /* !! */  = var6_9.getBool("edge_based", false) != false ? TraversalMode.EDGE_BASED_2DIR : TraversalMode.NODE_BASED;
                            var7_10 = var3_6 /* !! */ ;
                        }
                        var8_11 = this.encodingManager.getEncoder((String)var4_7);
                        var9_12 = var6_9.getBool("ch.disable", false);
                        if (!this.chFactoryDecorator.isDisablingAllowed() && var9_12) {
                            var1_1 = new IllegalArgumentException("Disabling CH not allowed on the server-side");
                            throw var1_1;
                        }
                        var10_13 = var6_9.getBool("lm.disable", false);
                        if (!this.lmFactoryDecorator.isDisablingAllowed() && var10_13) {
                            var1_1 = new IllegalArgumentException("Disabling LM not allowed on the server-side");
                            throw var1_1;
                        }
                        var3_6 /* !! */  = var4_7 = var1_1.getAlgorithm();
                        if (var4_7.isEmpty()) {
                            var3_6 /* !! */  = this.chFactoryDecorator.isEnabled() != false && var9_12 == false ? "dijkstrabi" : "astarbi";
                        }
                        var11_14 = var1_1.getPoints();
                        this.checkIfPointsAreInBounds(var11_14);
                        var4_7 = "round_trip".equalsIgnoreCase((String)var3_6 /* !! */ ) != false ? new RoundTripRoutingTemplate((GHRequest)var1_1, var2_5, this.locationIndex, this.maxRoundTripRetries) : ("alternative_route".equalsIgnoreCase((String)var3_6 /* !! */ ) != false ? new AlternativeRoutingTemplate((GHRequest)var1_1, var2_5, this.locationIndex) : new ViaRoutingTemplate((GHRequest)var1_1, var2_5, this.locationIndex));
                        var12_15 = null;
                        var13_16 = var4_7.getMaxRetries();
                        var14_17 = var1_1.getLocale();
                        var15_18 = this.trMap.getWithFallBack((Locale)var14_17);
                    }
                }
                catch (IllegalArgumentException var1_3) {
                    var2_5.addError(var1_3);
                    var1_4 = Collections.emptyList();
                    var5_8.unlock();
                    return var1_4;
                }
                {
                    var1_1 = new StringBuilder();
                    var1_1.append("Vehicle not supported: ");
                    var1_1.append((String)var4_7);
                    var1_1.append(". Supported are: ");
                    var1_1.append(this.encodingManager.toString());
                    var3_6 /* !! */  = new IllegalArgumentException(var1_1.toString());
                    throw var3_6 /* !! */ ;
                }
                catch (Throwable var1_2) {
                    break block21;
                }
                for (var16_19 = 0; var16_19 < var13_16; ++var16_19) {
                    var12_15 = new List<Path>();
                    var14_17 = var12_15.start();
                    var17_20 = var4_7.lookup(var11_14, var8_11);
                    var12_15 = new List<Path>();
                    var12_15.append("idLookup:");
                    var12_15.append(var14_17.stop().getSeconds());
                    var12_15.append("s");
                    var2_5.addDebugInfo(var12_15.toString());
                    if (!var2_5.hasErrors()) ** GOTO lbl-1000
                    var1_1 = Collections.emptyList();
                    var5_8.unlock();
                    return var1_1;
lbl-1000:
                    // 1 sources

                    {
                        var18_21 = this.getAlgorithmFactory(var6_9);
                        if (this.chFactoryDecorator.isEnabled() && !var9_12) {
                            if (!var6_9.getBool("ch.force_heading", false) && var1_1.hasFavoredHeading(0)) {
                                var1_1 = new IllegalArgumentException("Heading is not (fully) supported for CHGraph. See issue #483");
                                throw var1_1;
                            }
                            var7_10 = var18_21 instanceof LMAlgoFactoryDecorator.LMRAFactory != false ? ((LMAlgoFactoryDecorator.LMRAFactory)var18_21).getDefaultAlgoFactory() : var18_21;
                            if (!(var7_10 instanceof PrepareContractionHierarchies)) {
                                var3_6 /* !! */  = new StringBuilder();
                                var3_6 /* !! */ .append("Although CH was enabled a non-CH algorithm factory was returned ");
                                var3_6 /* !! */ .append(var18_21);
                                var1_1 = new IllegalStateException(var3_6 /* !! */ .toString());
                                throw var1_1;
                            }
                            var14_17 = ((PrepareContractionHierarchies)var7_10).getWeighting();
                            var7_10 = this.getCHFactoryDecorator().getNodeBase();
                            var12_15 = new List<Path>((Graph)this.ghStorage.getGraph(CHGraph.class, (Weighting)var14_17));
                            var12_15.lookup((List<QueryResult>)var17_20);
                        } else {
                            this.checkNonChMaxWaypointDistance(var11_14);
                            var12_15 = new List<Path>((Graph)this.ghStorage);
                            var12_15.lookup((List<QueryResult>)var17_20);
                            var14_17 = this.createWeighting(var6_9, var8_11, (Graph)var12_15);
                            var17_20 = new StringBuilder();
                            var17_20.append("tmode:");
                            var17_20.append(var7_10.toString());
                            var2_5.addDebugInfo(var17_20.toString());
                        }
                        var19_22 = var6_9.getInt("max_visited_nodes", this.maxVisitedNodes);
                        if (var19_22 > this.maxVisitedNodes) ** GOTO lbl-1000
                        var14_17 = this.createTurnWeighting((Graph)var12_15, (Weighting)var14_17, (TraversalMode)var7_10);
                        var12_15 = var4_7.calcPaths((QueryGraph)var12_15, (RoutingAlgorithmFactory)var18_21, AlgorithmOptions.start().algorithm((String)var3_6 /* !! */ ).traversalMode((TraversalMode)var7_10).weighting((Weighting)var14_17).maxVisitedNodes(var19_22).hints(var6_9).build());
                        var10_13 = var6_9.getBool("instructions", this.enableInstructions);
                        var20_23 = var6_9.getBool("calc_points", this.calcPoints);
                        var21_24 = var6_9.getDouble("way_point_max_distance", 1.0);
                        var14_17 = new DouglasPeucker();
                        var14_17 = var14_17.setMaxDistance(var21_24);
                        var18_21 = new PathMerger();
                        var14_17 = var18_21.setCalcPoints(var20_23).setDouglasPeucker((DouglasPeucker)var14_17).setEnableInstructions(var10_13).setPathDetailsBuilders(this.pathBuilderFactory, var1_1.getPathDetails());
                    }
                    var10_13 = this.simplifyResponse != false && var21_24 > 0.0;
                    {
                        var14_17 = var14_17.setSimplifyResponse(var10_13);
                        if (var1_1.hasFavoredHeading(0)) {
                            var14_17.setFavoredHeading(var1_1.getFavoredHeading(0));
                        }
                        if (var4_7.isReady((PathMerger)var14_17, var15_18)) break;
                        continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var1_1 = new StringBuilder();
                        var1_1.append("The max_visited_nodes parameter has to be below or equal to:");
                        var1_1.append(this.maxVisitedNodes);
                        var3_6 /* !! */  = new IllegalArgumentException(var1_1.toString());
                        throw var3_6 /* !! */ ;
                    }
                }
                var5_8.unlock();
                return var12_15;
            }
            var5_8.unlock();
            throw var1_2;
        }
        throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
    }

    public ChangeGraphResponse changeGraph(Collection<JsonFeature> object) {
        if (!this.getCHFactoryDecorator().isEnabled()) {
            Lock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                object = new ChangeGraphResponse(this.createChangeGraphHelper(this.ghStorage, this.locationIndex).applyChanges(this.encodingManager, (Collection<JsonFeature>)object));
                return object;
            }
            finally {
                lock.unlock();
            }
        }
        throw new IllegalArgumentException("To use the changeGraph API you need to turn off CH");
    }

    public void clean() {
        if (!this.getGraphHopperLocation().isEmpty()) {
            Helper.removeDir(new File(this.getGraphHopperLocation()));
            return;
        }
        throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
    }

    protected void cleanUp() {
        int n = this.ghStorage.getNodes();
        PrepareRoutingSubnetworks prepareRoutingSubnetworks = new PrepareRoutingSubnetworks(this.ghStorage, this.encodingManager.fetchEdgeEncoders());
        prepareRoutingSubnetworks.setMinNetworkSize(this.minNetworkSize);
        prepareRoutingSubnetworks.setMinOneWayNetworkSize(this.minOneWayNetworkSize);
        prepareRoutingSubnetworks.doWork();
        int n2 = this.ghStorage.getNodes();
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edges: ");
        stringBuilder.append(Helper.nf(this.ghStorage.getAllEdges().length()));
        stringBuilder.append(", nodes ");
        stringBuilder.append(Helper.nf(n2));
        stringBuilder.append(", there were ");
        stringBuilder.append(Helper.nf(prepareRoutingSubnetworks.getMaxSubnetworks()));
        stringBuilder.append(" subnetworks. removed them => ");
        stringBuilder.append(Helper.nf(n - n2));
        stringBuilder.append(" less nodes");
        logger.info(stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        Storable<GraphStorage> storable = this.ghStorage;
        if (storable != null) {
            ((GraphHopperStorage)storable).close();
        }
        if ((storable = this.locationIndex) != null) {
            storable.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected ChangeGraphHelper createChangeGraphHelper(Graph graph, LocationIndex locationIndex) {
        return new ChangeGraphHelper(graph, locationIndex);
    }

    protected LocationIndex createLocationIndex(Directory object) {
        object = new LocationIndexTree(this.ghStorage, (Directory)object);
        ((LocationIndexTree)object).setResolution(this.preciseIndexResolution);
        ((LocationIndexTree)object).setMaxRegionSearch(this.maxRegionSearch);
        if (!((LocationIndexTree)object).loadExisting()) {
            this.ensureWriteAccess();
            ((LocationIndexTree)object).prepareIndex();
        }
        return object;
    }

    protected DataReader createReader(GraphHopperStorage graphHopperStorage) {
        throw new UnsupportedOperationException("Cannot create DataReader. Solutions: avoid import via calling load directly, provide a DataReader or use e.g. GraphHopperOSM or a different subclass");
    }

    public Weighting createTurnWeighting(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        if (weighting.getFlagEncoder().supports(TurnWeighting.class) && !traversalMode.equals((Object)TraversalMode.NODE_BASED)) {
            return new TurnWeighting(weighting, (TurnCostExtension)graph.getExtension());
        }
        return weighting;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Weighting createWeighting(HintsMap var1_1, FlagEncoder var2_2, Graph var3_3) {
        block5: {
            block7: {
                block8: {
                    block6: {
                        block4: {
                            var4_4 = Helper.toLowerCase(var1_1.getWeighting());
                            if (!var2_2.supports(GenericWeighting.class)) break block4;
                            var5_5 /* !! */  = new GenericWeighting((DataFlagEncoder)var2_2, (PMap)var1_1);
                            break block5;
                        }
                        if (!"shortest".equalsIgnoreCase(var4_4)) break block6;
                        var5_5 /* !! */  = new ShortestWeighting(var2_2);
                        break block5;
                    }
                    if ("fastest".equalsIgnoreCase(var4_4) || var4_4.isEmpty()) break block7;
                    if (!"curvature".equalsIgnoreCase(var4_4)) break block8;
                    if (!var2_2.supports(CurvatureWeighting.class)) ** GOTO lbl-1000
                    var5_5 /* !! */  = new CurvatureWeighting(var2_2, (PMap)var1_1);
                    break block5;
                }
                if ("short_fastest".equalsIgnoreCase(var4_4)) {
                    var5_5 /* !! */  = new ShortFastestWeighting(var2_2, (PMap)var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    var5_5 /* !! */  = null;
                }
                break block5;
            }
            var5_5 /* !! */  = var2_2.supports(PriorityWeighting.class) != false ? new PriorityWeighting(var2_2, (PMap)var1_1) : new FastestWeighting(var2_2, (PMap)var1_1);
        }
        if (var5_5 /* !! */  != null) {
            if (var1_1.has("block_area")) {
                var4_4 = var1_1.get("block_area", "");
                return new BlockAreaWeighting(var5_5 /* !! */ , new GraphEdgeIdFinder(var3_3, this.locationIndex).parseBlockArea(var4_4, DefaultEdgeFilter.allEdges(var2_2), var1_1.getDouble("block_area.edge_id_max_area", 1000000.0)));
            }
            return var5_5 /* !! */ ;
        }
        var1_1 = new StringBuilder();
        var1_1.append("weighting ");
        var1_1.append(var4_4);
        var1_1.append(" not supported");
        throw new IllegalArgumentException(var1_1.toString());
    }

    protected void ensureNotLoaded() {
        if (!this.fullyLoaded) {
            return;
        }
        throw new IllegalStateException("No configuration changes are possible after loading the graph");
    }

    protected void ensureWriteAccess() {
        if (this.allowWrites) {
            return;
        }
        throw new IllegalStateException("Writes are not allowed!");
    }

    protected void flush() {
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("flushing graph ");
        stringBuilder.append(this.ghStorage.toString());
        stringBuilder.append(", details:");
        stringBuilder.append(this.ghStorage.toDetailsString());
        stringBuilder.append(", ");
        stringBuilder.append(Helper.getMemInfo());
        stringBuilder.append(")");
        logger.info(stringBuilder.toString());
        this.ghStorage.flush();
        logger = this.logger;
        stringBuilder = new StringBuilder();
        stringBuilder.append("flushed graph ");
        stringBuilder.append(Helper.getMemInfo());
        stringBuilder.append(")");
        logger.info(stringBuilder.toString());
        this.fullyLoaded = true;
    }

    public GraphHopper forDesktop() {
        this.setSimplifyResponse(false);
        return this.setInMemory();
    }

    public GraphHopper forMobile() {
        this.setSimplifyResponse(false);
        return this.setMemoryMapped();
    }

    public GraphHopper forServer() {
        this.setSimplifyResponse(true);
        return this.setInMemory();
    }

    public RoutingAlgorithmFactory getAlgorithmFactory(HintsMap hintsMap) {
        RoutingAlgorithmFactory routingAlgorithmFactory = new RoutingAlgorithmFactorySimple();
        for (RoutingAlgorithmFactoryDecorator routingAlgorithmFactoryDecorator : this.algoDecorators) {
            if (!routingAlgorithmFactoryDecorator.isEnabled()) continue;
            routingAlgorithmFactory = routingAlgorithmFactoryDecorator.getDecoratedAlgorithmFactory(routingAlgorithmFactory, hintsMap);
        }
        return routingAlgorithmFactory;
    }

    public final CHAlgoFactoryDecorator getCHFactoryDecorator() {
        return this.chFactoryDecorator;
    }

    public String getDataReaderFile() {
        return this.dataReaderFile;
    }

    FlagEncoder getDefaultVehicle() {
        EncodingManager encodingManager = this.encodingManager;
        if (encodingManager != null) {
            return encodingManager.fetchEdgeEncoders().get(0);
        }
        throw new IllegalStateException("No encoding manager specified or loaded");
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public FlagEncoderFactory getFlagEncoderFactory() {
        return this.flagEncoderFactory;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopperStorage getGraphHopperStorage() {
        GraphHopperStorage graphHopperStorage = this.ghStorage;
        if (graphHopperStorage != null) {
            return graphHopperStorage;
        }
        throw new IllegalStateException("GraphHopper storage not initialized");
    }

    public final LMAlgoFactoryDecorator getLMFactoryDecorator() {
        return this.lmFactoryDecorator;
    }

    public LocationIndex getLocationIndex() {
        LocationIndex locationIndex = this.locationIndex;
        if (locationIndex != null) {
            return locationIndex;
        }
        throw new IllegalStateException("Location index not initialized");
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    protected double getWayPointMaxDistance() {
        return this.dataReaderWayPointMaxDistance;
    }

    protected int getWorkerThreads() {
        return this.dataReaderWorkerThreads;
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    protected DataReader importData() throws IOException {
        this.ensureWriteAccess();
        if (this.ghStorage != null) {
            if (this.dataReaderFile != null) {
                this.encodingManager.setEnableInstructions(this.enableInstructions);
                this.encodingManager.setPreferredLanguage(this.preferredLanguage);
                DataReader dataReader = this.createReader(this.ghStorage);
                Logger logger = this.logger;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("using ");
                stringBuilder.append(this.ghStorage.toString());
                stringBuilder.append(", memory:");
                stringBuilder.append(Helper.getMemInfo());
                logger.info(stringBuilder.toString());
                dataReader.readGraph();
                return dataReader;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't load from existing folder: ");
            stringBuilder.append(this.ghLocation);
            stringBuilder.append(" but also cannot use file for DataReader as it wasn't specified!");
            throw new IllegalStateException(stringBuilder.toString());
        }
        throw new IllegalStateException("Load graph before importing OSM data");
    }

    public GraphHopper importOrLoad() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation);
        } else {
            this.printInfo();
        }
        return this;
    }

    public GraphHopper init(CmdArgs cmdArgs) {
        cmdArgs.merge(CmdArgs.readFromSystemProperties());
        if (!cmdArgs.has("osmreader.osm")) {
            String string2;
            Object object = cmdArgs.get("datareader.file", "");
            if (!Helper.isEmpty((String)object)) {
                this.dataReaderFile = object;
            }
            CharSequence charSequence = cmdArgs.get("graph.location", "");
            object = charSequence;
            if (Helper.isEmpty(charSequence)) {
                object = charSequence;
                if (Helper.isEmpty(this.ghLocation)) {
                    if (!Helper.isEmpty(this.dataReaderFile)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(Helper.pruneFileEnd(this.dataReaderFile));
                        ((StringBuilder)object).append("-gh");
                        object = ((StringBuilder)object).toString();
                    } else {
                        throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
                    }
                }
            }
            this.setGraphHopperLocation((String)object);
            this.defaultSegmentSize = cmdArgs.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
            this.dataAccessType = DAType.fromString(cmdArgs.get("graph.dataaccess", "RAM_STORE"));
            this.sortGraph = cmdArgs.getBool("graph.do_sort", this.sortGraph);
            this.removeZipped = cmdArgs.getBool("graph.remove_zipped", this.removeZipped);
            int n = cmdArgs.getInt("graph.bytes_for_flags", 4);
            object = cmdArgs.get("graph.flag_encoders", "");
            if (!((String)object).isEmpty()) {
                this.setEncodingManager(new EncodingManager(this.flagEncoderFactory, (String)object, n));
            }
            this.lockFactory = cmdArgs.get("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
            String string3 = Helper.toLowerCase(cmdArgs.get("graph.elevation.provider", "noop"));
            this.smoothElevation = cmdArgs.getBool("graph.elevation.smoothing", false);
            boolean bl = cmdArgs.has("graph.elevation.calcmean") ? cmdArgs.getBool("graph.elevation.calcmean", false) : cmdArgs.getBool("graph.elevation.calc_mean", false);
            object = cmdArgs.get("graph.elevation.cache_dir", "");
            charSequence = object;
            if (((String)object).isEmpty()) {
                charSequence = cmdArgs.get("graph.elevation.cachedir", "");
            }
            if ((string2 = cmdArgs.get("graph.elevation.base_url", "")).isEmpty()) {
                cmdArgs.get("graph.elevation.baseurl", "");
            }
            boolean bl2 = cmdArgs.getBool("graph.elevation.clear", cmdArgs.getBool("graph.elevation.cgiar.clear", true));
            DAType dAType = DAType.fromString(cmdArgs.get("graph.elevation.dataaccess", "MMAP"));
            object = ElevationProvider.NOOP;
            if (string3.equalsIgnoreCase("srtm")) {
                object = new SRTMProvider((String)charSequence);
            } else if (string3.equalsIgnoreCase("cgiar")) {
                object = new CGIARProvider((String)charSequence);
            } else if (string3.equalsIgnoreCase("gmted")) {
                object = new GMTEDProvider((String)charSequence);
            } else if (string3.equalsIgnoreCase("srtmgl1")) {
                object = new SRTMGL1Provider((String)charSequence);
            } else if (string3.equalsIgnoreCase("multi")) {
                object = new MultiSourceElevationProvider((String)charSequence);
            }
            object.setAutoRemoveTemporaryFiles(bl2);
            object.setCalcMean(bl);
            if (!string2.isEmpty()) {
                object.setBaseURL(string2);
            }
            object.setDAType(dAType);
            this.setElevationProvider((ElevationProvider)object);
            this.minNetworkSize = cmdArgs.getInt("prepare.min_network_size", this.minNetworkSize);
            this.minOneWayNetworkSize = cmdArgs.getInt("prepare.min_one_way_network_size", this.minOneWayNetworkSize);
            object = this.algoDecorators.iterator();
            while (object.hasNext()) {
                object.next().init(cmdArgs);
            }
            this.dataReaderWayPointMaxDistance = cmdArgs.getDouble("routing.way_point_max_distance", this.dataReaderWayPointMaxDistance);
            this.dataReaderWorkerThreads = cmdArgs.getInt("datareader.worker_threads", this.dataReaderWorkerThreads);
            this.enableInstructions = cmdArgs.getBool("datareader.instructions", this.enableInstructions);
            this.preferredLanguage = cmdArgs.get("datareader.preferred_language", this.preferredLanguage);
            this.preciseIndexResolution = cmdArgs.getInt("index.high_resolution", this.preciseIndexResolution);
            this.maxRegionSearch = cmdArgs.getInt("index.max_region_search", this.maxRegionSearch);
            this.maxVisitedNodes = cmdArgs.getInt("routing.max_visited_nodes", Integer.MAX_VALUE);
            this.maxRoundTripRetries = cmdArgs.getInt("routing.round_trip.max_retries", this.maxRoundTripRetries);
            this.nonChMaxWaypointDistance = cmdArgs.getInt("routing.non_ch.max_waypoint_distance", Integer.MAX_VALUE);
            return this;
        }
        throw new IllegalArgumentException("Instead osmreader.osm use datareader.file, for other changes see core/files/changelog.txt");
    }

    protected DataReader initDataReader(DataReader dataReader) {
        if (this.dataReaderFile != null) {
            Logger logger = this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("start creating graph from ");
            stringBuilder.append(this.dataReaderFile);
            logger.info(stringBuilder.toString());
            return dataReader.setFile(new File(this.dataReaderFile)).setElevationProvider(this.eleProvider).setWorkerThreads(this.dataReaderWorkerThreads).setWayPointMaxDistance(this.dataReaderWayPointMaxDistance).setSmoothElevation(this.smoothElevation);
        }
        throw new IllegalArgumentException("No file for DataReader specified");
    }

    protected void initLocationIndex() {
        if (this.locationIndex == null) {
            this.locationIndex = this.createLocationIndex(this.ghStorage.getDirectory());
            return;
        }
        throw new IllegalStateException("Cannot initialize locationIndex twice!");
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public final boolean isCHEnabled() {
        return this.chFactoryDecorator.isEnabled();
    }

    public boolean isEnableInstructions() {
        return this.enableInstructions;
    }

    @Override
    public boolean load(String object) {
        if (!Helper.isEmpty((String)object)) {
            if (!this.fullyLoaded) {
                Object object2;
                block35: {
                    Object object3;
                    Object object4;
                    object2 = new File((String)object);
                    if (!((File)object2).isDirectory() && ((File)object2).exists()) {
                        throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append(".ghz");
                    object2 = new File(((StringBuilder)object2).toString());
                    if (((File)object2).exists() && !((File)object2).isDirectory()) {
                        try {
                            object4 = new Unzipper();
                            ((Unzipper)object4).unzip(((File)object2).getAbsolutePath(), (String)object, this.removeZipped);
                        }
                        catch (IOException iOException) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Couldn't extract file ");
                            stringBuilder.append(((File)object2).getAbsolutePath());
                            stringBuilder.append(" to ");
                            stringBuilder.append((String)object);
                            throw new RuntimeException(stringBuilder.toString(), iOException);
                        }
                    }
                    this.setGraphHopperLocation((String)object);
                    if (this.encodingManager == null) {
                        this.setEncodingManager(EncodingManager.create(this.flagEncoderFactory, this.ghLocation));
                    }
                    if (!this.allowWrites && this.dataAccessType.isMMap()) {
                        this.dataAccessType = DAType.MMAP_RO;
                    }
                    object4 = new GHDirectory(this.ghLocation, this.dataAccessType);
                    object2 = this.encodingManager.needsTurnCostsSupport() ? new TurnCostExtension() : new GraphExtension.NoOpExtension();
                    if (this.lmFactoryDecorator.isEnabled()) {
                        this.initLMAlgoFactoryDecorator();
                    }
                    if (this.chFactoryDecorator.isEnabled()) {
                        this.initCHAlgoFactoryDecorator();
                        this.ghStorage = new GraphHopperStorage(this.chFactoryDecorator.getWeightings(), (Directory)object4, this.encodingManager, this.hasElevation(), (GraphExtension)object2);
                    } else {
                        this.ghStorage = new GraphHopperStorage((Directory)object4, this.encodingManager, this.hasElevation(), (GraphExtension)object2);
                    }
                    this.ghStorage.setSegmentSize(this.defaultSegmentSize);
                    if (!new File((String)object).exists()) {
                        return false;
                    }
                    object4 = null;
                    object2 = object3 = null;
                    object = object4;
                    try {
                        if (!this.ghStorage.getDirectory().getDefaultType().isStoring()) break block35;
                        object2 = object3;
                        object = object4;
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            object.release();
                        }
                        throw throwable;
                    }
                    if (!this.isAllowWrites()) break block35;
                    object = object4;
                    object3 = this.lockFactory;
                    object = object4;
                    object = object4;
                    object2 = new File(this.ghLocation);
                    object = object4;
                    object3.setLockDir((File)object2);
                    object = object4;
                    object = object2 = this.lockFactory.create("gh.lock", false);
                    if (object2.tryLock()) break block35;
                    object = object2;
                    object = object2;
                    object = object2;
                    object4 = new StringBuilder();
                    object = object2;
                    ((StringBuilder)object4).append("To avoid reading partial data we need to obtain the read lock but it failed. In ");
                    object = object2;
                    ((StringBuilder)object4).append(this.ghLocation);
                    object = object2;
                    object3 = new RuntimeException(((StringBuilder)object4).toString(), object2.getObtainFailedReason());
                    object = object2;
                    throw object3;
                }
                object = object2;
                boolean bl = this.ghStorage.loadExisting();
                if (!bl) {
                    if (object2 != null) {
                        object2.release();
                    }
                    return false;
                }
                object = object2;
                this.postProcessing();
                object = object2;
                this.fullyLoaded = true;
                if (object2 != null) {
                    object2.release();
                }
                return true;
            }
            throw new IllegalStateException("graph is already successfully loaded");
        }
        throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
    }

    protected GraphHopper loadGraph(GraphHopperStorage graphHopperStorage) {
        this.ghStorage = graphHopperStorage;
        this.fullyLoaded = true;
        this.initLocationIndex();
        return this;
    }

    protected void loadOrPrepareLM() {
        boolean bl = this.lmFactoryDecorator.isEnabled() && !this.lmFactoryDecorator.getPreparations().isEmpty();
        if (bl) {
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            if (this.lmFactoryDecorator.loadOrDoWork(this.ghStorage.getProperties())) {
                this.ghStorage.getProperties().put("prepare.lm.done", true);
            }
        }
    }

    public void postProcessing() {
        if (this.sortGraph) {
            if (this.ghStorage.isCHPossible() && this.isCHPrepared()) {
                throw new IllegalArgumentException("Sorting a prepared CHGraph is not possible yet. See #12");
            }
            GraphHopperStorage graphHopperStorage = GHUtility.newStorage(this.ghStorage);
            GHUtility.sortDFS(this.ghStorage, graphHopperStorage);
            Logger logger = this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("graph sorted (");
            stringBuilder.append(Helper.getMemInfo());
            stringBuilder.append(")");
            logger.info(stringBuilder.toString());
            this.ghStorage = graphHopperStorage;
        }
        if (this.hasElevation()) {
            this.interpolateBridgesAndOrTunnels();
        }
        this.initLocationIndex();
        if (this.chFactoryDecorator.isEnabled()) {
            this.chFactoryDecorator.createPreparations(this.ghStorage, this.traversalMode);
        }
        if (!this.isCHPrepared()) {
            this.prepareCH();
        }
        if (this.lmFactoryDecorator.isEnabled()) {
            this.lmFactoryDecorator.createPreparations(this.ghStorage, this.locationIndex);
        }
        this.loadOrPrepareLM();
    }

    protected void prepareCH() {
        if (this.chFactoryDecorator.isEnabled()) {
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            this.chFactoryDecorator.prepare(this.ghStorage.getProperties());
            this.ghStorage.getProperties().put("prepare.ch.done", true);
        }
    }

    @Override
    public GHResponse route(GHRequest gHRequest) {
        GHResponse gHResponse = new GHResponse();
        this.calcPaths(gHRequest, gHResponse);
        return gHResponse;
    }

    public GraphHopper setAllowWrites(boolean bl) {
        this.allowWrites = bl;
        return this;
    }

    public GraphHopper setCHEnable(boolean bl) {
        return this.setCHEnabled(bl);
    }

    public GraphHopper setCHEnabled(boolean bl) {
        this.ensureNotLoaded();
        this.chFactoryDecorator.setEnabled(bl);
        return this;
    }

    public GraphHopper setDataReaderFile(String string2) {
        this.ensureNotLoaded();
        if (!Helper.isEmpty(string2)) {
            this.dataReaderFile = string2;
            return this;
        }
        throw new IllegalArgumentException("Data reader file cannot be empty.");
    }

    public GraphHopper setElevation(boolean bl) {
        this.elevation = bl;
        return this;
    }

    public GraphHopper setElevationProvider(ElevationProvider elevationProvider) {
        if (elevationProvider != null && elevationProvider != ElevationProvider.NOOP) {
            this.setElevation(true);
        } else {
            this.setElevation(false);
        }
        this.eleProvider = elevationProvider;
        return this;
    }

    public GraphHopper setEnableCalcPoints(boolean bl) {
        this.calcPoints = bl;
        return this;
    }

    public GraphHopper setEnableInstructions(boolean bl) {
        this.ensureNotLoaded();
        this.enableInstructions = bl;
        return this;
    }

    public GraphHopper setEncodingManager(EncodingManager encodingManager) {
        this.ensureNotLoaded();
        this.encodingManager = encodingManager;
        if (encodingManager.needsTurnCostsSupport()) {
            this.traversalMode = TraversalMode.EDGE_BASED_2DIR;
        }
        return this;
    }

    public GraphHopper setFlagEncoderFactory(FlagEncoderFactory flagEncoderFactory) {
        this.flagEncoderFactory = flagEncoderFactory;
        return this;
    }

    public GraphHopper setGraphHopperLocation(String string2) {
        this.ensureNotLoaded();
        if (string2 != null) {
            this.ghLocation = string2;
            return this;
        }
        throw new IllegalArgumentException("graphhopper location cannot be null");
    }

    public void setGraphHopperStorage(GraphHopperStorage graphHopperStorage) {
        this.ghStorage = graphHopperStorage;
        this.fullyLoaded = true;
    }

    public GraphHopper setInMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.RAM_STORE;
        return this;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public void setMaxVisitedNodes(int n) {
        this.maxVisitedNodes = n;
    }

    public GraphHopper setMemoryMapped() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.MMAP;
        return this;
    }

    public GraphHopper setMinNetworkSize(int n, int n2) {
        this.minNetworkSize = n;
        this.minOneWayNetworkSize = n2;
        return this;
    }

    public void setNonChMaxWaypointDistance(int n) {
        this.nonChMaxWaypointDistance = n;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.pathBuilderFactory = pathDetailsBuilderFactory;
        return this;
    }

    public GraphHopper setPreciseIndexResolution(int n) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = n;
        return this;
    }

    public GraphHopper setPreferredLanguage(String string2) {
        this.ensureNotLoaded();
        if (string2 != null) {
            this.preferredLanguage = string2;
            return this;
        }
        throw new IllegalArgumentException("preferred language cannot be null");
    }

    public GraphHopper setSortGraph(boolean bl) {
        this.ensureNotLoaded();
        this.sortGraph = bl;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean bl) {
        this.ensureNotLoaded();
        this.dataAccessType = bl ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setTraversalMode(TraversalMode traversalMode) {
        this.traversalMode = traversalMode;
        return this;
    }

    public GraphHopper setWayPointMaxDistance(double d) {
        this.dataReaderWayPointMaxDistance = d;
        return this;
    }
}

