/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.collections;

import com.graphhopper.coll.BinHeapWrapper;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class IntDoubleBinaryHeap
implements BinHeapWrapper<Number, Integer> {
    private static final int GROW_FACTOR = 2;
    private int[] elements;
    private float[] keys;
    private int size;

    public IntDoubleBinaryHeap() {
        this(1000);
    }

    public IntDoubleBinaryHeap(int n) {
        this.elements = new int[++n];
        float[] fArray = new float[n];
        this.keys = fArray;
        fArray[0] = Float.NEGATIVE_INFINITY;
    }

    private boolean isFull() {
        int n = this.elements.length;
        int n2 = this.size;
        boolean bl = true;
        if (n != n2 + 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.trimTo(0);
    }

    @Override
    public void ensureCapacity(int n) {
        if (n >= this.size) {
            int[] nArray = this.elements;
            this.elements = Arrays.copyOf(nArray, ++n);
            this.keys = Arrays.copyOf(this.keys, n);
            return;
        }
        throw new IllegalStateException("IntDoubleBinaryHeap contains too many elements to fit in new capacity.");
    }

    public long getCapacity() {
        return this.elements.length;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void insert(Number number, Integer n) {
        this.insert_(number.doubleValue(), n);
    }

    public void insert_(double d, int n) {
        int n2;
        if (this.isFull()) {
            this.ensureCapacity(this.elements.length * 2);
        }
        this.size = n2 = this.size + 1;
        this.elements[n2] = n;
        this.keys[n2] = (float)d;
        this.percolateUpMinHeap(n2);
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Integer peekElement() {
        return this.peek_element();
    }

    @Override
    public Number peekKey() {
        return Float.valueOf(this.peek_key());
    }

    public int peek_element() {
        if (!this.isEmpty()) {
            return this.elements[1];
        }
        throw new NoSuchElementException("Heap is empty. Cannot peek element.");
    }

    public float peek_key() {
        if (!this.isEmpty()) {
            return this.keys[1];
        }
        throw new NoSuchElementException("Heap is empty. Cannot peek key.");
    }

    final void percolateDownMinHeap(int n) {
        int n2;
        int n3;
        int n4 = this.elements[n];
        float f = this.keys[n];
        int n5 = n;
        while ((n3 = n5 * 2) <= (n2 = this.size)) {
            float[] fArray;
            n = n3;
            if (n3 != n2) {
                fArray = this.keys;
                n2 = n3 + 1;
                n = n3;
                if (fArray[n2] < fArray[n3]) {
                    n = n2;
                }
            }
            if ((fArray = this.keys)[n] >= f) break;
            int[] nArray = this.elements;
            nArray[n5] = nArray[n];
            fArray[n5] = fArray[n];
            n5 = n;
        }
        this.elements[n5] = n4;
        this.keys[n5] = f;
    }

    final void percolateUpMinHeap(int n) {
        int n2;
        float[] fArray;
        int n3 = this.elements[n];
        float f = this.keys[n];
        while (f < (fArray = this.keys)[n2 = n / 2]) {
            int[] nArray = this.elements;
            nArray[n] = nArray[n2];
            fArray[n] = fArray[n2];
            n = n2;
        }
        this.elements[n] = n3;
        fArray[n] = f;
    }

    @Override
    public Integer pollElement() {
        return this.poll_element();
    }

    public int poll_element() {
        int n = this.peek_element();
        Object[] objectArray = this.elements;
        int n2 = this.size;
        objectArray[1] = objectArray[n2];
        objectArray = this.keys;
        objectArray[1] = objectArray[n2];
        this.size = --n2;
        if (n2 != 0) {
            this.percolateDownMinHeap(1);
        }
        return n;
    }

    void trimTo(int n) {
        this.size = n;
        Arrays.fill(this.elements, n + 1, n + 1, 0);
    }

    @Override
    public void update(Number number, Integer n) {
        this.update_(number.doubleValue(), n);
    }

    public void update_(double d, int n) {
        int n2;
        int n3;
        for (n3 = 1; n3 <= (n2 = this.size) && this.elements[n3] != n; ++n3) {
        }
        if (n3 > n2) {
            return;
        }
        float[] fArray = this.keys;
        if (d > (double)fArray[n3]) {
            fArray[n3] = (float)d;
            this.percolateDownMinHeap(n3);
        } else {
            fArray[n3] = (float)d;
            this.percolateUpMinHeap(n3);
        }
    }
}

