/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.LongIntMap;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHLongIntBTree
implements LongIntMap {
    private float factor;
    private int height;
    private int initLeafSize;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxLeafEntries;
    private final int noNumberValue;
    private BTreeEntry root;
    private long size;
    private int splitIndex;

    public GHLongIntBTree(int n) {
        this.noNumberValue = -1;
        this.maxLeafEntries = n;
        if (n >= 1) {
            int n2 = n;
            if (n % 2 == 0) {
                n2 = n + 1;
            }
            this.splitIndex = n2 / 2;
            if (n2 < 10) {
                this.factor = 2.0f;
                this.initLeafSize = 1;
            } else if (n2 < 20) {
                this.factor = 2.0f;
                this.initLeafSize = 4;
            } else {
                this.factor = 1.7f;
                this.initLeafSize = n2 / 10;
            }
            this.clear();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("illegal maxLeafEntries:");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    static int binarySearch(long[] lArray, int n, int n2, long l) {
        int n3 = n2 + n;
        --n;
        n2 = n3;
        while (n2 - n > 1) {
            int n4 = n2 + n >>> 1;
            if (lArray[n4] < l) {
                n = n4;
                continue;
            }
            n2 = n4;
        }
        if (n2 == n3) {
            return n3;
        }
        if (lArray[n2] == l) {
            return n2;
        }
        return n2;
    }

    private int getEntries() {
        return this.root.getEntries();
    }

    void clear() {
        this.size = 0L;
        this.height = 1;
        this.root = new BTreeEntry(this.initLeafSize, true);
    }

    void flush() {
        throw new IllegalStateException("not supported yet");
    }

    @Override
    public int get(long l) {
        return this.root.get(l);
    }

    @Override
    public int getMemoryUsage() {
        return Math.round(this.root.getCapacity() / 0x100000L);
    }

    int getNoNumberValue() {
        return -1;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    int height() {
        return this.height;
    }

    @Override
    public void optimize() {
        if (this.getSize() > 10000L) {
            this.root.compact();
        }
    }

    void print() {
        this.logger.info(this.root.toString(1));
    }

    @Override
    public int put(long l, int n) {
        if (l != -1L) {
            ReturnValue returnValue = this.root.put(l, n);
            if (returnValue.tree != null) {
                ++this.height;
                this.root = returnValue.tree;
            }
            if (returnValue.oldValue == -1) {
                this.size = l = this.size + 1L;
                if (l % 1000000L == 0L) {
                    this.optimize();
                }
            }
            return returnValue.oldValue;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Illegal key ");
        stringBuilder.append(l);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Height:");
        stringBuilder.append(this.height());
        stringBuilder.append(", entries:");
        stringBuilder.append(this.getEntries());
        return stringBuilder.toString();
    }

    class BTreeEntry {
        BTreeEntry[] children;
        int entrySize;
        boolean isLeaf;
        long[] keys;
        int[] values;

        public BTreeEntry(int n, boolean bl) {
            this.isLeaf = bl;
            this.keys = new long[n];
            this.values = new int[n];
            if (!bl) {
                this.children = new BTreeEntry[n + 1];
            }
        }

        BTreeEntry checkSplitEntry() {
            if (this.entrySize < GHLongIntBTree.this.maxLeafEntries) {
                return null;
            }
            int n = this.entrySize - GHLongIntBTree.this.splitIndex - 1;
            Object object = GHLongIntBTree.this;
            object = (GHLongIntBTree)object.new BTreeEntry(Math.max(((GHLongIntBTree)object).initLeafSize, n), this.isLeaf);
            this.copy(this, (BTreeEntry)object, GHLongIntBTree.this.splitIndex + 1, n);
            Object object2 = GHLongIntBTree.this;
            BTreeEntry bTreeEntry = (GHLongIntBTree)object2.new BTreeEntry(Math.max(((GHLongIntBTree)object2).initLeafSize, GHLongIntBTree.this.splitIndex), this.isLeaf);
            this.copy(this, bTreeEntry, 0, GHLongIntBTree.this.splitIndex);
            object2 = new BTreeEntry(1, false);
            ((BTreeEntry)object2).entrySize = 1;
            ((BTreeEntry)object2).keys[0] = this.keys[GHLongIntBTree.this.splitIndex];
            ((BTreeEntry)object2).values[0] = this.values[GHLongIntBTree.this.splitIndex];
            BTreeEntry[] bTreeEntryArray = ((BTreeEntry)object2).children;
            bTreeEntryArray[0] = bTreeEntry;
            bTreeEntryArray[1] = object;
            return object2;
        }

        void compact() {
            int n = this.entrySize;
            Object[] objectArray = this.keys;
            if (n + 1 < objectArray.length) {
                this.keys = Arrays.copyOf(objectArray, n);
                this.values = Arrays.copyOf(this.values, this.entrySize);
                if (!this.isLeaf) {
                    this.children = Arrays.copyOf(this.children, this.entrySize + 1);
                }
            }
            if (!this.isLeaf) {
                for (n = 0; n < (objectArray = (Object[])this.children).length; ++n) {
                    if (objectArray[n] == null) continue;
                    objectArray[n].compact();
                }
            }
        }

        void copy(BTreeEntry bTreeEntry, BTreeEntry bTreeEntry2, int n, int n2) {
            System.arraycopy(bTreeEntry.keys, n, bTreeEntry2.keys, 0, n2);
            System.arraycopy(bTreeEntry.values, n, bTreeEntry2.values, 0, n2);
            if (!bTreeEntry.isLeaf) {
                System.arraycopy(bTreeEntry.children, n, bTreeEntry2.children, 0, n2 + 1);
            }
            bTreeEntry2.entrySize = n2;
        }

        void ensureSize(int n) {
            if (n <= this.keys.length) {
                return;
            }
            n = Math.min(GHLongIntBTree.this.maxLeafEntries, Math.max(n + 1, Math.round((float)n * GHLongIntBTree.this.factor)));
            this.keys = Arrays.copyOf(this.keys, n);
            this.values = Arrays.copyOf(this.values, n);
            if (!this.isLeaf) {
                this.children = Arrays.copyOf(this.children, n + 1);
            }
        }

        int get(long l) {
            BTreeEntry[] bTreeEntryArray;
            int n = GHLongIntBTree.binarySearch(this.keys, 0, this.entrySize, l);
            if (n >= 0) {
                return this.values[n];
            }
            if (!this.isLeaf && (bTreeEntryArray = this.children)[n] != null) {
                return bTreeEntryArray[n].get(l);
            }
            return -1;
        }

        long getCapacity() {
            long l;
            long l2 = l = (long)(this.keys.length * 12 + 36 + 4 + 1);
            if (!this.isLeaf) {
                l += (long)(this.children.length * 4);
                int n = 0;
                while (true) {
                    BTreeEntry[] bTreeEntryArray = this.children;
                    l2 = l;
                    if (n >= bTreeEntryArray.length) break;
                    l2 = l;
                    if (bTreeEntryArray[n] != null) {
                        l2 = l + bTreeEntryArray[n].getCapacity();
                    }
                    ++n;
                    l = l2;
                }
            }
            return l2;
        }

        int getEntries() {
            boolean bl = this.isLeaf;
            int n = 1;
            int n2 = 1;
            if (!bl) {
                int n3 = 0;
                while (true) {
                    BTreeEntry[] bTreeEntryArray = this.children;
                    n = n2;
                    if (n3 >= bTreeEntryArray.length) break;
                    n = n2;
                    if (bTreeEntryArray[n3] != null) {
                        n = n2 + bTreeEntryArray[n3].getEntries();
                    }
                    ++n3;
                    n2 = n;
                }
            }
            return n;
        }

        void insertKeyValue(int n, long l, int n2) {
            this.ensureSize(this.entrySize + 1);
            int n3 = this.entrySize - n;
            if (n3 > 0) {
                Object[] objectArray = this.keys;
                int n4 = n + 1;
                System.arraycopy(objectArray, n, objectArray, n4, n3);
                objectArray = this.values;
                System.arraycopy(objectArray, n, objectArray, n4, n3);
                if (!this.isLeaf) {
                    objectArray = this.children;
                    System.arraycopy(objectArray, n4, objectArray, n + 2, n3);
                }
            }
            this.keys[n] = l;
            this.values[n] = n2;
            ++this.entrySize;
        }

        void insertTree(int n, BTreeEntry bTreeEntryArray) {
            this.insertKeyValue(n, bTreeEntryArray.keys[0], bTreeEntryArray.values[0]);
            if (!this.isLeaf) {
                BTreeEntry[] bTreeEntryArray2 = this.children;
                bTreeEntryArray = bTreeEntryArray.children;
                bTreeEntryArray2[n] = bTreeEntryArray[0];
                bTreeEntryArray2[n + 1] = bTreeEntryArray[1];
            }
        }

        ReturnValue put(long l, int n) {
            Object object;
            int n2 = GHLongIntBTree.binarySearch(this.keys, 0, this.entrySize, l);
            if (n2 >= 0) {
                int[] nArray = this.values;
                int n3 = nArray[n2];
                nArray[n2] = n;
                return new ReturnValue(n3);
            }
            int n4 = n2;
            if (!this.isLeaf && (object = this.children)[n4] != null) {
                object = object[n4].put(l, n);
                if (object.oldValue != -1) {
                    return object;
                }
                if (object.tree != null) {
                    BTreeEntry bTreeEntry = this.checkSplitEntry();
                    if (bTreeEntry == null) {
                        this.insertTree(n4, object.tree);
                    } else if (n4 <= GHLongIntBTree.this.splitIndex) {
                        bTreeEntry.children[0].insertTree(n4, object.tree);
                    } else {
                        bTreeEntry.children[1].insertTree(n4 - GHLongIntBTree.this.splitIndex - 1, object.tree);
                    }
                    object.tree = bTreeEntry;
                }
                return object;
            }
            object = new ReturnValue(-1);
            object.tree = this.checkSplitEntry();
            if (object.tree == null) {
                this.insertKeyValue(n4, l, n);
            } else if (n4 <= GHLongIntBTree.this.splitIndex) {
                object.tree.children[0].insertKeyValue(n4, l, n);
            } else {
                object.tree.children[1].insertKeyValue(n4 - GHLongIntBTree.this.splitIndex - 1, l, n);
            }
            return object;
        }

        String toString(int n) {
            CharSequence charSequence;
            int n2;
            CharSequence charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append(n);
            ((StringBuilder)charSequence2).append(": ");
            charSequence2 = ((StringBuilder)charSequence2).toString();
            int n3 = 0;
            for (n2 = 0; n2 < this.entrySize; ++n2) {
                charSequence = charSequence2;
                if (n2 > 0) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    ((StringBuilder)charSequence).append(",");
                    charSequence = ((StringBuilder)charSequence).toString();
                }
                if (this.keys[n2] == -1L) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append((String)charSequence);
                    ((StringBuilder)charSequence2).append("-");
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                    continue;
                }
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append(this.keys[n2]);
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("\n");
            charSequence = charSequence2 = ((StringBuilder)charSequence).toString();
            if (!this.isLeaf) {
                n2 = n3;
                while (true) {
                    charSequence = charSequence2;
                    if (n2 >= this.entrySize + 1) break;
                    charSequence = charSequence2;
                    if (this.children[n2] != null) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append((String)charSequence2);
                        ((StringBuilder)charSequence).append(this.children[n2].toString(n + 1));
                        ((StringBuilder)charSequence).append("| ");
                        charSequence = ((StringBuilder)charSequence).toString();
                    }
                    ++n2;
                    charSequence2 = charSequence;
                }
            }
            return charSequence;
        }
    }

    static class ReturnValue {
        int oldValue;
        BTreeEntry tree;

        public ReturnValue() {
        }

        public ReturnValue(int n) {
            this.oldValue = n;
        }
    }
}

