/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.util.Helper;
import java.io.PrintStream;

public class SparseIntIntArray {
    private static final int DELETED = Integer.MIN_VALUE;
    private boolean mGarbage = false;
    private int[] mKeys;
    private int mSize;
    private int[] mValues;

    public SparseIntIntArray() {
        this(10);
    }

    public SparseIntIntArray(int n) {
        int n2 = n;
        try {
            n2 = n = Helper.idealIntArraySize(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            PrintStream printStream = System.err;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("requested capacity ");
            stringBuilder.append(n2);
            printStream.println(stringBuilder.toString());
            throw outOfMemoryError;
        }
        this.mKeys = new int[n];
        n2 = n;
        this.mValues = new int[n];
        n2 = n;
        this.mSize = 0;
    }

    static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n2 + n;
        --n;
        n2 = n4;
        while (n2 - n > 1) {
            int n5 = n2 + n >>> 1;
            if (nArray[n5] < n3) {
                n = n5;
                continue;
            }
            n2 = n5;
        }
        if (n2 == n4) {
            return n4;
        }
        if (nArray[n2] == n3) {
            return n2;
        }
        return n2;
    }

    private void gc() {
        int n = this.mSize;
        int[] nArray = this.mKeys;
        int[] nArray2 = this.mValues;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2[i];
            int n4 = n2;
            if (n3 != Integer.MIN_VALUE) {
                if (i != n2) {
                    nArray[n2] = nArray[i];
                    nArray2[n2] = n3;
                }
                n4 = n2 + 1;
            }
            n2 = n4;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    private int get(int n, int n2) {
        int[] nArray;
        if ((n = SparseIntIntArray.binarySearch(this.mKeys, 0, this.mSize, n)) >= 0 && (nArray = this.mValues)[n] != Integer.MIN_VALUE) {
            return nArray[n];
        }
        return n2;
    }

    public int append(int n, int n2) {
        int n3;
        int n4 = this.mSize;
        if (n4 != 0 && n <= this.mKeys[n4 - 1]) {
            return this.put(n, n2);
        }
        if (this.mGarbage && n4 >= this.mKeys.length) {
            this.gc();
        }
        if ((n3 = this.mSize) >= this.mKeys.length) {
            n4 = Helper.idealIntArraySize(n3 + 1);
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            int[] nArray3 = this.mKeys;
            System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
            nArray3 = this.mValues;
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            this.mKeys = nArray;
            this.mValues = nArray2;
        }
        this.mKeys[n3] = n;
        this.mValues[n3] = n2;
        this.mSize = n3 + 1;
        return n3;
    }

    public int binarySearch(int n) {
        return SparseIntIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
    }

    public void clear() {
        int n = this.mSize;
        int[] nArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public int get(int n) {
        return this.get(n, -1);
    }

    public int getSize() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public int put(int n, int n2) {
        int n3 = SparseIntIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n3 >= 0) {
            this.mValues[n3] = n2;
        } else {
            int[] nArray;
            int n4 = n3;
            int n5 = this.mSize;
            if (n4 < n5 && (nArray = this.mValues)[n4] == Integer.MIN_VALUE) {
                this.mKeys[n4] = n;
                nArray[n4] = n2;
                return n4;
            }
            n3 = n4;
            if (this.mGarbage) {
                n3 = n4;
                if (n5 >= this.mKeys.length) {
                    this.gc();
                    n3 = SparseIntIntArray.binarySearch(this.mKeys, 0, this.mSize, n);
                }
            }
            if ((n4 = this.mSize) >= this.mKeys.length) {
                n4 = Helper.idealIntArraySize(n4 + 1);
                int[] nArray2 = new int[n4];
                nArray = new int[n4];
                int[] nArray3 = this.mKeys;
                System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
                nArray3 = this.mValues;
                System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
                this.mKeys = nArray2;
                this.mValues = nArray;
            }
            if ((n5 = this.mSize) - n3 != 0) {
                nArray = this.mKeys;
                n4 = n3 + 1;
                System.arraycopy(nArray, n3, nArray, n4, n5 - n3);
                nArray = this.mValues;
                System.arraycopy(nArray, n3, nArray, n4, this.mSize - n3);
            }
            this.mKeys[n3] = n;
            this.mValues[n3] = n2;
            ++this.mSize;
        }
        return n3;
    }

    public void remove(int n) {
        int[] nArray;
        if ((n = SparseIntIntArray.binarySearch(this.mKeys, 0, this.mSize, n)) >= 0 && (nArray = this.mValues)[n] != Integer.MIN_VALUE) {
            nArray[n] = Integer.MIN_VALUE;
            this.mGarbage = true;
        }
    }

    public void setKeyAt(int n, int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mKeys[n] = n2;
    }

    public void setValueAt(int n, int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getSize(); ++i) {
            int n = this.mKeys[i];
            int n2 = this.mValues[i];
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(n);
            stringBuilder.append(":");
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public int valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mValues[n];
    }
}

