/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.geohash;

import com.graphhopper.geohash.KeyAlgo;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;

public class LinearKeyAlgo
implements KeyAlgo {
    private static final double C = 0.999999999999999;
    private BBox bounds;
    private double latDelta;
    private final int latUnits;
    private double lonDelta;
    private final int lonUnits;

    public LinearKeyAlgo(int n, int n2) {
        this.latUnits = n;
        this.lonUnits = n2;
        this.setWorldBounds();
    }

    @Override
    public final void decode(long l, GHPoint gHPoint) {
        double d = l / (long)this.lonUnits;
        double d2 = this.latDelta;
        double d3 = this.bounds.minLat;
        double d4 = l % (long)this.lonUnits;
        double d5 = this.lonDelta;
        double d6 = this.bounds.minLon;
        gHPoint.lat = d * d2 + d3 + this.latDelta / 2.0;
        gHPoint.lon = d4 * d5 + d6 + this.lonDelta / 2.0;
    }

    @Override
    public final long encode(double d, double d2) {
        d = Math.min(Math.max(d, this.bounds.minLat), this.bounds.maxLat);
        d2 = Math.min(Math.max(d2, this.bounds.minLon), this.bounds.maxLon);
        long l = (long)((d - this.bounds.minLat) / this.latDelta * 0.999999999999999);
        long l2 = (long)((d2 - this.bounds.minLon) / this.lonDelta * 0.999999999999999);
        return l * (long)this.lonUnits + l2;
    }

    @Override
    public long encode(GHPoint gHPoint) {
        return this.encode(gHPoint.lat, gHPoint.lon);
    }

    public double getLatDelta() {
        return this.latDelta;
    }

    public double getLonDelta() {
        return this.lonDelta;
    }

    @Override
    public LinearKeyAlgo setBounds(double d, double d2, double d3, double d4) {
        BBox bBox;
        this.bounds = bBox = new BBox(d, d2, d3, d4);
        this.latDelta = (bBox.maxLat - this.bounds.minLat) / (double)this.latUnits;
        this.lonDelta = (this.bounds.maxLon - this.bounds.minLon) / (double)this.lonUnits;
        return this;
    }

    public LinearKeyAlgo setBounds(BBox bBox) {
        this.setBounds(bBox.minLon, bBox.maxLon, bBox.minLat, bBox.maxLat);
        return this;
    }

    protected void setWorldBounds() {
        this.setBounds(-180.0, 180.0, -90.0, 90.0);
    }
}

