/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.geohash;

import com.graphhopper.geohash.KeyAlgo;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;

public class SpatialKeyAlgo
implements KeyAlgo {
    private int allBits;
    private BBox bbox;
    private long initialBits;

    public SpatialKeyAlgo(int n) {
        this.myinit(n);
    }

    private void myinit(int n) {
        if (n <= 64) {
            if (n > 0) {
                this.allBits = n;
                this.initialBits = 1L << n - 1;
                this.setWorldBounds();
                return;
            }
            throw new IllegalStateException("allBits must be positive");
        }
        throw new IllegalStateException("allBits is too big and does not fit into 8 bytes");
    }

    public SpatialKeyAlgo bounds(BBox bBox) {
        this.bbox = bBox.clone();
        return this;
    }

    @Override
    public final void decode(long l, GHPoint gHPoint) {
        double d;
        double d2;
        double d3 = (this.bbox.maxLat - this.bbox.minLat) / 2.0;
        double d4 = (this.bbox.maxLon - this.bbox.minLon) / 2.0;
        double d5 = this.bbox.minLat;
        double d6 = this.bbox.minLon;
        long l2 = this.initialBits;
        while (true) {
            d2 = d5;
            if ((l & l2) != 0L) {
                d2 = d5 + d3;
            }
            d3 /= 2.0;
            d = d6;
            if ((l & (l2 >>>= 1)) != 0L) {
                d = d6 + d4;
            }
            d4 /= 2.0;
            if (l2 <= 1L) break;
            l2 >>>= 1;
            d5 = d2;
            d6 = d;
        }
        gHPoint.lat = d2 + d3;
        gHPoint.lon = d + d4;
    }

    @Override
    public final long encode(double d, double d2) {
        double d3 = this.bbox.minLat;
        double d4 = this.bbox.maxLat;
        double d5 = this.bbox.minLon;
        double d6 = this.bbox.maxLon;
        long l = 0L;
        int n = 0;
        while (true) {
            double d7 = d3;
            double d8 = d4;
            long l2 = l;
            if (d3 < d4) {
                d8 = (d3 + d4) / 2.0;
                if (d < d8) {
                    d7 = d3;
                    l2 = l;
                } else {
                    l2 = l | 1L;
                    d7 = d8;
                    d8 = d4;
                }
            }
            int n2 = this.allBits;
            l = l2;
            if (++n >= n2) break;
            l = l2 << 1;
            double d9 = d5;
            double d10 = d6;
            l2 = l;
            if (d5 < d6) {
                d9 = (d5 + d6) / 2.0;
                if (d2 < d9) {
                    d10 = d9;
                    d9 = d5;
                    l2 = l;
                } else {
                    l2 = 1L | l;
                    d10 = d6;
                }
            }
            l = l2;
            if (++n >= n2) break;
            l = l2 << 1;
            d3 = d7;
            d4 = d8;
            d5 = d9;
            d6 = d10;
        }
        return l;
    }

    @Override
    public long encode(GHPoint gHPoint) {
        return this.encode(gHPoint.lat, gHPoint.lon);
    }

    public int getBits() {
        return this.allBits;
    }

    public int getExactPrecision() {
        return (int)Math.log10((int)(Math.pow(2.0, this.allBits) / 360.0) + 1);
    }

    @Override
    public SpatialKeyAlgo setBounds(double d, double d2, double d3, double d4) {
        this.bounds(new BBox(d, d2, d3, d4));
        return this;
    }

    protected void setWorldBounds() {
        this.setBounds(-180.0, 180.0, -90.0, 90.0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("bits:");
        stringBuilder.append(this.allBits);
        stringBuilder.append(", bounds:");
        stringBuilder.append(this.bbox);
        return stringBuilder.toString();
    }
}

