/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;

public class PillarInfo
implements PointAccess {
    private static final int ELE = 8;
    private static final int LAT = 0;
    private static final int LON = 4;
    private final DataAccess da;
    private final Directory dir;
    private final boolean enabled3D;
    private final int rowSizeInBytes;

    public PillarInfo(boolean bl, Directory directory) {
        this.enabled3D = bl;
        this.dir = directory;
        this.da = directory.find("tmp_pillar_info").create(100L);
        this.rowSizeInBytes = this.getDimension() * 4;
    }

    private void _setNode(int n, double d, double d2, double d3) {
        this.ensureNode(n);
        long l = (long)n * (long)this.rowSizeInBytes;
        this.da.setInt(0L + l, Helper.degreeToInt(d));
        this.da.setInt(4L + l, Helper.degreeToInt(d2));
        if (this.is3D()) {
            this.da.setInt(l + 8L, Helper.eleToInt(d3));
        }
    }

    public void clear() {
        this.dir.remove(this.da);
    }

    @Override
    public void ensureNode(int n) {
        long l = n;
        n = this.rowSizeInBytes;
        long l2 = n;
        this.da.ensureCapacity(l * l2 + (long)n);
    }

    @Override
    public int getDimension() {
        int n = this.enabled3D ? 3 : 2;
        return n;
    }

    @Override
    public double getEle(int n) {
        return this.getElevation(n);
    }

    @Override
    public double getElevation(int n) {
        if (!this.is3D()) {
            return Double.NaN;
        }
        return Helper.intToEle(this.da.getInt((long)n * (long)this.rowSizeInBytes + 8L));
    }

    @Override
    public double getLat(int n) {
        return this.getLatitude(n);
    }

    @Override
    public double getLatitude(int n) {
        return Helper.intToDegree(this.da.getInt((long)n * (long)this.rowSizeInBytes + 0L));
    }

    @Override
    public double getLon(int n) {
        return this.getLongitude(n);
    }

    @Override
    public double getLongitude(int n) {
        return Helper.intToDegree(this.da.getInt((long)n * (long)this.rowSizeInBytes + 4L));
    }

    @Override
    public boolean is3D() {
        return this.enabled3D;
    }

    @Override
    public void setNode(int n, double d, double d2) {
        this._setNode(n, d, d2, Double.NaN);
    }

    @Override
    public void setNode(int n, double d, double d2, double d3) {
        this._setNode(n, d, d2, d3);
    }
}

