/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElevationProvider
implements ElevationProvider {
    boolean autoRemoveTemporary = true;
    String baseUrl;
    final File cacheDir;
    boolean calcMean = false;
    DAType daType;
    Directory dir;
    Downloader downloader;
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    long sleep = 2000L;

    protected AbstractElevationProvider(String object) {
        this.daType = DAType.MMAP;
        object = new File((String)object);
        if (((File)object).exists() && !((File)object).isDirectory()) {
            throw new IllegalArgumentException("Cache path has to be a directory");
        }
        try {
            this.cacheDir = ((File)object).getCanonicalFile();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected File getCacheDir() {
        return this.cacheDir;
    }

    protected Directory getDirectory() {
        Object object = this.dir;
        if (object != null) {
            return object;
        }
        Logger logger = this.logger;
        object = new StringBuilder();
        ((StringBuilder)object).append(this.toString());
        ((StringBuilder)object).append(" Elevation Provider, from: ");
        ((StringBuilder)object).append(this.baseUrl);
        ((StringBuilder)object).append(", to: ");
        ((StringBuilder)object).append(this.cacheDir);
        ((StringBuilder)object).append(", as: ");
        ((StringBuilder)object).append(this.daType);
        ((StringBuilder)object).append(" using calcmean: ");
        ((StringBuilder)object).append(this.calcMean);
        logger.info(((StringBuilder)object).toString());
        this.dir = object = new GHDirectory(this.cacheDir.getAbsolutePath(), this.daType);
        return object;
    }

    abstract String getDownloadURL(double var1, double var3);

    abstract String getFileName(double var1, double var3);

    @Override
    public void setAutoRemoveTemporaryFiles(boolean bl) {
        this.autoRemoveTemporary = bl;
    }

    @Override
    public ElevationProvider setBaseURL(String string2) {
        if (string2 != null && !string2.isEmpty()) {
            this.baseUrl = string2;
            return this;
        }
        throw new IllegalArgumentException("baseUrl cannot be empty");
    }

    @Override
    public void setCalcMean(boolean bl) {
        this.calcMean = bl;
    }

    @Override
    public ElevationProvider setDAType(DAType dAType) {
        this.daType = dAType;
        return this;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    void setSleep(long l) {
        this.sleep = l;
    }
}

