/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.reader.dem.AbstractElevationProvider;
import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;

public abstract class AbstractSRTMElevationProvider
extends AbstractElevationProvider {
    private static final BitUtil BIT_UTIL = BitUtil.BIG;
    private final int DEFAULT_WIDTH;
    private final int DEGREE;
    private final int WIDTH_BYTE_INDEX;
    private final GHIntObjectHashMap<HeightTile> cacheData = new GHIntObjectHashMap();
    private final double invPrecision;
    private final double precision;

    public AbstractSRTMElevationProvider(String string2, String string3, String string4, int n) {
        super(string3);
        this.WIDTH_BYTE_INDEX = 0;
        this.DEGREE = 1;
        this.precision = 1.0E7;
        this.invPrecision = 1.0E-7;
        this.baseUrl = string2;
        this.downloader = new Downloader(string4).setTimeout(10000);
        this.DEFAULT_WIDTH = n;
    }

    private byte[] getByteArrayFromFile(double d, double d2) throws InterruptedException, IOException {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.baseUrl);
        ((StringBuilder)charSequence).append(this.getDownloadURL(d, d2));
        charSequence = ((StringBuilder)charSequence).toString();
        File file = new File(this.cacheDir, new File((String)charSequence).getName());
        if (!file.exists()) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.downloader.downloadFile((String)charSequence, file.getAbsolutePath());
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (((String)charSequence).contains(".hgt.zip")) {
                        charSequence = ((String)charSequence).replace(".hgt.zip", "hgt.zip");
                        continue;
                    }
                    throw fileNotFoundException;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Thread.sleep(2000L);
                }
            }
        }
        return this.readFile(file);
    }

    private void updateHeightsFromFile(double d, double d2, DataAccess object) throws FileNotFoundException {
        Object object2 = this.getByteArrayFromFile(d, d2);
        object.create(((byte[])object2).length);
        int n = 0;
        while (true) {
            short s;
            block8: {
                if (n >= ((byte[])object2).length) break;
                short s2 = BIT_UTIL.toShort((byte[])object2, n);
                if (s2 >= -1000) {
                    s = s2;
                    if (s2 <= 12000) break block8;
                }
                s2 = Short.MIN_VALUE;
                s = s2;
            }
            object.setShort(n, s);
            n += 2;
            continue;
            break;
        }
        try {
            object.setHeader(0, ((byte[])object2).length / 2);
            object.flush();
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("There was an issue looking up the coordinates for ");
            ((StringBuilder)object).append(d);
            ((StringBuilder)object).append(",");
            ((StringBuilder)object).append(d2);
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object2 = this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("File not found for the coordinates for ");
            stringBuilder.append(d);
            stringBuilder.append(",");
            stringBuilder.append(d2);
            object2.warn(stringBuilder.toString());
            throw fileNotFoundException;
        }
    }

    int calcIntKey(double d, double d2) {
        return (this.down(d) + 90) * 1000 + this.down(d2) + 180;
    }

    int down(double d) {
        int n;
        int n2 = n = (int)d;
        if (!(d >= 0.0)) {
            n2 = (double)n - d < 1.0E-7 ? n : n - 1;
        }
        return n2;
    }

    @Override
    public double getEle(double d, double d2) {
        if (!(d >= 60.0) && !(d <= -56.0)) {
            Object object;
            d = (double)((int)(d * 1.0E7)) / 1.0E7;
            d2 = (double)((int)(d2 * 1.0E7)) / 1.0E7;
            int n = this.calcIntKey(d, d2);
            Object object2 = object = (HeightTile)this.cacheData.get(n);
            if (object == null) {
                int n2;
                boolean bl;
                if (!this.cacheDir.exists()) {
                    this.cacheDir.mkdirs();
                }
                int n3 = this.down(d);
                int n4 = this.down(d2);
                if (this.getFileName(d, d2) == null) {
                    return 0.0;
                }
                object2 = this.getDirectory();
                object = new StringBuilder();
                ((StringBuilder)object).append("dem");
                ((StringBuilder)object).append(n);
                object = object2.find(((StringBuilder)object).toString());
                try {
                    bl = object.loadExisting();
                }
                catch (Exception exception) {
                    Logger logger = this.logger;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("cannot load dem");
                    ((StringBuilder)object2).append(n);
                    ((StringBuilder)object2).append(", error:");
                    ((StringBuilder)object2).append(exception.getMessage());
                    logger.warn(((StringBuilder)object2).toString());
                    bl = false;
                }
                if (!bl) {
                    try {
                        this.updateHeightsFromFile(d, d2, (DataAccess)object);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        HeightTile heightTile = new HeightTile(n3, n4, this.DEFAULT_WIDTH, this.DEFAULT_WIDTH, 1.0E7, 1, 1);
                        this.cacheData.put(n, heightTile);
                        heightTile.setHeights((DataAccess)object);
                        heightTile.setSeaLevel(true);
                        object.setSegmentSize(100).create(10L).flush();
                        return 0.0;
                    }
                }
                int n5 = n2 = (int)(Math.sqrt(object.getHeader(0)) + 0.5);
                if (n2 == 0) {
                    n5 = this.DEFAULT_WIDTH;
                }
                object2 = new HeightTile(n3, n4, n5, n5, 1.0E7, 1, 1);
                this.cacheData.put(n, object2);
                ((HeightTile)object2).setCalcMean(this.calcMean);
                ((HeightTile)object2).setHeights((DataAccess)object);
            }
            if (((HeightTile)object2).isSeaLevel()) {
                return 0.0;
            }
            return ((HeightTile)object2).getHeight(d, d2);
        }
        return 0.0;
    }

    abstract byte[] readFile(File var1) throws IOException;

    @Override
    public void release() {
        this.cacheData.clear();
        if (this.autoRemoveTemporary && this.dir != null) {
            this.dir.clear();
        }
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean bl) {
        this.autoRemoveTemporary = bl;
    }
}

