/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;

public class GraphElevationSmoothing {
    private static final int MAX_SEARCH_DISTANCE = 150;

    public static PointList smoothElevation(PointList pointList) {
        int n = 1;
        while (n < pointList.size() - 1) {
            int n2 = n - 1;
            int n3 = n;
            while (n2 >= 0 && 150.0 > Helper.DIST_PLANE.calcDist(pointList.getLat(n), pointList.getLon(n), pointList.getLat(n2), pointList.getLon(n2))) {
                n3 = n2--;
            }
            n2 = n + 1;
            int n4 = n;
            int n5 = n2;
            while (n5 < pointList.size() && 150.0 > Helper.DIST_PLANE.calcDist(pointList.getLat(n), pointList.getLon(n), pointList.getLat(n5), pointList.getLon(n5))) {
                n5 = n4 = n5 + 1;
            }
            if (n3 != n4) {
                double d = 0.0;
                for (n5 = n3; n5 < n4; ++n5) {
                    double d2 = d;
                    if (150.0 > Helper.DIST_PLANE.calcDist(pointList.getLat(n), pointList.getLon(n), pointList.getLat(n5), pointList.getLon(n5))) {
                        d2 = d + pointList.getEle(n5);
                    }
                    d = d2;
                }
                pointList.setElevation(n, d / (double)(n4 - n3));
            }
            n = n2;
        }
        return pointList;
    }
}

