/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.storage.DataAccess;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;

public class HeightTile {
    private boolean calcMean;
    private final int height;
    private DataAccess heights;
    private final int horizontalDegree;
    private final double latHigherBound;
    private final double lonHigherBound;
    private final double lowerBound;
    private final int minLat;
    private final int minLon;
    private final int verticalDegree;
    private final int width;

    public HeightTile(int n, int n2, int n3, int n4, double d, int n5, int n6) {
        this.minLat = n;
        this.minLon = n2;
        this.width = n3;
        this.height = n4;
        this.lowerBound = -1.0 / d;
        double d2 = n5;
        d = 1.0 / d;
        this.lonHigherBound = d2 + d;
        this.latHigherBound = (double)n6 + d;
        this.horizontalDegree = n5;
        this.verticalDegree = n6;
    }

    private double includePoint(int n, AtomicInteger atomicInteger) {
        if ((n = (int)this.heights.getShort(n)) == Short.MIN_VALUE) {
            return 0.0;
        }
        atomicInteger.incrementAndGet();
        return n;
    }

    public double getHeight(double d, double d2) {
        double d3;
        double d4 = Math.abs(d - (double)this.minLat);
        double d5 = Math.abs(d2 - (double)this.minLon);
        if (!(d4 > this.latHigherBound) && !(d4 < (d3 = this.lowerBound))) {
            if (!(d5 > this.lonHigherBound) && !(d5 < d3)) {
                int n;
                int n2 = this.width;
                int n3 = n = (int)((double)(n2 / this.horizontalDegree) * d5);
                if (n >= n2) {
                    n3 = n2 - 1;
                }
                n = this.height;
                int n4 = n = n - 1 - (int)((double)(n / this.verticalDegree) * d4);
                if (n < 0) {
                    n4 = 0;
                }
                int n5 = (n2 * n4 + n3) * 2;
                short s = this.heights.getShort(n5);
                AtomicInteger atomicInteger = new AtomicInteger(1);
                if (s == Short.MIN_VALUE) {
                    return Double.NaN;
                }
                n = s;
                if (this.calcMean) {
                    n2 = s;
                    if (n3 > 0) {
                        n2 = (int)((double)s + this.includePoint(n5 - 2, atomicInteger));
                    }
                    n = n2;
                    if (n3 < this.width - 1) {
                        n = (int)((double)n2 + this.includePoint(n5 + 2, atomicInteger));
                    }
                    n2 = n;
                    if (n4 > 0) {
                        n2 = (int)((double)n + this.includePoint(n5 - this.width * 2, atomicInteger));
                    }
                    n = n2;
                    if (n4 < this.height - 1) {
                        n = (int)((double)n2 + this.includePoint(n5 + this.width * 2, atomicInteger));
                    }
                }
                return (double)n / (double)atomicInteger.get();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("longitude not in boundary of this file:");
            stringBuilder.append(d);
            stringBuilder.append(",");
            stringBuilder.append(d2);
            stringBuilder.append(", this:");
            stringBuilder.append(this.toString());
            throw new IllegalStateException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("latitude not in boundary of this file:");
        stringBuilder.append(d);
        stringBuilder.append(",");
        stringBuilder.append(d2);
        stringBuilder.append(", this:");
        stringBuilder.append(this.toString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public BufferedImage getImageFromArray(int[] nArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    public boolean isSeaLevel() {
        DataAccess dataAccess = this.heights;
        boolean bl = false;
        if (dataAccess.getHeader(0) == 1) {
            bl = true;
        }
        return bl;
    }

    protected BufferedImage makeARGB() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        long l = this.width * this.height;
        int n = 0;
        while ((long)n < l) {
            int n2 = n % this.width;
            int n3 = n / this.height;
            int n4 = Math.abs(this.heights.getShort(n * 2));
            if (n4 == 0) {
                graphics.setColor(new Color(255, 0, 0, 255));
            } else {
                int n5 = 0;
                while (n4 > 255) {
                    n4 /= 10;
                    n5 += 50;
                }
                int n6 = n5;
                if (n5 > 255) {
                    n6 = 255;
                }
                graphics.setColor(new Color(n6, n4, 122, 255));
            }
            graphics.drawLine(n2, n3, n2, n3);
            ++n;
        }
        graphics.dispose();
        return bufferedImage;
    }

    public HeightTile setCalcMean(boolean bl) {
        this.calcMean = bl;
        return this;
    }

    void setHeights(DataAccess dataAccess) {
        this.heights = dataAccess;
    }

    public HeightTile setSeaLevel(boolean bl) {
        this.heights.setHeader(0, bl ? 1 : 0);
        return this;
    }

    public void toImage(String string2) throws IOException {
        ImageIO.write((RenderedImage)this.makeARGB(), "PNG", new File(string2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.minLat);
        stringBuilder.append(",");
        stringBuilder.append(this.minLon);
        return stringBuilder.toString();
    }
}

