/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.storage.DAType;

public class MultiSourceElevationProvider
implements ElevationProvider {
    private ElevationProvider globalProvider;
    private ElevationProvider srtmProvider;

    public MultiSourceElevationProvider() {
        this(new CGIARProvider(), new GMTEDProvider());
    }

    public MultiSourceElevationProvider(ElevationProvider elevationProvider, ElevationProvider elevationProvider2) {
        this.srtmProvider = elevationProvider;
        this.globalProvider = elevationProvider2;
    }

    public MultiSourceElevationProvider(String string2) {
        this(new CGIARProvider(string2), new GMTEDProvider(string2));
    }

    @Override
    public double getEle(double d, double d2) {
        if (d < 59.999 && d > -56.0) {
            return this.srtmProvider.getEle(d, d2);
        }
        return this.globalProvider.getEle(d, d2);
    }

    @Override
    public void release() {
        this.srtmProvider.release();
        this.globalProvider.release();
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean bl) {
        this.srtmProvider.setAutoRemoveTemporaryFiles(bl);
        this.globalProvider.setAutoRemoveTemporaryFiles(bl);
    }

    @Override
    public ElevationProvider setBaseURL(String stringArray) {
        if ((stringArray = stringArray.split(";")).length == 2) {
            this.srtmProvider.setBaseURL(stringArray[0]);
            this.globalProvider.setBaseURL(stringArray[1]);
            return this;
        }
        throw new IllegalArgumentException("The base url must consist of two urls separated by a ';'. The first for cgiar, the second for gmted");
    }

    @Override
    public void setCalcMean(boolean bl) {
        this.srtmProvider.setCalcMean(bl);
        this.globalProvider.setCalcMean(bl);
    }

    @Override
    public ElevationProvider setDAType(DAType dAType) {
        this.srtmProvider.setDAType(dAType);
        this.globalProvider.setDAType(dAType);
        return this;
    }

    public String toString() {
        return "multi";
    }
}

