/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationInterpolator;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.PointList;

public class NodeElevationInterpolator {
    private final ElevationInterpolator elevationInterpolator = new ElevationInterpolator();
    private final GraphHopperStorage storage;

    public NodeElevationInterpolator(GraphHopperStorage graphHopperStorage) {
        this.storage = graphHopperStorage;
    }

    private void interpolateElevationsOfInnerNodesForNOuterNodes(int[] nArray, int[] nArray2) {
        int n;
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        PointList pointList = new PointList(nArray.length, true);
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4 = nArray[n];
            pointList.add(nodeAccess.getLat(n4), nodeAccess.getLon(n4), nodeAccess.getEle(n4));
        }
        n2 = nArray2.length;
        for (n = n3; n < n2; ++n) {
            n3 = nArray2[n];
            double d = nodeAccess.getLat(n3);
            double d2 = nodeAccess.getLon(n3);
            nodeAccess.setNode(n3, d, d2, this.elevationInterpolator.calculateElevationBasedOnPointList(d, d2, pointList));
        }
    }

    private void interpolateElevationsOfInnerNodesForOneOuterNode(int n, int[] nArray) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double d = nodeAccess.getEle(n);
        for (int n2 : nArray) {
            nodeAccess.setNode(n2, nodeAccess.getLat(n2), nodeAccess.getLon(n2), d);
        }
    }

    private void interpolateElevationsOfInnerNodesForThreeOuterNodes(int n, int n2, int n32, int[] nArray) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double d = nodeAccess.getLat(n);
        double d2 = nodeAccess.getLon(n);
        double d3 = nodeAccess.getEle(n);
        double d4 = nodeAccess.getLat(n2);
        double d5 = nodeAccess.getLon(n2);
        double d6 = nodeAccess.getEle(n2);
        double d7 = nodeAccess.getLat(n32);
        double d8 = nodeAccess.getLon(n32);
        double d9 = nodeAccess.getEle(n32);
        for (int n32 : nArray) {
            double d10 = nodeAccess.getLat(n32);
            double d11 = nodeAccess.getLon(n32);
            nodeAccess.setNode(n32, d10, d11, this.elevationInterpolator.calculateElevationBasedOnThreePoints(d10, d11, d, d2, d3, d4, d5, d6, d7, d8, d9));
        }
    }

    private void interpolateElevationsOfInnerNodesForTwoOuterNodes(int n, int n2, int[] nArray) {
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        double d = nodeAccess.getLat(n);
        double d2 = nodeAccess.getLon(n);
        double d3 = nodeAccess.getEle(n);
        double d4 = nodeAccess.getLat(n2);
        double d5 = nodeAccess.getLon(n2);
        double d6 = nodeAccess.getEle(n2);
        for (int n3 : nArray) {
            double d7 = nodeAccess.getLat(n3);
            double d8 = nodeAccess.getLon(n3);
            nodeAccess.setNode(n3, d7, d8, this.elevationInterpolator.calculateElevationBasedOnTwoPoints(d7, d8, d, d2, d3, d4, d5, d6));
        }
    }

    public void interpolateElevationsOfInnerNodes(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != 0) {
            if (n == 1) {
                this.interpolateElevationsOfInnerNodesForOneOuterNode(nArray[0], nArray2);
            } else if (n == 2) {
                this.interpolateElevationsOfInnerNodesForTwoOuterNodes(nArray[0], nArray[1], nArray2);
            } else if (n == 3) {
                this.interpolateElevationsOfInnerNodesForThreeOuterNodes(nArray[0], nArray[1], nArray[2], nArray2);
            } else if (n > 3) {
                this.interpolateElevationsOfInnerNodesForNOuterNodes(nArray, nArray2);
            }
        }
    }
}

