/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.util.Helper;
import java.util.Calendar;

public class ParsedCalendar {
    public final ParseType parseType;
    public final Calendar parsedCalendar;

    public ParsedCalendar(ParseType parseType, Calendar calendar) {
        this.parseType = parseType;
        this.parsedCalendar = calendar;
    }

    public Calendar getMax() {
        Calendar calendar;
        if (this.isDayless()) {
            calendar = this.parsedCalendar;
            calendar.set(5, calendar.getActualMaximum(5));
        }
        calendar = this.parsedCalendar;
        calendar.set(11, calendar.getActualMaximum(11));
        calendar = this.parsedCalendar;
        calendar.set(12, calendar.getActualMaximum(12));
        calendar = this.parsedCalendar;
        calendar.set(13, calendar.getActualMaximum(13));
        calendar = this.parsedCalendar;
        calendar.set(14, calendar.getActualMaximum(14));
        return this.parsedCalendar;
    }

    public Calendar getMin() {
        Calendar calendar;
        if (this.isDayless()) {
            calendar = this.parsedCalendar;
            calendar.set(5, calendar.getActualMinimum(5));
        }
        calendar = this.parsedCalendar;
        calendar.set(11, calendar.getActualMinimum(11));
        calendar = this.parsedCalendar;
        calendar.set(12, calendar.getActualMinimum(12));
        calendar = this.parsedCalendar;
        calendar.set(13, calendar.getActualMinimum(13));
        calendar = this.parsedCalendar;
        calendar.set(14, calendar.getActualMinimum(14));
        return this.parsedCalendar;
    }

    public boolean isDayOnly() {
        boolean bl = this.parseType == ParseType.DAY;
        return bl;
    }

    public boolean isDayless() {
        boolean bl = this.parseType == ParseType.MONTH || this.parseType == ParseType.YEAR_MONTH;
        return bl;
    }

    public boolean isYearless() {
        boolean bl = this.parseType == ParseType.MONTH || this.parseType == ParseType.MONTH_DAY;
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.parseType);
        stringBuilder.append("; ");
        stringBuilder.append(Helper.createFormatter().format(this.parsedCalendar.getTime()));
        return stringBuilder.toString();
    }

    public static final class ParseType
    extends Enum<ParseType> {
        private static final /* synthetic */ ParseType[] $VALUES;
        public static final /* enum */ ParseType DAY;
        public static final /* enum */ ParseType MONTH;
        public static final /* enum */ ParseType MONTH_DAY;
        public static final /* enum */ ParseType YEAR_MONTH;
        public static final /* enum */ ParseType YEAR_MONTH_DAY;

        static {
            ParseType parseType;
            ParseType parseType2;
            ParseType parseType3;
            ParseType parseType4;
            ParseType parseType5;
            YEAR_MONTH_DAY = parseType5 = new ParseType();
            YEAR_MONTH = parseType4 = new ParseType();
            MONTH_DAY = parseType3 = new ParseType();
            MONTH = parseType2 = new ParseType();
            DAY = parseType = new ParseType();
            $VALUES = new ParseType[]{parseType5, parseType4, parseType3, parseType2, parseType};
        }

        public static ParseType valueOf(String string2) {
            return Enum.valueOf(ParseType.class, string2);
        }

        public static ParseType[] values() {
            return (ParseType[])$VALUES.clone();
        }
    }
}

