/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.PriorityQueue;

public class AStar
extends AbstractRoutingAlgorithm {
    private AStarEntry currEdge;
    private GHIntObjectHashMap<AStarEntry> fromMap;
    private PriorityQueue<AStarEntry> prioQueueOpenSet;
    private int to1 = -1;
    private int visitedCount;
    private WeightApproximator weightApprox;

    public AStar(Graph object, Weighting weighting, TraversalMode traversalMode) {
        super((Graph)object, weighting, traversalMode);
        this.initCollections(Math.min(Math.max(200, object.getNodes() / 10), 2000));
        object = new BeelineWeightApproximator(this.nodeAccess, weighting);
        ((BeelineWeightApproximator)object).setDistanceCalc(Helper.DIST_PLANE);
        this.setApproximation((WeightApproximator)object);
    }

    private Path runAlgo() {
        AStarEntry aStarEntry;
        EdgeExplorer edgeExplorer = this.outEdgeExplorer;
        do {
            int n = this.currEdge.adjNode;
            ++this.visitedCount;
            if (this.isMaxVisitedNodesExceeded()) {
                return this.createEmptyPath();
            }
            if (this.finished()) {
                return this.extractPath();
            }
            EdgeIterator edgeIterator = edgeExplorer.setBaseNode(n);
            while (edgeIterator.next()) {
                double d;
                if (!this.accept(edgeIterator, this.currEdge.edge) || Double.isInfinite(d = this.weighting.calcWeight(edgeIterator, false, this.currEdge.edge) + this.currEdge.weightOfVisitedPath) || (aStarEntry = (AStarEntry)this.fromMap.get(n = this.traversalMode.createTraversalId(edgeIterator, false))) != null && !(aStarEntry.weightOfVisitedPath > d)) continue;
                int n2 = edgeIterator.getAdjNode();
                double d2 = d + this.weightApprox.approximate(n2);
                if (aStarEntry == null) {
                    aStarEntry = new AStarEntry(edgeIterator.getEdge(), n2, d2, d);
                    this.fromMap.put(n, aStarEntry);
                } else {
                    this.prioQueueOpenSet.remove(aStarEntry);
                    aStarEntry.edge = edgeIterator.getEdge();
                    aStarEntry.weight = d2;
                    aStarEntry.weightOfVisitedPath = d;
                }
                aStarEntry.parent = this.currEdge;
                this.prioQueueOpenSet.add(aStarEntry);
                this.updateBestPath(edgeIterator, aStarEntry, n);
            }
            if (this.prioQueueOpenSet.isEmpty()) {
                return this.createEmptyPath();
            }
            this.currEdge = aStarEntry = this.prioQueueOpenSet.poll();
        } while (aStarEntry != null);
        throw new AssertionError((Object)"Empty edge cannot happen");
    }

    @Override
    public Path calcPath(int n, int n2) {
        this.checkAlreadyRun();
        this.to1 = n2;
        this.weightApprox.setTo(n2);
        this.currEdge = new AStarEntry(-1, n, this.weightApprox.approximate(n) + 0.0, 0.0);
        if (!this.traversalMode.isEdgeBased()) {
            this.fromMap.put(n, this.currEdge);
        }
        return this.runAlgo();
    }

    @Override
    protected Path extractPath() {
        return new Path(this.graph, this.weighting).setWeight(this.currEdge.weight).setSPTEntry(this.currEdge).extract();
    }

    @Override
    protected boolean finished() {
        boolean bl = this.currEdge.adjNode == this.to1;
        return bl;
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("astar|");
        stringBuilder.append(this.weightApprox);
        return stringBuilder.toString();
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCount;
    }

    protected void initCollections(int n) {
        this.fromMap = new GHIntObjectHashMap();
        this.prioQueueOpenSet = new PriorityQueue(n);
    }

    public AStar setApproximation(WeightApproximator weightApproximator) {
        this.weightApprox = weightApproximator;
        return this;
    }

    protected void updateBestPath(EdgeIteratorState edgeIteratorState, SPTEntry sPTEntry, int n) {
    }

    public static class AStarEntry
    extends SPTEntry {
        double weightOfVisitedPath;

        public AStarEntry(int n, int n2, double d, double d2) {
            super(n, n2, d);
            this.weightOfVisitedPath = d2;
        }

        @Override
        public AStarEntry getParent() {
            return (AStarEntry)this.parent;
        }

        @Override
        public final double getWeightOfVisitedPath() {
            return this.weightOfVisitedPath;
        }
    }
}

