/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRoutingAlgorithm
implements RoutingAlgorithm {
    protected EdgeFilter additionalEdgeFilter;
    private boolean alreadyRun;
    protected final FlagEncoder flagEncoder;
    protected final Graph graph;
    protected EdgeExplorer inEdgeExplorer;
    protected int maxVisitedNodes = Integer.MAX_VALUE;
    protected NodeAccess nodeAccess;
    protected EdgeExplorer outEdgeExplorer;
    protected final TraversalMode traversalMode;
    protected final Weighting weighting;

    public AbstractRoutingAlgorithm(Graph graph, Weighting object, TraversalMode traversalMode) {
        this.weighting = object;
        this.flagEncoder = object = object.getFlagEncoder();
        this.traversalMode = traversalMode;
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.outEdgeExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges((FlagEncoder)object));
        this.inEdgeExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.inEdges((FlagEncoder)object));
    }

    protected boolean accept(EdgeIteratorState edgeIteratorState, int n) {
        boolean bl = this.traversalMode.hasUTurnSupport();
        boolean bl2 = false;
        if (!bl && edgeIteratorState.getEdge() == n) {
            return false;
        }
        EdgeFilter edgeFilter = this.additionalEdgeFilter;
        if (edgeFilter == null || edgeFilter.accept(edgeIteratorState)) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public List<Path> calcPaths(int n, int n2) {
        return Collections.singletonList(this.calcPath(n, n2));
    }

    protected void checkAlreadyRun() {
        if (!this.alreadyRun) {
            this.alreadyRun = true;
            return;
        }
        throw new IllegalStateException("Create a new instance per call");
    }

    protected Path createEmptyPath() {
        return new Path(this.graph, this.weighting);
    }

    protected abstract Path extractPath();

    protected abstract boolean finished();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected boolean isMaxVisitedNodesExceeded() {
        boolean bl = this.maxVisitedNodes < this.getVisitedNodes();
        return bl;
    }

    public RoutingAlgorithm setEdgeFilter(EdgeFilter edgeFilter) {
        this.additionalEdgeFilter = edgeFilter;
        return this;
    }

    @Override
    public void setMaxVisitedNodes(int n) {
        this.maxVisitedNodes = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(this.weighting);
        return stringBuilder.toString();
    }
}

