/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.PMap;

public class AlgorithmOptions {
    private String algorithm = "dijkstrabi";
    private final PMap hints = new PMap(5);
    private int maxVisitedNodes;
    private TraversalMode traversalMode = TraversalMode.NODE_BASED;
    private Weighting weighting;

    private AlgorithmOptions() {
        this.maxVisitedNodes = Integer.MAX_VALUE;
    }

    public AlgorithmOptions(String string2, Weighting weighting) {
        this.maxVisitedNodes = Integer.MAX_VALUE;
        this.algorithm = string2;
        this.weighting = weighting;
    }

    public AlgorithmOptions(String string2, Weighting weighting, TraversalMode traversalMode) {
        this.maxVisitedNodes = Integer.MAX_VALUE;
        this.algorithm = string2;
        this.weighting = weighting;
        this.traversalMode = traversalMode;
    }

    static /* synthetic */ TraversalMode access$102(AlgorithmOptions algorithmOptions, TraversalMode traversalMode) {
        algorithmOptions.traversalMode = traversalMode;
        return traversalMode;
    }

    static /* synthetic */ Weighting access$202(AlgorithmOptions algorithmOptions, Weighting weighting) {
        algorithmOptions.weighting = weighting;
        return weighting;
    }

    static /* synthetic */ String access$302(AlgorithmOptions algorithmOptions, String string2) {
        algorithmOptions.algorithm = string2;
        return string2;
    }

    static /* synthetic */ int access$402(AlgorithmOptions algorithmOptions, int n) {
        algorithmOptions.maxVisitedNodes = n;
        return n;
    }

    private void assertNotNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Option '");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("' must NOT be null");
        throw new NullPointerException(((StringBuilder)object).toString());
    }

    public static Builder start() {
        return new Builder();
    }

    public static Builder start(AlgorithmOptions algorithmOptions) {
        int n;
        Builder builder = new Builder();
        if (algorithmOptions.algorithm != null) {
            builder.algorithm(algorithmOptions.getAlgorithm());
        }
        if (algorithmOptions.traversalMode != null) {
            builder.traversalMode(algorithmOptions.getTraversalMode());
        }
        if (algorithmOptions.weighting != null) {
            builder.weighting(algorithmOptions.getWeighting());
        }
        if ((n = algorithmOptions.maxVisitedNodes) >= 0) {
            builder.maxVisitedNodes(n);
        }
        if (!algorithmOptions.hints.isEmpty()) {
            builder.hints(algorithmOptions.hints);
        }
        return builder;
    }

    public String getAlgorithm() {
        this.assertNotNull(this.algorithm, "algorithm");
        return this.algorithm;
    }

    public PMap getHints() {
        return this.hints;
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    public Weighting getWeighting() {
        this.assertNotNull(this.weighting, "weighting");
        return this.weighting;
    }

    public boolean hasWeighting() {
        boolean bl = this.weighting != null;
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.algorithm);
        stringBuilder.append(", ");
        stringBuilder.append(this.weighting);
        stringBuilder.append(", ");
        stringBuilder.append((Object)this.traversalMode);
        return stringBuilder.toString();
    }

    public static class Builder {
        private boolean buildCalled;
        private AlgorithmOptions opts = new AlgorithmOptions();

        public Builder algorithm(String string2) {
            AlgorithmOptions.access$302(this.opts, string2);
            return this;
        }

        public AlgorithmOptions build() {
            if (!this.buildCalled) {
                this.buildCalled = true;
                return this.opts;
            }
            throw new IllegalStateException("Cannot call AlgorithmOptions.Builder.build() twice");
        }

        public Builder hints(PMap pMap) {
            this.opts.hints.put(pMap);
            return this;
        }

        public Builder maxVisitedNodes(int n) {
            AlgorithmOptions.access$402(this.opts, n);
            return this;
        }

        public Builder traversalMode(TraversalMode traversalMode) {
            if (traversalMode != null) {
                AlgorithmOptions.access$102(this.opts, traversalMode);
                return this;
            }
            throw new IllegalArgumentException("null as traversal mode is not allowed");
        }

        public Builder weighting(Weighting weighting) {
            AlgorithmOptions.access$202(this.opts, weighting);
            return this;
        }
    }
}

