/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.Path4CH;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;

public class DijkstraBidirectionCHNoSOD
extends DijkstraBidirectionRef {
    public DijkstraBidirectionCHNoSOD(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        super(graph, weighting, traversalMode);
        if (!traversalMode.isEdgeBased()) {
            return;
        }
        throw new IllegalArgumentException("Edge based traversal is not supported for CH");
    }

    @Override
    protected Path createAndInitPath() {
        this.bestPath = new Path4CH(this.graph, this.graph.getBaseGraph(), this.weighting);
        return this.bestPath;
    }

    @Override
    public boolean finished() {
        boolean bl = this.finishedFrom;
        boolean bl2 = true;
        if (bl && this.finishedTo) {
            return true;
        }
        if (!(this.currFrom.weight >= this.bestPath.getWeight()) || !(this.currTo.weight >= this.bestPath.getWeight())) {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public String getName() {
        return "dijkstrabi|ch|no_sod";
    }

    @Override
    protected void initCollections(int n) {
        super.initCollections(Math.min(n, 2000));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(this.weighting);
        return stringBuilder.toString();
    }
}

