/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class InstructionsOutgoingEdges {
    final List<EdgeIteratorState> allOutgoingEdges;
    final List<EdgeIteratorState> allowedOutgoingEdges;
    final EdgeIteratorState currentEdge;
    final FlagEncoder encoder;
    final NodeAccess nodeAccess;
    final EdgeIteratorState prevEdge;

    public InstructionsOutgoingEdges(EdgeIteratorState edgeIteratorState, EdgeIteratorState edgeIteratorState2, FlagEncoder flagEncoder, EdgeExplorer edgeExplorer, NodeAccess nodeAccess, int n, int n2, int n3) {
        this.prevEdge = edgeIteratorState;
        this.currentEdge = edgeIteratorState2;
        this.encoder = flagEncoder;
        this.nodeAccess = nodeAccess;
        this.allOutgoingEdges = new ArrayList<EdgeIteratorState>();
        this.allowedOutgoingEdges = new ArrayList<EdgeIteratorState>();
        edgeIteratorState2 = edgeExplorer.setBaseNode(n2);
        while (edgeIteratorState2.next()) {
            if (edgeIteratorState2.getAdjNode() == n || edgeIteratorState2.getAdjNode() == n3) continue;
            edgeIteratorState = edgeIteratorState2.detach(false);
            this.allOutgoingEdges.add(edgeIteratorState);
            if (!flagEncoder.isForward(edgeIteratorState.getFlags())) continue;
            this.allowedOutgoingEdges.add(edgeIteratorState);
        }
    }

    private double getSpeed(EdgeIteratorState edgeIteratorState) {
        FlagEncoder flagEncoder = this.encoder;
        if (flagEncoder instanceof DataFlagEncoder) {
            return ((DataFlagEncoder)flagEncoder).getMaxspeed(edgeIteratorState, 0, false);
        }
        return flagEncoder.getSpeed(edgeIteratorState.getFlags());
    }

    private boolean isTheSameStreet(String string2, long l, String string3, long l2, boolean bl) {
        return InstructionsHelper.isNameSimilar(string2, string3) && (!bl || l == l2);
    }

    public EdgeIteratorState getOtherContinue(double d, double d2, double d3) {
        for (EdgeIteratorState edgeIteratorState : this.allowedOutgoingEdges) {
            GHPoint gHPoint = InstructionsHelper.getPointForOrientationCalculation(edgeIteratorState, this.nodeAccess);
            if (Math.abs(InstructionsHelper.calculateSign(d, d2, gHPoint.getLat(), gHPoint.getLon(), d3)) > 1) continue;
            return edgeIteratorState;
        }
        return null;
    }

    public boolean isLeavingCurrentStreet(String string2, String string3) {
        if (InstructionsHelper.isNameSimilar(string3, string2)) {
            return false;
        }
        boolean bl = this.currentEdge.getFlags() != this.prevEdge.getFlags();
        for (EdgeIteratorState edgeIteratorState : this.allowedOutgoingEdges) {
            String string4 = edgeIteratorState.getName();
            long l = edgeIteratorState.getFlags();
            if (!this.isTheSameStreet(string2, this.prevEdge.getFlags(), string4, l, bl) && !this.isTheSameStreet(string3, this.currentEdge.getFlags(), string4, l, bl)) continue;
            return true;
        }
        return false;
    }

    public int nrOfAllOutgoingEdges() {
        return this.allOutgoingEdges.size() + 1;
    }

    public int nrOfAllowedOutgoingEdges() {
        return this.allowedOutgoingEdges.size() + 1;
    }

    public boolean outgoingEdgesAreSlowerByFactor(double d) {
        boolean bl;
        double d2 = this.getSpeed(this.currentEdge);
        double d3 = this.getSpeed(this.prevEdge);
        boolean bl2 = bl = false;
        if (d3 == d2) {
            if (d3 < 1.0) {
                bl2 = bl;
            } else {
                d2 = -1.0;
                Iterator<EdgeIteratorState> iterator2 = this.allOutgoingEdges.iterator();
                while (iterator2.hasNext()) {
                    double d4 = this.getSpeed(iterator2.next());
                    if (d4 < 1.0) {
                        return false;
                    }
                    if (!(d4 > d2)) continue;
                    d2 = d4;
                }
                bl2 = bl;
                if (d2 * d < d3) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }
}

