/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHIntArrayList;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Path {
    private List<String> description;
    protected double distance;
    private GHIntArrayList edgeIds;
    private FlagEncoder encoder;
    protected int endNode = -1;
    final StopWatch extractSW;
    private boolean found;
    private int fromNode = -1;
    protected Graph graph;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NodeAccess nodeAccess;
    protected boolean reverseOrder = true;
    protected SPTEntry sptEntry;
    protected long time;
    private double weight;
    protected Weighting weighting;

    Path(Path path) {
        this(path.graph, path.weighting);
        this.weight = path.weight;
        this.edgeIds = new GHIntArrayList(path.edgeIds);
        this.sptEntry = path.sptEntry;
    }

    public Path(Graph graph, Weighting weighting) {
        this.extractSW = new StopWatch("extract");
        this.weight = Double.MAX_VALUE;
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.weighting = weighting;
        this.encoder = weighting.getFlagEncoder();
        this.edgeIds = new GHIntArrayList();
    }

    private void forEveryEdge(EdgeVisitor object) {
        int n = this.getFromNode();
        int n2 = this.edgeIds.size();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            EdgeIteratorState edgeIteratorState = this.graph.getEdgeIteratorState(this.edgeIds.get(i), n);
            if (edgeIteratorState != null) {
                n = edgeIteratorState.getBaseNode();
                edgeIteratorState = this.graph.getEdgeIteratorState(edgeIteratorState.getEdge(), n);
                object.next(edgeIteratorState, i, n3);
                n3 = edgeIteratorState.getEdge();
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Edge ");
            ((StringBuilder)object).append(this.edgeIds.get(i));
            ((StringBuilder)object).append(" was empty when requested with node ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(", array index:");
            ((StringBuilder)object).append(i);
            ((StringBuilder)object).append(", edges:");
            ((StringBuilder)object).append(this.edgeIds.size());
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        object.finish();
    }

    private int getFromNode() {
        int n = this.fromNode;
        if (n >= 0) {
            return n;
        }
        throw new IllegalStateException("Call extract() before retrieving fromNode");
    }

    protected void addEdge(int n) {
        this.edgeIds.add(n);
    }

    public Map<String, List<PathDetail>> calcDetails(List<String> entry, PathDetailsBuilderFactory object, int n) {
        if (this.isFound() && !entry.isEmpty()) {
            if ((entry = ((PathDetailsBuilderFactory)object).createPathDetailsBuilders((List<String>)((Object)entry), this.encoder, this.weighting)).isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            this.forEveryEdge(new PathDetailsFromEdges((List<PathDetailsBuilder>)((Object)entry), n));
            object = new HashMap(entry.size());
            Iterator<Object> iterator2 = entry.iterator();
            while (iterator2.hasNext()) {
                entry = ((PathDetailsBuilder)iterator2.next()).build();
                if ((List)object.put(entry.getKey(), entry.getValue()) == null) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("Some PathDetailsBuilders use duplicate key: ");
                ((StringBuilder)object).append((String)entry.getKey());
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            return object;
        }
        return Collections.EMPTY_MAP;
    }

    public List<EdgeIteratorState> calcEdges() {
        final ArrayList<EdgeIteratorState> arrayList = new ArrayList<EdgeIteratorState>(this.edgeIds.size());
        if (this.edgeIds.isEmpty()) {
            return arrayList;
        }
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void finish() {
            }

            @Override
            public void next(EdgeIteratorState edgeIteratorState, int n, int n2) {
                arrayList.add(edgeIteratorState);
            }
        });
        return arrayList;
    }

    public InstructionList calcInstructions(Translation translation) {
        InstructionList instructionList = new InstructionList(this.edgeIds.size() / 4, translation);
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                instructionList.add(new FinishInstruction(this.nodeAccess, this.endNode));
            }
            return instructionList;
        }
        this.forEveryEdge(new InstructionsFromEdges(this.getFromNode(), this.graph, this.weighting, this.encoder, this.nodeAccess, translation, instructionList));
        return instructionList;
    }

    public IntIndexedContainer calcNodes() {
        final IntArrayList intArrayList = new IntArrayList(this.edgeIds.size() + 1);
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                intArrayList.add(this.endNode);
            }
            return intArrayList;
        }
        intArrayList.add(this.getFromNode());
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void finish() {
            }

            @Override
            public void next(EdgeIteratorState edgeIteratorState, int n, int n2) {
                intArrayList.add(edgeIteratorState.getAdjNode());
            }
        });
        return intArrayList;
    }

    public PointList calcPoints() {
        final PointList pointList = new PointList(this.edgeIds.size() + 1, this.nodeAccess.is3D());
        if (this.edgeIds.isEmpty()) {
            if (this.isFound()) {
                pointList.add(this.graph.getNodeAccess(), this.endNode);
            }
            return pointList;
        }
        int n = this.getFromNode();
        pointList.add(this.nodeAccess, n);
        this.forEveryEdge(new EdgeVisitor(){

            @Override
            public void finish() {
            }

            @Override
            public void next(EdgeIteratorState object, int n, int n2) {
                object = object.fetchWayGeometry(2);
                for (n = 0; n < ((PointList)object).getSize(); ++n) {
                    pointList.add((PointAccess)object, n);
                }
            }
        });
        return pointList;
    }

    public Path extract() {
        if (!this.isFound()) {
            this.extractSW.start();
            SPTEntry sPTEntry = this.sptEntry;
            this.setEndNode(sPTEntry.adjNode);
            boolean bl = EdgeIterator.Edge.isValid(sPTEntry.edge);
            while (bl) {
                bl = EdgeIterator.Edge.isValid(sPTEntry.parent.edge);
                int n = bl ? sPTEntry.parent.edge : -1;
                this.processEdge(sPTEntry.edge, sPTEntry.adjNode, n);
                sPTEntry = sPTEntry.parent;
            }
            this.setFromNode(sPTEntry.adjNode);
            this.reverseOrder();
            this.extractSW.stop();
            return this.setFound(true);
        }
        throw new IllegalStateException("Extract can only be called once");
    }

    public String getDebugInfo() {
        return this.extractSW.toString();
    }

    public List<String> getDescription() {
        List<String> list;
        List<String> list2 = list = this.description;
        if (list == null) {
            list2 = Collections.emptyList();
        }
        return list2;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getEdgeCount() {
        return this.edgeIds.size();
    }

    public long getExtractTime() {
        return this.extractSW.getNanos();
    }

    public EdgeIteratorState getFinalEdge() {
        Graph graph = this.graph;
        GHIntArrayList gHIntArrayList = this.edgeIds;
        return graph.getEdgeIteratorState(gHIntArrayList.get(gHIntArrayList.size() - 1), this.endNode);
    }

    public long getTime() {
        return this.time;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isFound() {
        return this.found;
    }

    protected void processEdge(int n, int n2, int n3) {
        EdgeIteratorState edgeIteratorState = this.graph.getEdgeIteratorState(n, n2);
        this.distance += edgeIteratorState.getDistance();
        this.time += this.weighting.calcMillis(edgeIteratorState, false, n3);
        this.addEdge(n);
    }

    void reverseOrder() {
        if (this.reverseOrder) {
            this.reverseOrder = false;
            this.edgeIds.reverse();
            return;
        }
        throw new IllegalStateException("Switching order multiple times is not supported");
    }

    public Path setDescription(List<String> list) {
        this.description = list;
        return this;
    }

    public Path setDistance(double d) {
        this.distance = d;
        return this;
    }

    protected Path setEndNode(int n) {
        this.endNode = n;
        return this;
    }

    public Path setFound(boolean bl) {
        this.found = bl;
        return this;
    }

    protected Path setFromNode(int n) {
        this.fromNode = n;
        return this;
    }

    public Path setSPTEntry(SPTEntry sPTEntry) {
        this.sptEntry = sPTEntry;
        return this;
    }

    public Path setWeight(double d) {
        this.weight = d;
        return this;
    }

    public String toDetailsString() {
        CharSequence charSequence;
        CharSequence charSequence2 = "";
        for (int i = 0; i < this.edgeIds.size(); ++i) {
            charSequence = charSequence2;
            if (i > 0) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append("->");
                charSequence = ((StringBuilder)charSequence).toString();
            }
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(this.edgeIds.get(i));
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.toString());
        ((StringBuilder)charSequence).append(", found:");
        ((StringBuilder)charSequence).append(this.isFound());
        ((StringBuilder)charSequence).append(", ");
        ((StringBuilder)charSequence).append((String)charSequence2);
        return ((StringBuilder)charSequence).toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("distance:");
        stringBuilder.append(this.getDistance());
        stringBuilder.append(", edges:");
        stringBuilder.append(this.edgeIds.size());
        return stringBuilder.toString();
    }

    public static interface EdgeVisitor {
        public void finish();

        public void next(EdgeIteratorState var1, int var2, int var3);
    }
}

