/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import java.util.ArrayList;
import java.util.List;

class VirtualEdgeIterator
implements EdgeIterator,
CHEdgeIteratorState {
    private int current;
    private final List<EdgeIteratorState> edges;

    public VirtualEdgeIterator(int n) {
        this.edges = new ArrayList<EdgeIteratorState>(n);
        this.reset();
    }

    void add(EdgeIteratorState edgeIteratorState) {
        this.edges.add(edgeIteratorState);
    }

    @Override
    public EdgeIteratorState copyPropertiesTo(EdgeIteratorState edgeIteratorState) {
        return this.edges.get(this.current).copyPropertiesTo(edgeIteratorState);
    }

    int count() {
        return this.edges.size();
    }

    @Override
    public EdgeIteratorState detach(boolean bl) {
        if (!bl) {
            return this.edges.get(this.current);
        }
        throw new IllegalStateException("Not yet supported");
    }

    @Override
    public PointList fetchWayGeometry(int n) {
        return this.edges.get(this.current).fetchWayGeometry(n);
    }

    @Override
    public int getAdditionalField() {
        return this.edges.get(this.current).getAdditionalField();
    }

    @Override
    public int getAdjNode() {
        return this.edges.get(this.current).getAdjNode();
    }

    @Override
    public int getBaseNode() {
        return this.edges.get(this.current).getBaseNode();
    }

    @Override
    public boolean getBool(int n, boolean bl) {
        return this.edges.get(this.current).getBool(n, bl);
    }

    @Override
    public double getDistance() {
        return this.edges.get(this.current).getDistance();
    }

    @Override
    public int getEdge() {
        return this.edges.get(this.current).getEdge();
    }

    @Override
    public long getFlags() {
        return this.edges.get(this.current).getFlags();
    }

    @Override
    public int getMergeStatus(long l) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getName() {
        return this.edges.get(this.current).getName();
    }

    @Override
    public int getSkippedEdge1() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getSkippedEdge2() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double getWeight() {
        return ((CHEdgeIteratorState)this.edges.get(this.current)).getWeight();
    }

    @Override
    public boolean isBackward(FlagEncoder flagEncoder) {
        return this.edges.get(this.current).isBackward(flagEncoder);
    }

    @Override
    public boolean isForward(FlagEncoder flagEncoder) {
        return this.edges.get(this.current).isForward(flagEncoder);
    }

    @Override
    public boolean isShortcut() {
        EdgeIteratorState edgeIteratorState = this.edges.get(this.current);
        boolean bl = edgeIteratorState instanceof CHEdgeIteratorState && ((CHEdgeIteratorState)edgeIteratorState).isShortcut();
        return bl;
    }

    @Override
    public boolean next() {
        int n = this.current;
        boolean bl = true;
        this.current = ++n;
        if (n >= this.edges.size()) {
            bl = false;
        }
        return bl;
    }

    EdgeIterator reset() {
        this.current = -1;
        return this;
    }

    @Override
    public EdgeIteratorState setAdditionalField(int n) {
        return this.edges.get(this.current).setAdditionalField(n);
    }

    @Override
    public EdgeIteratorState setDistance(double d) {
        return this.edges.get(this.current).setDistance(d);
    }

    @Override
    public EdgeIteratorState setFlags(long l) {
        return this.edges.get(this.current).setFlags(l);
    }

    @Override
    public EdgeIteratorState setName(String string2) {
        return this.edges.get(this.current).setName(string2);
    }

    @Override
    public void setSkippedEdges(int n, int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public EdgeIteratorState setWayGeometry(PointList pointList) {
        return this.edges.get(this.current).setWayGeometry(pointList);
    }

    @Override
    public CHEdgeIteratorState setWeight(double d) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String toString() {
        return this.edges.toString();
    }
}

