/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;

abstract class AbstractNodeContractor
implements NodeContractor {
    final FlagEncoder encoder;
    private final GraphHopperStorage ghStorage;
    CHEdgeExplorer inEdgeExplorer;
    private int maxEdgesCount;
    int maxLevel;
    private final DataAccess originalEdges;
    CHEdgeExplorer outEdgeExplorer;
    final CHGraph prepareGraph;

    public AbstractNodeContractor(Directory object, GraphHopperStorage object2, CHGraph cHGraph, Weighting weighting) {
        this.ghStorage = object2;
        this.prepareGraph = cHGraph;
        this.encoder = weighting.getFlagEncoder();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("original_edges_");
        ((StringBuilder)object2).append(AbstractWeighting.weightingToFileName(weighting));
        this.originalEdges = object = object.find(((StringBuilder)object2).toString());
        object.create(1000L);
    }

    @Override
    public void close() {
        this.originalEdges.close();
    }

    int getOrigEdgeCount(int n) {
        if ((n -= this.maxEdgesCount) < 0) {
            return 1;
        }
        long l = (long)n * 4L;
        this.originalEdges.ensureCapacity(4L + l);
        return this.originalEdges.getInt(l);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createEdgeExplorer(DefaultEdgeFilter.inEdges(this.encoder));
        this.outEdgeExplorer = this.prepareGraph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.encoder));
        this.maxLevel = this.prepareGraph.getNodes();
        this.maxEdgesCount = this.ghStorage.getAllEdges().length();
    }

    boolean isContracted(int n) {
        boolean bl = this.prepareGraph.getLevel(n) != this.maxLevel;
        return bl;
    }

    void setOrigEdgeCount(int n, int n2) {
        if ((n -= this.maxEdgesCount) < 0) {
            if (n2 == 1) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Trying to set original edge count for normal edge to a value = ");
            stringBuilder.append(n2);
            stringBuilder.append(", edge:");
            stringBuilder.append(n + this.maxEdgesCount);
            stringBuilder.append(", max:");
            stringBuilder.append(this.maxEdgesCount);
            stringBuilder.append(", graph.max:");
            stringBuilder.append(this.prepareGraph.getAllEdges().length());
            throw new IllegalStateException(stringBuilder.toString());
        }
        long l = (long)n * 4L;
        this.originalEdges.ensureCapacity(4L + l);
        this.originalEdges.setInt(l, n2);
    }
}

