/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;

public class PreparationWeighting
implements Weighting {
    private final Weighting userWeighting;

    public PreparationWeighting(Weighting weighting) {
        this.userWeighting = weighting;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        return this.userWeighting.calcMillis(edgeIteratorState, bl, n);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        CHEdgeIteratorState cHEdgeIteratorState = (CHEdgeIteratorState)edgeIteratorState;
        if (cHEdgeIteratorState.isShortcut()) {
            return cHEdgeIteratorState.getWeight();
        }
        return this.userWeighting.calcWeight(edgeIteratorState, bl, n);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.userWeighting.getFlagEncoder();
    }

    @Override
    public final double getMinWeight(double d) {
        return this.userWeighting.getMinWeight(d);
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("prepare|");
        stringBuilder.append(this.userWeighting.getName());
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(HintsMap hintsMap) {
        boolean bl = this.getName().equals(hintsMap.getWeighting()) && this.userWeighting.getFlagEncoder().toString().equals(hintsMap.getVehicle());
        return bl;
    }

    public String toString() {
        return this.getName();
    }
}

